/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.hull;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.BlockAbstractOmnipanel;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockHullOmnipanel
extends BlockAbstractOmnipanel
implements IDamageReceiver {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    final byte tier;

    public BlockHullOmnipanel(byte tier) {
        super(Material.field_151592_s);
        this.tier = tier;
        this.func_149711_c(WarpDriveConfig.HULL_HARDNESS[tier - 1]);
        this.func_149752_b(WarpDriveConfig.HULL_BLAST_RESISTANCE[tier - 1] * 5.0f / 3.0f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149663_c("warpdrive.hull" + tier + ".omnipanel.");
        this.func_149658_d("warpdrive:hull/glass");
        this.func_149715_a(0.6666667f);
    }

    public int func_149656_h() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[metadata % 16];
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public static String getDyeColorName(int metadata) {
        return ItemDye.field_150921_b[~metadata & 0xF];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < 16; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.func_149641_N() + "_" + BlockHullOmnipanel.getDyeColorName(i));
        }
    }

    public MapColor func_149728_f(int metadata) {
        return MapColor.func_151644_a((int)metadata);
    }

    @Override
    public byte getTier(ItemStack itemStack) {
        return this.tier;
    }

    @Override
    public float getBlockHardness(World world, int x, int y, int z, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        return WarpDriveConfig.HULL_HARDNESS[this.tier - 1];
    }

    @Override
    public int applyDamage(World world, int x, int y, int z, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        if (damageLevel <= 0) {
            return 0;
        }
        if (this.tier == 1) {
            world.func_147468_f(x, y, z);
        } else {
            int metadata = world.func_72805_g(x, y, z);
            world.func_147465_d(x, y, z, WarpDrive.blockHulls_omnipanel[this.tier - 2], metadata, 2);
        }
        return 0;
    }
}

