/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.hull;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.block.hull.BlockHullPlain;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHullSlab
extends BlockSlab
implements IBlockBase,
IDamageReceiver {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconPlainFull;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTiledFull;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTiledHorizontal;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTiledVertical;
    @Deprecated
    private int metadataForRender;
    final byte tier;
    private final int metaHull;

    public BlockHullSlab(int metaHull, byte tier) {
        super(false, Material.field_151576_e);
        this.tier = tier;
        this.metaHull = metaHull;
        this.func_149711_c(WarpDriveConfig.HULL_HARDNESS[tier - 1]);
        this.func_149752_b(WarpDriveConfig.HULL_BLAST_RESISTANCE[tier - 1] * 5.0f / 3.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(WarpDrive.creativeTabWarpDrive);
        this.func_149663_c("warpdrive.hull" + tier + ".slab." + ItemDye.field_150923_a[BlockColored.func_150031_c((int)metaHull)]);
        this.func_149658_d("warpdrive:hull/");
    }

    public int func_149656_h() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 6));
        list.add(new ItemStack(item, 1, 8));
    }

    public int func_149741_i(int metadata) {
        this.metadataForRender = metadata;
        return super.func_149741_i(metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (metadata < 6) {
            return this.iconPlainFull;
        }
        if (metadata < 12) {
            ForgeDirection directionSlab;
            int direction = metadata - 6;
            if (side == direction) {
                return this.iconTiledFull;
            }
            ForgeDirection directionSide = ForgeDirection.getOrientation((int)side);
            if (directionSide == (directionSlab = ForgeDirection.getOrientation((int)direction)).getOpposite()) {
                return this.iconTiledFull;
            }
            if (direction == 0 || direction == 1) {
                return this.iconTiledHorizontal;
            }
            if (!(direction != 2 && direction != 3 || side != 0 && side != 1)) {
                return this.iconTiledHorizontal;
            }
            return this.iconTiledVertical;
        }
        if (metadata == 12) {
            return this.iconPlainFull;
        }
        if (metadata == 13) {
            if (side == 0 || side == 1) {
                return this.iconTiledFull;
            }
            return this.iconTiledHorizontal;
        }
        if (metadata == 14) {
            if (side == 2 || side == 3) {
                return this.iconTiledFull;
            }
            if (side == 0 || side == 1) {
                return this.iconTiledHorizontal;
            }
            return this.iconTiledVertical;
        }
        if (metadata == 15) {
            if (side == 4 || side == 5) {
                return this.iconTiledFull;
            }
            return this.iconTiledVertical;
        }
        return Blocks.field_150480_ab.func_149691_a(4, 0);
    }

    public int func_149692_a(int metadata) {
        return metadata <= 1 ? 0 : (metadata <= 5 ? 2 : (metadata <= 7 ? 6 : (metadata <= 11 ? 8 : metadata)));
    }

    public String func_150002_b(int p_150002_1_) {
        return this.func_149739_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconPlainFull = iconRegister.func_94245_a(this.func_149641_N() + "plain-" + BlockHullPlain.getDyeColorName(this.metaHull));
        this.iconTiledFull = iconRegister.func_94245_a(this.func_149641_N() + "tiled-" + BlockHullPlain.getDyeColorName(this.metaHull));
        this.iconTiledHorizontal = iconRegister.func_94245_a(this.func_149641_N() + "tiled_horizontal-" + BlockHullPlain.getDyeColorName(this.metaHull));
        this.iconTiledVertical = iconRegister.func_94245_a(this.func_149641_N() + "tiled_vertical-" + BlockHullPlain.getDyeColorName(this.metaHull));
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        int metadata = blockAccess.func_72805_g(x, y, z);
        this.setBlockBoundsFromMetadata(metadata);
    }

    private void setBlockBoundsFromMetadata(int metadata) {
        if (metadata >= 12) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            switch (metadata % 6) {
                case 0: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
                    return;
                }
                case 1: {
                    this.func_149676_a(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
                case 2: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                    return;
                }
                case 3: {
                    this.func_149676_a(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
                    return;
                }
                case 4: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
                    return;
                }
                case 5: {
                    this.func_149676_a(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
            }
            this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        }
    }

    public void func_149683_g() {
        this.setBlockBoundsFromMetadata(this.metadataForRender);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
    }

    public boolean func_149662_c() {
        return this.field_150004_a;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int variant;
        ForgeDirection facing = ForgeDirection.getOrientation((int)side);
        int n = metadata < 6 ? 0 : (variant = metadata < 12 ? 6 : metadata);
        if (this.field_150004_a || metadata >= 12) {
            return metadata;
        }
        if (metadata == 0 || metadata == 6) {
            ForgeDirection blockFacing = facing != ForgeDirection.DOWN && (facing == ForgeDirection.UP || hitY <= 0.5f) ? ForgeDirection.DOWN : ForgeDirection.UP;
            return variant + blockFacing.ordinal();
        }
        if (metadata == 2 || metadata == 8) {
            if (facing != ForgeDirection.DOWN && facing != ForgeDirection.UP) {
                return variant + facing.getOpposite().ordinal();
            }
            if (Math.abs(hitX - 0.5f) > Math.abs(hitZ - 0.5f)) {
                return hitX > 0.5f ? variant + ForgeDirection.EAST.ordinal() : variant + ForgeDirection.WEST.ordinal();
            }
            return hitZ > 0.5f ? variant + ForgeDirection.SOUTH.ordinal() : variant + ForgeDirection.NORTH.ordinal();
        }
        return metadata;
    }

    public int func_149745_a(Random random) {
        return this.field_150004_a ? 2 : 1;
    }

    public boolean func_149686_d() {
        return this.field_150004_a;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (this.field_150004_a) {
            return super.func_149646_a(blockAccess, x, y, z, side);
        }
        return side == 1 || side == 0 || super.func_149646_a(blockAccess, x, y, z, side);
    }

    public MapColor func_149728_f(int metadata) {
        return MapColor.func_151644_a((int)this.metaHull);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return this.func_149692_a(world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }

    @Override
    public byte getTier(ItemStack itemStack) {
        return this.tier;
    }

    @Override
    public EnumRarity getRarity(ItemStack itemStack, EnumRarity rarity) {
        switch (this.getTier(itemStack)) {
            case 0: {
                return EnumRarity.epic;
            }
            case 1: {
                return EnumRarity.common;
            }
            case 2: {
                return EnumRarity.uncommon;
            }
            case 3: {
                return EnumRarity.rare;
            }
        }
        return rarity;
    }

    @Override
    public float getBlockHardness(World world, int x, int y, int z, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        return WarpDriveConfig.HULL_HARDNESS[this.tier - 1];
    }

    @Override
    public int applyDamage(World world, int x, int y, int z, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        if (damageLevel <= 0) {
            return 0;
        }
        if (this.tier == 1) {
            world.func_147468_f(x, y, z);
        } else {
            int metadata = world.func_72805_g(x, y, z);
            world.func_147465_d(x, y, z, WarpDrive.blockHulls_slab[this.tier - 2][this.metaHull], metadata, 2);
        }
        return 0;
    }
}

