/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.computer.ILift;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumLiftMode;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLift
extends TileEntityAbstractEnergy
implements ILift {
    private static final double LIFT_GRAB_RADIUS = 0.4;
    private EnumLiftMode mode = EnumLiftMode.INACTIVE;
    private boolean isEnabled = true;
    private EnumLiftMode computerMode = EnumLiftMode.REDSTONE;
    private int updateTicks = 0;
    private boolean isActive = false;
    private boolean isValid = false;
    private int firstUncoveredY;

    public TileEntityLift() {
        this.IC2_sinkTier = 2;
        this.IC2_sourceTier = 2;
        this.peripheralName = "warpdriveLift";
        this.addMethods(new String[]{"enable", "mode", "state"});
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.updateTicks;
        if (this.updateTicks < 0) {
            this.updateTicks = WarpDriveConfig.LIFT_UPDATE_INTERVAL_TICKS;
            this.mode = this.computerMode == EnumLiftMode.DOWN || this.computerMode == EnumLiftMode.REDSTONE && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) ? EnumLiftMode.DOWN : EnumLiftMode.UP;
            this.isValid = this.isPassableBlock(this.field_145848_d + 1) && this.isPassableBlock(this.field_145848_d + 2) && this.isPassableBlock(this.field_145848_d - 1) && this.isPassableBlock(this.field_145848_d - 2);
            boolean bl = this.isActive = this.isEnabled && this.isValid;
            if (this.energy_getEnergyStored() < WarpDriveConfig.LIFT_ENERGY_PER_ENTITY || !this.isActive) {
                this.mode = EnumLiftMode.INACTIVE;
                if (this.func_145832_p() != 0) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
                }
                return;
            }
            if (this.func_145832_p() != this.mode.ordinal()) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.mode.ordinal(), 2);
            }
            for (int ny = this.field_145848_d - 2; ny > 0; --ny) {
                if (this.isPassableBlock(ny)) continue;
                this.firstUncoveredY = ny + 1;
                break;
            }
            if (this.field_145848_d - this.firstUncoveredY >= 2) {
                if (this.mode == EnumLiftMode.UP) {
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5, this.firstUncoveredY, (double)this.field_145849_e + 0.5), new Vector3((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5), 0.0f, 1.0f, 0.0f, 40, 0, 100);
                } else if (this.mode == EnumLiftMode.DOWN) {
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5), new Vector3((double)this.field_145851_c + 0.5, this.firstUncoveredY, (double)this.field_145849_e + 0.5), 0.0f, 0.0f, 1.0f, 40, 0, 100);
                }
                if (this.liftEntity()) {
                    this.updateTicks = WarpDriveConfig.LIFT_ENTITY_COOLDOWN_TICKS;
                }
            }
        }
    }

    private boolean isPassableBlock(int yPosition) {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, yPosition, this.field_145849_e);
        return block.func_149667_c(Blocks.field_150350_a) || this.field_145850_b.func_147437_c(this.field_145851_c, yPosition, this.field_145849_e) || block.func_149668_a(this.field_145850_b, this.field_145851_c, yPosition, this.field_145849_e) == null;
    }

    private boolean liftEntity() {
        boolean isTransferDone;
        block3: {
            double zMax;
            double zMin;
            double xMax;
            double xMin;
            block2: {
                xMin = (double)this.field_145851_c + 0.5 - 0.4;
                xMax = (double)this.field_145851_c + 0.5 + 0.4;
                zMin = (double)this.field_145849_e + 0.5 - 0.4;
                zMax = (double)this.field_145849_e + 0.5 + 0.4;
                isTransferDone = false;
                if (this.mode != EnumLiftMode.UP) break block2;
                AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)xMin, (double)this.firstUncoveredY, (double)zMin, (double)xMax, (double)this.field_145848_d, (double)zMax);
                List list = this.field_145850_b.func_72839_b(null, aabb);
                for (Object object : list) {
                    if (!(object instanceof EntityLivingBase) || !this.energy_consume(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, true)) continue;
                    ((EntityLivingBase)object).func_70634_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5);
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5, this.firstUncoveredY, (double)this.field_145849_e + 0.5), new Vector3((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5), 1.0f, 1.0f, 0.0f, 40, 0, 100);
                    this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, "warpdrive:hilaser", 4.0f, 1.0f);
                    this.energy_consume(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, false);
                    isTransferDone = true;
                }
                break block3;
            }
            if (this.mode != EnumLiftMode.DOWN) break block3;
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)xMin, (double)Math.min((double)this.firstUncoveredY + 4.0, (double)this.field_145848_d), (double)zMin, (double)xMax, (double)((double)this.field_145848_d + 2.0), (double)zMax);
            List list = this.field_145850_b.func_72839_b(null, aabb);
            for (Object object : list) {
                if (!(object instanceof EntityLivingBase) || !this.energy_consume(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, true)) continue;
                ((EntityLivingBase)object).func_70634_a((double)this.field_145851_c + 0.5, (double)this.firstUncoveredY, (double)this.field_145849_e + 0.5);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5), new Vector3((double)this.field_145851_c + 0.5, this.firstUncoveredY, (double)this.field_145849_e + 0.5), 1.0f, 1.0f, 0.0f, 40, 0, 100);
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, "warpdrive:hilaser", 4.0f, 1.0f);
                this.energy_consume(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, false);
                isTransferDone = true;
            }
        }
        return isTransferDone;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        byte byteValue;
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("mode")) {
            byteValue = tagCompound.func_74771_c("mode");
            this.mode = EnumLiftMode.get(Commons.clamp(0, 3, byteValue == -1 ? 3 : (int)byteValue));
        }
        if (tagCompound.func_74764_b("computerEnabled")) {
            this.isEnabled = tagCompound.func_74767_n("computerEnabled");
        } else if (tagCompound.func_74764_b("isEnabled")) {
            this.isEnabled = tagCompound.func_74767_n("isEnabled");
        }
        if (tagCompound.func_74764_b("computerMode")) {
            byteValue = tagCompound.func_74771_c("computerMode");
            this.computerMode = EnumLiftMode.get(Commons.clamp(0, 3, byteValue == -1 ? 3 : (int)byteValue));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74774_a("mode", (byte)this.mode.ordinal());
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        tagCompound.func_74774_a("computerMode", (byte)this.computerMode.ordinal());
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.LIFT_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }

    @Override
    public Object[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isEnabled = Commons.toBool(arguments[0]);
            this.func_70296_d();
        }
        return new Object[]{this.isEnabled};
    }

    @Override
    public Object[] mode(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] instanceof String) {
            String stringValue = (String)arguments[0];
            this.computerMode = stringValue.equalsIgnoreCase("up") ? EnumLiftMode.UP : (stringValue.equalsIgnoreCase("down") ? EnumLiftMode.DOWN : EnumLiftMode.REDSTONE);
            this.func_70296_d();
        }
        return new Object[]{this.computerMode.getName()};
    }

    @Override
    public Object[] state() {
        int energy = this.energy_getEnergyStored();
        String status = this.getStatusHeaderInPureText();
        return new Object[]{status, this.isActive, energy, this.isValid, this.isEnabled, this.computerMode.getName()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] mode(Context context, Arguments arguments) {
        return this.mode(new Object[]{arguments.checkString(0)});
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "enable": {
                return this.enable(arguments);
            }
            case "mode": {
                return this.mode(arguments);
            }
            case "state": {
                return this.state();
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }
}

