/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.EventWarpDrive;
import cr0s.warpdrive.api.IStarMapRegistryTileEntity;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.movement.TileEntityShipController;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.ShipMovementCosts;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumShipControllerCommand;
import cr0s.warpdrive.data.EnumShipCoreState;
import cr0s.warpdrive.data.EnumShipMovementType;
import cr0s.warpdrive.data.EnumStarMapEntryType;
import cr0s.warpdrive.data.Jumpgate;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.event.JumpSequencer;
import cr0s.warpdrive.render.EntityFXBoundingBox;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityShipCore
extends TileEntityAbstractEnergy
implements IStarMapRegistryTileEntity {
    private static final int LOG_INTERVAL_TICKS = 3600;
    private static final int BOUNDING_BOX_INTERVAL_TICKS = 60;
    public ForgeDirection facing;
    public UUID uuid = null;
    public String shipName = "default";
    private double isolationRate = 0.0;
    private int cooldownTime_ticks = 0;
    private int warmupTime_ticks = 0;
    protected int jumpCount = 0;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int minX;
    public int minY;
    public int minZ;
    protected boolean showBoundingBox = false;
    private int countBoundingBoxUpdate = 0;
    private EnumShipCoreState stateCurrent = EnumShipCoreState.IDLE;
    private EnumShipControllerCommand commandCurrent = EnumShipControllerCommand.IDLE;
    private long timeLastShipScanDone = -1L;
    public int shipMass;
    public int shipVolume;
    private EnumShipMovementType shipMovementType;
    private ShipMovementCosts shipMovementCosts;
    private long distanceSquared = 0L;
    private boolean isCooldownReported = false;
    private boolean isMotionSicknessApplied = false;
    private boolean isSoundPlayed = false;
    private boolean isWarmupReported = false;
    protected int randomWarmupAddition_ticks = 0;
    private int registryUpdateTicks = 0;
    private int bootTicks = 20;
    private int logTicks = 120;
    private int isolationBlocksCount = 0;
    private int isolationUpdateTicks = 0;
    private WeakReference<TileEntityShipController> tileEntityShipControllerWeakReference;
    private static final VectorI[] SUMMON_OFFSETS = new VectorI[]{new VectorI(2, 0, 0), new VectorI(-1, 0, 0), new VectorI(2, 0, 1), new VectorI(2, 0, -1), new VectorI(-1, 0, 1), new VectorI(-1, 0, -1), new VectorI(1, 0, 1), new VectorI(1, 0, -1), new VectorI(0, 0, 1), new VectorI(0, 0, -1)};

    public TileEntityShipCore() {
        this.peripheralName = "warpdriveShipCore";
    }

    @SideOnly(value=Side.CLIENT)
    private void doShowBoundingBox() {
        --this.countBoundingBoxUpdate;
        if (this.countBoundingBoxUpdate > 0) {
            return;
        }
        this.countBoundingBoxUpdate = 60;
        Vector3 vector3 = new Vector3(this);
        vector3.translate(0.5);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityFXBoundingBox(this.field_145850_b, vector3, new Vector3((double)this.minX - 0.0, (double)this.minY - 0.0, (double)this.minZ - 0.0), new Vector3((double)this.maxX + 1.0, (double)this.maxY + 1.0, (double)this.maxZ + 1.0), 1.0f, 0.8f, 0.3f, 61));
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.showBoundingBox) {
                this.doShowBoundingBox();
            }
            return;
        }
        TileEntityShipController tileEntityShipController = this.getShipController();
        if (this.cooldownTime_ticks > 0) {
            --this.cooldownTime_ticks;
            if (this.cooldownTime_ticks == 0 && tileEntityShipController != null) {
                tileEntityShipController.cooldownDone();
            }
        }
        if (this.cooldownTime_ticks > 0) {
            if (this.stateCurrent != EnumShipCoreState.COOLING_DOWN) {
                this.stateCurrent = EnumShipCoreState.COOLING_DOWN;
                this.isCooldownReported = false;
            }
        } else if (tileEntityShipController == null) {
            this.stateCurrent = EnumShipCoreState.DISCONNECTED;
        } else {
            if (this.stateCurrent == EnumShipCoreState.DISCONNECTED) {
                this.stateCurrent = EnumShipCoreState.IDLE;
            }
            if (!tileEntityShipController.isEnabled) {
                this.stateCurrent = EnumShipCoreState.IDLE;
            }
            if (this.timeLastShipScanDone <= 0L) {
                this.stateCurrent = EnumShipCoreState.SCANNING;
            }
        }
        if (this.func_145832_p() != this.stateCurrent.getMetadata()) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.stateCurrent.getMetadata(), 3);
        }
        if (this.bootTicks > 0) {
            --this.bootTicks;
            if (tileEntityShipController == null) {
                this.registryUpdateTicks = 1;
            }
        }
        --this.registryUpdateTicks;
        if (this.registryUpdateTicks <= 0) {
            this.registryUpdateTicks = 20 * WarpDriveConfig.STARMAP_REGISTRY_UPDATE_INTERVAL_SECONDS;
            if (this.uuid == null || this.uuid.getMostSignificantBits() == 0L && this.uuid.getLeastSignificantBits() == 0L) {
                this.uuid = UUID.randomUUID();
            }
            WarpDrive.starMap.updateInRegistry(this);
            TileEntityShipController tileEntityShipControllerNew = this.findControllerBlock();
            if (tileEntityShipControllerNew == null) {
                this.tileEntityShipControllerWeakReference = null;
            }
            if (tileEntityShipControllerNew != tileEntityShipController) {
                tileEntityShipController = tileEntityShipControllerNew;
                this.tileEntityShipControllerWeakReference = new WeakReference<TileEntityShipController>(tileEntityShipController);
            }
        }
        --this.logTicks;
        if (this.logTicks <= 0) {
            this.logTicks = 3600;
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(String.format("%s %s, jumpFlag %s from %s, warmup %d, cooldown %d", this, this.stateCurrent, tileEntityShipController == null ? "NA" : Boolean.valueOf(tileEntityShipController.isEnabled), tileEntityShipController, this.warmupTime_ticks, this.cooldownTime_ticks));
            }
        }
        --this.isolationUpdateTicks;
        if (this.isolationUpdateTicks <= 0) {
            this.isolationUpdateTicks = WarpDriveConfig.SHIP_CORE_ISOLATION_UPDATE_INTERVAL_SECONDS * 20;
            this.updateIsolationState();
        }
        if (tileEntityShipController == null) {
            return;
        }
        StringBuilder reason = new StringBuilder();
        EnumShipControllerCommand commandController = tileEntityShipController.getCommand();
        block0 : switch (this.stateCurrent) {
            case DISCONNECTED: {
                break;
            }
            case IDLE: {
                if (!tileEntityShipController.isEnabled || commandController == EnumShipControllerCommand.IDLE || commandController == EnumShipControllerCommand.MAINTENANCE) break;
                this.commandCurrent = commandController;
                this.stateCurrent = EnumShipCoreState.ONLINE;
                break;
            }
            case COOLING_DOWN: {
                if (tileEntityShipController.isEnabled && commandController != EnumShipControllerCommand.IDLE && commandController != EnumShipControllerCommand.MAINTENANCE && this.cooldownTime_ticks % 20 == 0) {
                    int seconds = this.cooldownTime_ticks / 20;
                    if (!this.isCooldownReported || seconds < 5 || seconds < 30 && seconds % 5 == 0 || seconds % 10 == 0) {
                        this.isCooldownReported = true;
                        this.messageToAllPlayersOnShip(String.format("Warp core is cooling down... %ds to go...", seconds));
                    }
                }
                if (this.cooldownTime_ticks > 0) break;
                this.stateCurrent = EnumShipCoreState.IDLE;
                this.isCooldownReported = false;
                break;
            }
            case SCANNING: {
                this.stateCurrent = EnumShipCoreState.IDLE;
                this.timeLastShipScanDone = this.field_145850_b.func_82737_E();
                if (this.validateShipSpatialParameters(tileEntityShipController, reason) || !tileEntityShipController.isEnabled) break;
                tileEntityShipController.commandDone(false, reason.toString());
                break;
            }
            case ONLINE: {
                switch (this.commandCurrent) {
                    case SUMMON: {
                        String targetName = tileEntityShipController.getTargetName();
                        if (targetName == null || targetName.isEmpty()) {
                            this.summonPlayers(tileEntityShipController);
                        } else {
                            this.summonSinglePlayer(tileEntityShipController, targetName);
                        }
                        tileEntityShipController.commandDone(true, "Teleportation done");
                        break block0;
                    }
                    case MANUAL: 
                    case HYPERDRIVE: 
                    case GATE: {
                        this.distanceSquared = tileEntityShipController.getMovement().getMagnitudeSquared();
                        if (this.timeLastShipScanDone + (long)WarpDriveConfig.SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS < this.field_145850_b.func_82737_E()) {
                            this.stateCurrent = EnumShipCoreState.SCANNING;
                            break block0;
                        }
                        this.messageToAllPlayersOnShip("Running pre-jump checklist...");
                        if (!this.validateShipSpatialParameters(tileEntityShipController, reason)) {
                            tileEntityShipController.commandDone(false, reason.toString());
                            return;
                        }
                        if (!this.validateShipMovementParameters(tileEntityShipController, reason)) {
                            tileEntityShipController.commandDone(false, reason.toString());
                            return;
                        }
                        this.randomWarmupAddition_ticks = this.field_145850_b.field_73012_v.nextInt(WarpDriveConfig.SHIP_WARMUP_RANDOM_TICKS);
                        this.stateCurrent = EnumShipCoreState.WARMING_UP;
                        this.warmupTime_ticks = this.shipMovementCosts.warmup_seconds * 20 + this.randomWarmupAddition_ticks;
                        this.isMotionSicknessApplied = false;
                        this.isSoundPlayed = false;
                        this.isWarmupReported = false;
                        break block0;
                    }
                }
                WarpDrive.logger.error(String.format("%s Invalid controller command %s for current state %s", new Object[]{this, commandController, this.stateCurrent}));
                break;
            }
            case WARMING_UP: {
                String soundFile;
                int soundThreshold;
                if (this.shipMovementCosts.sickness_seconds > 0) {
                    int motionSicknessThreshold_ticks = this.shipMovementCosts.sickness_seconds * 20 - this.randomWarmupAddition_ticks / 4;
                    if (!this.isMotionSicknessApplied && motionSicknessThreshold_ticks >= this.warmupTime_ticks) {
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info(this + " Giving warp sickness to on-board players");
                        }
                        this.makePlayersOnShipDrunk(this.shipMovementCosts.sickness_seconds * 20 + WarpDriveConfig.SHIP_WARMUP_RANDOM_TICKS);
                        this.isMotionSicknessApplied = true;
                    }
                }
                if (this.shipMovementCosts.warmup_seconds < 10) {
                    soundThreshold = 80 - this.randomWarmupAddition_ticks;
                    soundFile = "warpdrive:warp_4s";
                } else if (this.shipMovementCosts.warmup_seconds > 29) {
                    soundThreshold = 600 - this.randomWarmupAddition_ticks;
                    soundFile = "warpdrive:warp_30s";
                } else {
                    soundThreshold = 200 - this.randomWarmupAddition_ticks;
                    soundFile = "warpdrive:warp_10s";
                }
                if (!this.isSoundPlayed && soundThreshold >= this.warmupTime_ticks) {
                    if (WarpDriveConfig.LOGGING_JUMP) {
                        WarpDrive.logger.info(this + " Playing sound effect '" + soundFile + "' soundThreshold " + soundThreshold + " warmupTime " + this.warmupTime_ticks);
                    }
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), soundFile, 4.0f, 1.0f);
                    this.isSoundPlayed = true;
                }
                if (this.warmupTime_ticks % 20 == 0) {
                    int seconds = this.warmupTime_ticks / 20;
                    if (!this.isWarmupReported || seconds >= 60 && seconds % 15 == 0 || seconds < 60 && seconds > 30 && seconds % 10 == 0) {
                        this.isWarmupReported = true;
                        this.messageToAllPlayersOnShip(String.format("Warp core is warming up... %ds to go...", seconds));
                    }
                }
                if (this.warmupTime_ticks > 0) {
                    --this.warmupTime_ticks;
                    break;
                }
                this.warmupTime_ticks = 0;
                this.isMotionSicknessApplied = false;
                this.isSoundPlayed = false;
                this.isWarmupReported = false;
                if (!this.validateShipSpatialParameters(tileEntityShipController, reason)) {
                    tileEntityShipController.commandDone(false, reason.toString());
                    return;
                }
                if (WarpDrive.starMap.isWarpCoreIntersectsWithOthers(this)) {
                    tileEntityShipController.commandDone(false, "Warp field intersects with other ship's field. Disable the other core to jump.");
                    return;
                }
                if (WarpDrive.cloaks.isCloaked(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    tileEntityShipController.commandDone(false, "Core is inside a cloaking field. Aborting. Disable cloaking field to jump!");
                    return;
                }
                this.doJump(tileEntityShipController);
                this.cooldownTime_ticks = Math.max(1, this.shipMovementCosts.cooldown_seconds * 20);
                tileEntityShipController.commandDone(true, "Ok");
                ++this.jumpCount;
                this.stateCurrent = EnumShipCoreState.COOLING_DOWN;
                this.isCooldownReported = false;
                break;
            }
        }
    }

    public TileEntityShipController getShipController() {
        TileEntityShipController tileEntityShipController;
        TileEntityShipController tileEntityShipController2 = tileEntityShipController = this.tileEntityShipControllerWeakReference == null ? null : (TileEntityShipController)this.tileEntityShipControllerWeakReference.get();
        if (tileEntityShipController != null && tileEntityShipController.func_145837_r()) {
            this.tileEntityShipControllerWeakReference = null;
            tileEntityShipController = null;
        }
        return tileEntityShipController;
    }

    public boolean isOffline() {
        if (this.tileEntityShipControllerWeakReference == null) {
            return false;
        }
        TileEntityShipController tileEntityShipController = (TileEntityShipController)this.tileEntityShipControllerWeakReference.get();
        return tileEntityShipController != null && !tileEntityShipController.func_145837_r() && tileEntityShipController.getCommand() == EnumShipControllerCommand.OFFLINE;
    }

    protected boolean isAttached(TileEntityShipController tileEntityShipControllerExpected) {
        return this.tileEntityShipControllerWeakReference != null && tileEntityShipControllerExpected == this.tileEntityShipControllerWeakReference.get();
    }

    protected void messageToAllPlayersOnShip(String message) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)((double)this.maxX + 0.99), (double)((double)this.maxY + 0.99), (double)((double)this.maxZ + 0.99));
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        String messageFormatted = String.format("[%s] %s", !this.shipName.isEmpty() ? this.shipName : "ShipCore", message);
        WarpDrive.logger.info(this + " messageToAllPlayersOnShip: " + message);
        for (Object object : list) {
            if (!(object instanceof EntityPlayer)) continue;
            Commons.addChatMessage((ICommandSender)((EntityPlayer)object), messageFormatted);
        }
    }

    public String getAllPlayersOnShip() {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)((double)this.maxX + 0.99), (double)((double)this.maxY + 0.99), (double)((double)this.maxZ + 0.99));
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        StringBuilder stringBuilderResult = new StringBuilder();
        boolean isFirst = true;
        for (Object object : list) {
            if (!(object instanceof EntityPlayer)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                stringBuilderResult.append(", ");
            }
            stringBuilderResult.append(((EntityPlayer)object).func_70005_c_());
        }
        return stringBuilderResult.toString();
    }

    public boolean isBooting() {
        if (this.bootTicks > 0) {
            return true;
        }
        if (this.tileEntityShipControllerWeakReference == null) {
            return false;
        }
        TileEntityShipController tileEntityShipController = (TileEntityShipController)this.tileEntityShipControllerWeakReference.get();
        if (tileEntityShipController == null || tileEntityShipController.func_145837_r()) {
            this.registryUpdateTicks = 0;
            return true;
        }
        return false;
    }

    public String getFirstOnlineCrew() {
        if (this.tileEntityShipControllerWeakReference == null) {
            return null;
        }
        TileEntityShipController tileEntityShipController = (TileEntityShipController)this.tileEntityShipControllerWeakReference.get();
        if (tileEntityShipController == null || tileEntityShipController.func_145837_r()) {
            this.registryUpdateTicks = 0;
            return "-busy-";
        }
        if (tileEntityShipController.players == null || tileEntityShipController.players.isEmpty()) {
            return null;
        }
        for (String namePlayer : tileEntityShipController.players) {
            EntityPlayerMP entityPlayer = Commons.getOnlinePlayerByName(namePlayer);
            if (entityPlayer == null) continue;
            return namePlayer;
        }
        return null;
    }

    private void updateIsolationState() {
        int xMin = this.field_145851_c - WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int xMax = this.field_145851_c + WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int zMin = this.field_145849_e - WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int zMax = this.field_145849_e + WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int yMin = Math.max(0, this.field_145848_d - WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE + 1);
        int yMax = Math.min(255, this.field_145848_d + WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE + 1);
        int newCount = 0;
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!this.field_145850_b.func_147439_a(x, y, z).func_149667_c(WarpDrive.blockWarpIsolation)) continue;
                    ++newCount;
                }
            }
        }
        this.isolationBlocksCount = newCount;
        double legacy_isolationRate = this.isolationRate;
        this.isolationRate = this.isolationBlocksCount >= WarpDriveConfig.RADAR_MIN_ISOLATION_BLOCKS ? Math.min(1.0, WarpDriveConfig.RADAR_MIN_ISOLATION_EFFECT + (double)(this.isolationBlocksCount - WarpDriveConfig.RADAR_MIN_ISOLATION_BLOCKS) * (WarpDriveConfig.RADAR_MAX_ISOLATION_EFFECT - WarpDriveConfig.RADAR_MIN_ISOLATION_EFFECT) / (double)(WarpDriveConfig.RADAR_MAX_ISOLATION_BLOCKS - WarpDriveConfig.RADAR_MIN_ISOLATION_BLOCKS)) : 0.0;
        if (WarpDriveConfig.LOGGING_RADAR && (WarpDrive.isDev || legacy_isolationRate != this.isolationRate)) {
            WarpDrive.logger.info(String.format("%s Isolation updated to %d (%.1f%%)", this, this.isolationBlocksCount, this.isolationRate * 100.0));
        }
    }

    private void makePlayersOnShipDrunk(int tickDuration) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        for (Object object : list) {
            if (!(object instanceof EntityPlayer)) continue;
            ((EntityPlayer)object).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, tickDuration, 0, true));
        }
    }

    private void summonPlayers(TileEntityShipController tileEntityShipController) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        for (int i = 0; i < tileEntityShipController.players.size(); ++i) {
            String playerName = tileEntityShipController.players.get(i);
            EntityPlayerMP entityPlayerMP = Commons.getOnlinePlayerByName(playerName);
            if (entityPlayerMP == null || !TileEntityShipCore.isOutsideBB(aabb, MathHelper.func_76128_c((double)entityPlayerMP.field_70165_t), MathHelper.func_76128_c((double)entityPlayerMP.field_70163_u), MathHelper.func_76128_c((double)entityPlayerMP.field_70161_v))) continue;
            this.summonPlayer(entityPlayerMP);
        }
    }

    private void summonSinglePlayer(TileEntityShipController tileEntityShipController, String nickname) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        for (int i = 0; i < tileEntityShipController.players.size(); ++i) {
            String playerName = tileEntityShipController.players.get(i);
            EntityPlayerMP entityPlayerMP = Commons.getOnlinePlayerByName(playerName);
            if (entityPlayerMP == null || !playerName.equals(nickname) || !TileEntityShipCore.isOutsideBB(aabb, MathHelper.func_76128_c((double)entityPlayerMP.field_70165_t), MathHelper.func_76128_c((double)entityPlayerMP.field_70163_u), MathHelper.func_76128_c((double)entityPlayerMP.field_70161_v))) continue;
            this.summonPlayer(entityPlayerMP);
            return;
        }
    }

    public boolean summonOwnerOnDeploy(EntityPlayerMP entityPlayerMP) {
        if (entityPlayerMP == null) {
            WarpDrive.logger.warn(this + " No player given to summonOwnerOnDeploy()");
            return false;
        }
        StringBuilder reason = new StringBuilder();
        TileEntityShipController tileEntityShipController = this.findControllerBlock();
        if (!this.validateShipSpatialParameters(tileEntityShipController, reason)) {
            Commons.addChatMessage((ICommandSender)entityPlayerMP, "[" + (!this.shipName.isEmpty() ? this.shipName : "ShipCore") + "] \u00c2\u00a7c" + reason.toString());
            return false;
        }
        if (tileEntityShipController == null) {
            WarpDrive.logger.warn(this + " Failed to find controller block");
            return false;
        }
        tileEntityShipController.players.clear();
        tileEntityShipController.players.add(entityPlayerMP.func_70005_c_());
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        if (TileEntityShipCore.isOutsideBB(aabb, MathHelper.func_76128_c((double)entityPlayerMP.field_70165_t), MathHelper.func_76128_c((double)entityPlayerMP.field_70163_u), MathHelper.func_76128_c((double)entityPlayerMP.field_70161_v))) {
            this.summonPlayer(entityPlayerMP);
        }
        return true;
    }

    private void summonPlayer(EntityPlayerMP entityPlayer) {
        double distance = Math.sqrt(new VectorI((Entity)entityPlayer).distance2To(this));
        if (entityPlayer.field_70170_p != this.field_145850_b) {
            distance += 256.0;
            if (!WarpDriveConfig.SHIP_SUMMON_ACROSS_DIMENSIONS) {
                this.messageToAllPlayersOnShip("\u00c2\u00a7c" + String.format("%1$s is in a different dimension, too far away to be summoned", entityPlayer.getDisplayName()));
                return;
            }
        }
        if (WarpDriveConfig.SHIP_SUMMON_MAX_RANGE >= 0 && distance > (double)WarpDriveConfig.SHIP_SUMMON_MAX_RANGE) {
            this.messageToAllPlayersOnShip("\u00c2\u00a7c" + String.format("%1$s is too far away to be summoned (max. is %2$d m)", entityPlayer.getDisplayName(), WarpDriveConfig.SHIP_SUMMON_MAX_RANGE));
            Commons.addChatMessage((ICommandSender)entityPlayer, "\u00c2\u00a7c" + String.format("You are to far away to be summoned aboard '%1$s' (max. is %2$d m)", this.shipName, WarpDriveConfig.SHIP_SUMMON_MAX_RANGE));
            return;
        }
        for (VectorI vOffset : SUMMON_OFFSETS) {
            VectorI vPosition = new VectorI(this.field_145851_c + this.facing.offsetX * vOffset.x + this.facing.offsetZ * vOffset.z, this.field_145848_d, this.field_145849_e + this.facing.offsetZ * vOffset.x + this.facing.offsetX * vOffset.z);
            if (this.field_145850_b.func_147437_c(vPosition.x, vPosition.y, vPosition.z)) {
                if (this.field_145850_b.func_147437_c(vPosition.x, vPosition.y + 1, vPosition.z)) {
                    this.summonPlayer(entityPlayer, vPosition.x, vPosition.y, vPosition.z);
                    return;
                }
                if (!this.field_145850_b.func_147437_c(vPosition.x, vPosition.y - 1, vPosition.z)) continue;
                this.summonPlayer(entityPlayer, vPosition.x, vPosition.y - 1, vPosition.z);
                return;
            }
            if (this.field_145850_b.func_147437_c(vPosition.x, vPosition.y - 1, vPosition.z) && this.field_145850_b.func_147437_c(vPosition.x, vPosition.y - 2, vPosition.z) && !this.field_145850_b.func_147437_c(vPosition.x, vPosition.y - 3, vPosition.z)) {
                this.summonPlayer(entityPlayer, vPosition.x, vPosition.y - 2, vPosition.z);
                return;
            }
            if (!this.field_145850_b.func_147437_c(vPosition.x, vPosition.y + 1, vPosition.z) || !this.field_145850_b.func_147437_c(vPosition.x, vPosition.y + 2, vPosition.z) || this.field_145850_b.func_147437_c(vPosition.x, vPosition.y, vPosition.z)) continue;
            this.summonPlayer(entityPlayer, vPosition.x, vPosition.y + 1, vPosition.z);
            return;
        }
        String message = "\u00c2\u00a7c" + String.format("No safe spot found to summon player %1$s", entityPlayer.getDisplayName());
        this.messageToAllPlayersOnShip(message);
        Commons.addChatMessage((ICommandSender)entityPlayer, message);
    }

    private void summonPlayer(EntityPlayerMP player, int x, int y, int z) {
        if (this.energy_consume(WarpDriveConfig.SHIP_TELEPORT_ENERGY_PER_ENTITY, false)) {
            Commons.moveEntity((Entity)player, this.field_145850_b, new Vector3((double)x + 0.5, y, (double)z + 0.5));
        }
    }

    public boolean validateShipSpatialParameters(StringBuilder reason) {
        TileEntityShipController tileEntityShipController = this.findControllerBlock();
        return this.validateShipSpatialParameters(tileEntityShipController, reason);
    }

    protected boolean validateShipSpatialParameters(TileEntityShipController tileEntityShipController, StringBuilder reason) {
        if (tileEntityShipController == null) {
            reason.append("TileEntityShipCore.validateShipSpatialParameters: no controller detected!");
            return false;
        }
        int shipFront = tileEntityShipController.getFront();
        int shipRight = tileEntityShipController.getRight();
        int shipUp = tileEntityShipController.getUp();
        int shipBack = tileEntityShipController.getBack();
        int shipLeft = tileEntityShipController.getLeft();
        int shipDown = tileEntityShipController.getDown();
        int x1 = 0;
        int x2 = 0;
        int z1 = 0;
        int z2 = 0;
        if (this.facing.offsetX == 1) {
            x1 = this.field_145851_c - shipBack;
            x2 = this.field_145851_c + shipFront;
            z1 = this.field_145849_e - shipLeft;
            z2 = this.field_145849_e + shipRight;
        } else if (this.facing.offsetX == -1) {
            x1 = this.field_145851_c - shipFront;
            x2 = this.field_145851_c + shipBack;
            z1 = this.field_145849_e - shipRight;
            z2 = this.field_145849_e + shipLeft;
        } else if (this.facing.offsetZ == 1) {
            z1 = this.field_145849_e - shipBack;
            z2 = this.field_145849_e + shipFront;
            x1 = this.field_145851_c - shipRight;
            x2 = this.field_145851_c + shipLeft;
        } else if (this.facing.offsetZ == -1) {
            z1 = this.field_145849_e - shipFront;
            z2 = this.field_145849_e + shipBack;
            x1 = this.field_145851_c - shipLeft;
            x2 = this.field_145851_c + shipRight;
        }
        if (x1 < x2) {
            this.minX = x1;
            this.maxX = x2;
        } else {
            this.minX = x2;
            this.maxX = x1;
        }
        if (z1 < z2) {
            this.minZ = z1;
            this.maxZ = z2;
        } else {
            this.minZ = z2;
            this.maxZ = z1;
        }
        this.minY = this.field_145848_d - shipDown;
        this.maxY = this.field_145848_d + shipUp;
        this.func_70296_d();
        if (shipBack + shipFront > WarpDriveConfig.SHIP_MAX_SIDE_SIZE || shipLeft + shipRight > WarpDriveConfig.SHIP_MAX_SIDE_SIZE || shipDown + shipUp > WarpDriveConfig.SHIP_MAX_SIDE_SIZE) {
            reason.append(String.format("Ship is too big (max is %d per side)", WarpDriveConfig.SHIP_MAX_SIDE_SIZE));
            return false;
        }
        boolean isUnlimited = false;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)((double)this.maxX + 0.99), (double)((double)this.maxY + 0.99), (double)((double)this.maxZ + 0.99));
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        for (Object object : list) {
            if (!(object instanceof EntityPlayer)) continue;
            String displayName = ((EntityPlayer)object).getDisplayName();
            for (String nameUnlimited : WarpDriveConfig.SHIP_VOLUME_UNLIMITED_PLAYERNAMES) {
                isUnlimited = isUnlimited || nameUnlimited.equals(displayName);
            }
        }
        this.updateShipMassAndVolume();
        if (!isUnlimited && this.shipMass > WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE && CelestialObjectManager.isPlanet(this.field_145850_b, this.field_145851_c, this.field_145849_e)) {
            reason.append(String.format("Ship is too big for a planet (max is %d blocks)", WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE));
            return false;
        }
        return true;
    }

    private boolean validateShipMovementParameters(TileEntityShipController tileEntityShipController, StringBuilder reason) {
        this.shipMovementType = EnumShipMovementType.compute(this.field_145850_b, this.field_145851_c, this.minY, this.maxY, this.field_145849_e, this.commandCurrent, tileEntityShipController.getMovement().y, reason);
        if (this.shipMovementType == null) {
            return false;
        }
        this.shipMovementCosts = new ShipMovementCosts(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, tileEntityShipController, this.shipMovementType, this.shipMass, (int)Math.ceil(Math.sqrt(this.distanceSquared)));
        EventWarpDrive.Ship.PreJump preJump = new EventWarpDrive.Ship.PreJump(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getShipController(), this.shipMovementType.getName());
        MinecraftForge.EVENT_BUS.post((Event)preJump);
        if (preJump.isCanceled()) {
            reason.append(preJump.getReason());
            return false;
        }
        return true;
    }

    protected int getMaxJumpDistance(TileEntityShipController tileEntityShipController, EnumShipControllerCommand command, StringBuilder reason) {
        EnumShipMovementType shipMovementType = EnumShipMovementType.compute(this.field_145850_b, this.field_145851_c, this.minY, this.maxY, this.field_145849_e, command, tileEntityShipController.getMovement().y, reason);
        if (shipMovementType == null) {
            tileEntityShipController.commandDone(false, reason.toString());
            return -1;
        }
        ShipMovementCosts shipMovementCosts = new ShipMovementCosts(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, tileEntityShipController, shipMovementType, this.shipMass, (int)Math.ceil(Math.sqrt(this.distanceSquared)));
        return shipMovementCosts.maximumDistance_blocks;
    }

    protected int getEnergyRequired(TileEntityShipController tileEntityShipController, EnumShipControllerCommand command, StringBuilder reason) {
        EnumShipMovementType shipMovementType = EnumShipMovementType.compute(this.field_145850_b, this.field_145851_c, this.minY, this.maxY, this.field_145849_e, command, tileEntityShipController.getMovement().y, reason);
        if (shipMovementType == null) {
            tileEntityShipController.commandDone(false, reason.toString());
            return -1;
        }
        ShipMovementCosts shipMovementCosts = new ShipMovementCosts(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, tileEntityShipController, shipMovementType, this.shipMass, (int)Math.ceil(Math.sqrt(this.distanceSquared)));
        return shipMovementCosts.energyRequired;
    }

    private boolean isShipInJumpgate(Jumpgate jumpgate, StringBuilder reason) {
        AxisAlignedBB aabb = jumpgate.getGateAABB();
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Jumpgate " + jumpgate.name + " AABB is " + aabb);
        }
        int countBlocksInside = 0;
        int countBlocksTotal = 0;
        if (aabb.func_72318_a(Vec3.func_72443_a((double)this.minX, (double)this.minY, (double)this.minZ)) && aabb.func_72318_a(Vec3.func_72443_a((double)this.maxX, (double)this.maxY, (double)this.maxZ))) {
            return true;
        }
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    if (block == Blocks.field_150350_a || Dictionary.BLOCKS_LEFTBEHIND.contains(block) || Dictionary.BLOCKS_NOMASS.contains(block)) continue;
                    if (aabb.field_72340_a <= (double)x && aabb.field_72336_d >= (double)x && aabb.field_72338_b <= (double)y && aabb.field_72337_e >= (double)y && aabb.field_72339_c <= (double)z && aabb.field_72334_f >= (double)z) {
                        ++countBlocksInside;
                    }
                    ++countBlocksTotal;
                }
            }
        }
        float percent = 0.0f;
        if (this.shipMass != 0) {
            percent = (float)Math.round((float)countBlocksInside * 1.0f / (float)this.shipMass * 100.0f * 10.0f) / 10.0f;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            if (this.shipMass != countBlocksTotal) {
                WarpDrive.logger.info(this + " Ship mass has changed from " + this.shipMass + " to " + countBlocksTotal + " blocks");
            }
            WarpDrive.logger.info(this + "Ship has " + countBlocksInside + " / " + this.shipMass + " blocks (" + percent + "%) in jumpgate '" + jumpgate.name + "'");
        }
        if (percent > 80.0f) {
            return true;
        }
        if ((double)percent <= 0.001) {
            reason.append(String.format("Ship is not inside a jumpgate. Jump rejected. Nearest jumpgate is %s", jumpgate.toNiceString()));
            return false;
        }
        reason.append(String.format("Ship is only %.1f%% inside a jumpgate. Sorry, we'll loose too much crew as is, jump rejected.", Float.valueOf(percent)));
        return false;
    }

    private boolean isFreePlaceForShip(TileEntityShipController tileEntityShipController, int destX, int destY, int destZ) {
        if (tileEntityShipController == null || destY + tileEntityShipController.getUp() > 255 || destY - tileEntityShipController.getDown() < 5) {
            return false;
        }
        int moveX = destX - this.field_145851_c;
        int moveY = destY - this.field_145848_d;
        int moveZ = destZ - this.field_145849_e;
        for (int x = this.minX; x <= this.maxX; ++x) {
            int newX = moveX + x;
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                int newZ = moveZ + z;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    if (moveY + y < 0 || moveY + y > 255) {
                        return false;
                    }
                    Block blockSource = this.field_145850_b.func_147439_a(x, y, z);
                    Block blockTarget = this.field_145850_b.func_147439_a(newX, moveY + y, newZ);
                    if (blockSource == Blocks.field_150350_a || Dictionary.BLOCKS_EXPANDABLE.contains(blockSource) || blockTarget == Blocks.field_150350_a || Dictionary.BLOCKS_EXPANDABLE.contains(blockTarget)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void doGateJump(TileEntityShipController tileEntityShipController) {
        StringBuilder reason;
        String targetName = tileEntityShipController.getTargetName();
        Jumpgate targetGate = WarpDrive.jumpgates.findGateByName(targetName);
        if (targetGate == null) {
            tileEntityShipController.commandDone(false, String.format("Destination jumpgate '%s' is unknown. Check jumpgate name.", targetName));
            return;
        }
        int gateX = targetGate.xCoord;
        int gateY = targetGate.yCoord;
        int gateZ = targetGate.zCoord;
        int destX = gateX;
        int destY = gateY;
        int destZ = gateZ;
        Jumpgate nearestGate = WarpDrive.jumpgates.findNearestGate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.isShipInJumpgate(nearestGate, reason = new StringBuilder())) {
            tileEntityShipController.commandDone(false, reason.toString());
            return;
        }
        if (!this.isFreePlaceForShip(tileEntityShipController, gateX, gateY, gateZ)) {
            int numTries;
            boolean placeFound = false;
            for (numTries = 10; numTries > 0; --numTries) {
                destX = gateX + (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1) * (20 + this.field_145850_b.field_73012_v.nextInt(100));
                destZ = gateZ + (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1) * (20 + this.field_145850_b.field_73012_v.nextInt(100));
                destY = gateY + (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1) * (20 + this.field_145850_b.field_73012_v.nextInt(50));
                if (!this.isFreePlaceForShip(tileEntityShipController, destX, destY, destZ)) continue;
                placeFound = true;
                break;
            }
            if (!placeFound) {
                tileEntityShipController.commandDone(false, "Destination gate is blocked by obstacles. Aborting...");
                return;
            }
            WarpDrive.logger.info("[GATE] Place found over " + (10 - numTries) + " tries.");
        }
        if (this.energy_consume(this.shipMovementCosts.energyRequired, false)) {
            WarpDrive.logger.info(this + " Moving ship to a place around gate '" + targetGate.name + "' (" + destX + "; " + destY + "; " + destZ + ")");
            JumpSequencer jump = new JumpSequencer(this, EnumShipMovementType.GATE_ACTIVATING, targetName, 0, 0, 0, 0, destX, destY, destZ);
            jump.enable();
        } else {
            this.messageToAllPlayersOnShip("Insufficient energy level");
        }
    }

    private void doJump(TileEntityShipController tileEntityShipController) {
        int requiredEnergy = this.shipMovementCosts.energyRequired;
        if (!this.energy_consume(requiredEnergy, true)) {
            tileEntityShipController.commandDone(false, String.format("Insufficient energy to jump! Core is currently charged with %d EU while jump requires %d EU", this.energy_getEnergyStored(), requiredEnergy));
            return;
        }
        String shipInfo = "" + this.shipVolume + " blocks inside (" + this.minX + ", " + this.minY + ", " + this.minZ + ") to (" + this.maxX + ", " + this.maxY + ", " + this.maxZ + ") with an actual mass of " + this.shipMass + " blocks";
        switch (this.commandCurrent) {
            case GATE: {
                WarpDrive.logger.info(this + " Performing gate jump of " + shipInfo);
                this.doGateJump(tileEntityShipController);
                return;
            }
            case HYPERDRIVE: {
                WarpDrive.logger.info(this + " Performing hyperdrive jump of " + shipInfo);
                if (this.shipMass >= WarpDriveConfig.SHIP_VOLUME_MIN_FOR_HYPERSPACE) break;
                Jumpgate nearestGate = null;
                if (WarpDrive.jumpgates == null) {
                    WarpDrive.logger.warn(this + " WarpDrive.jumpGates is NULL!");
                } else {
                    nearestGate = WarpDrive.jumpgates.findNearestGate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                StringBuilder reason = new StringBuilder();
                if (nearestGate != null && this.isShipInJumpgate(nearestGate, reason)) break;
                tileEntityShipController.commandDone(false, String.format("Ship is too small (%d/%d).\nInsufficient ship mass to engage alcubierre drive.\nIncrease your mass or use a jumpgate to reach or exit hyperspace.", this.shipMass, WarpDriveConfig.SHIP_VOLUME_MIN_FOR_HYPERSPACE));
                return;
            }
            case MANUAL: {
                WarpDrive.logger.info(String.format("%s Performing manual jump of %s, %s, movement %s, rotationSteps %d", this, shipInfo, this.shipMovementType, tileEntityShipController.getMovement(), tileEntityShipController.getRotationSteps()));
                break;
            }
            default: {
                WarpDrive.logger.error(String.format("%s Aborting while trying to perform invalid jump command %s", new Object[]{this, this.commandCurrent}));
                tileEntityShipController.commandDone(false, "Internal error, check console for details");
                this.commandCurrent = EnumShipControllerCommand.IDLE;
                this.stateCurrent = EnumShipCoreState.DISCONNECTED;
                return;
            }
        }
        if (!this.energy_consume(requiredEnergy, false)) {
            tileEntityShipController.commandDone(false, "Insufficient energy level");
            return;
        }
        int moveX = 0;
        int moveY = 0;
        int moveZ = 0;
        if (this.commandCurrent != EnumShipControllerCommand.HYPERDRIVE) {
            VectorI movement = tileEntityShipController.getMovement();
            VectorI shipSize = new VectorI(tileEntityShipController.getFront() + 1 + tileEntityShipController.getBack(), tileEntityShipController.getUp() + 1 + tileEntityShipController.getDown(), tileEntityShipController.getRight() + 1 + tileEntityShipController.getLeft());
            int maxDistance = this.shipMovementCosts.maximumDistance_blocks;
            if (Math.abs(movement.x) - shipSize.x > maxDistance) {
                movement.x = (int)Math.signum(movement.x) * (shipSize.x + maxDistance);
            }
            if (Math.abs(movement.y) - shipSize.y > maxDistance) {
                movement.y = (int)Math.signum(movement.y) * (shipSize.y + maxDistance);
            }
            if (Math.abs(movement.z) - shipSize.z > maxDistance) {
                movement.z = (int)Math.signum(movement.z) * (shipSize.z + maxDistance);
            }
            moveX = this.facing.offsetX * movement.x - this.facing.offsetZ * movement.z;
            moveY = movement.y;
            moveZ = this.facing.offsetZ * movement.x + this.facing.offsetX * movement.z;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Movement adjusted to (" + moveX + " " + moveY + " " + moveZ + ") blocks.");
        }
        JumpSequencer jump = new JumpSequencer(this, this.shipMovementType, null, moveX, moveY, moveZ, tileEntityShipController.getRotationSteps(), 0, 0, 0);
        jump.enable();
    }

    private static boolean isOutsideBB(AxisAlignedBB axisalignedbb, int x, int y, int z) {
        return axisalignedbb.field_72340_a > (double)x || axisalignedbb.field_72336_d < (double)x || axisalignedbb.field_72338_b > (double)y || axisalignedbb.field_72337_e < (double)y || axisalignedbb.field_72339_c > (double)z || axisalignedbb.field_72334_f < (double)z;
    }

    @Override
    public String getStatus() {
        String strIsolationRate = String.format("%.1f", this.isolationRate * 100.0);
        return super.getStatus() + (this.cooldownTime_ticks > 0 ? "\n" + StatCollector.func_74837_a((String)"warpdrive.ship.status_line.cooling", (Object[])new Object[]{this.cooldownTime_ticks / 20}) : "") + (this.isolationBlocksCount > 0 ? "\n" + StatCollector.func_74837_a((String)"warpdrive.ship.status_line.isolation", (Object[])new Object[]{this.isolationBlocksCount, strIsolationRate}) : "");
    }

    public String getBoundingBoxStatus() {
        return super.getStatusPrefix() + StatCollector.func_74837_a((String)(this.showBoundingBox ? "tile.warpdrive.movement.ship_core.bounding_box.enabled" : "tile.warpdrive.movement.ship_core.bounding_box.disabled"), (Object[])new Object[0]);
    }

    private void updateShipMassAndVolume() {
        int newMass = 0;
        int newVolume = 0;
        try {
            for (int x = this.minX; x <= this.maxX; ++x) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    for (int y = this.minY; y <= this.maxY; ++y) {
                        Block block = this.field_145850_b.func_147439_a(x, y, z);
                        if (block == Blocks.field_150350_a || Dictionary.BLOCKS_LEFTBEHIND.contains(block)) continue;
                        ++newVolume;
                        if (Dictionary.BLOCKS_NOMASS.contains(block)) continue;
                        ++newMass;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.shipMass = newMass;
        this.shipVolume = newVolume;
    }

    private TileEntityShipController findControllerBlock() {
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        if (tileEntity instanceof TileEntityShipController) {
            this.facing = ForgeDirection.EAST;
            return (TileEntityShipController)tileEntity;
        }
        tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        if (tileEntity instanceof TileEntityShipController) {
            this.facing = ForgeDirection.WEST;
            return (TileEntityShipController)tileEntity;
        }
        tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        if (tileEntity instanceof TileEntityShipController) {
            this.facing = ForgeDirection.SOUTH;
            return (TileEntityShipController)tileEntity;
        }
        tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        if (tileEntity instanceof TileEntityShipController) {
            this.facing = ForgeDirection.NORTH;
            return (TileEntityShipController)tileEntity;
        }
        return null;
    }

    public int getCooldown() {
        return this.cooldownTime_ticks;
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.SHIP_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.facing = ForgeDirection.getOrientation((int)tagCompound.func_74771_c("facing"));
        this.uuid = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (this.uuid.getMostSignificantBits() == 0L && this.uuid.getLeastSignificantBits() == 0L) {
            this.uuid = UUID.randomUUID();
        }
        this.shipName = tagCompound.func_74779_i("corefrequency") + tagCompound.func_74779_i("shipName");
        this.isolationRate = tagCompound.func_74769_h("isolationRate");
        this.cooldownTime_ticks = tagCompound.func_74762_e("cooldownTime");
        this.warmupTime_ticks = tagCompound.func_74762_e("warmupTime");
        this.jumpCount = tagCompound.func_74762_e("jumpCount");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.facing != null) {
            tagCompound.func_74774_a("facing", (byte)this.facing.ordinal());
        }
        if (this.uuid != null) {
            tagCompound.func_74772_a("uuidMost", this.uuid.getMostSignificantBits());
            tagCompound.func_74772_a("uuidLeast", this.uuid.getLeastSignificantBits());
        }
        tagCompound.func_74778_a("shipName", this.shipName);
        tagCompound.func_74780_a("isolationRate", this.isolationRate);
        tagCompound.func_74768_a("cooldownTime", this.cooldownTime_ticks);
        tagCompound.func_74768_a("warmupTime", this.warmupTime_ticks);
        tagCompound.func_74768_a("jumpCount", this.jumpCount);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        tagCompound.func_74768_a("minX", this.minX);
        tagCompound.func_74768_a("maxX", this.maxX);
        tagCompound.func_74768_a("minY", this.minY);
        tagCompound.func_74768_a("maxY", this.maxY);
        tagCompound.func_74768_a("minZ", this.minZ);
        tagCompound.func_74768_a("maxZ", this.maxZ);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
        this.minX = tagCompound.func_74762_e("minX");
        this.maxX = tagCompound.func_74762_e("maxX");
        this.minY = tagCompound.func_74762_e("minY");
        this.maxY = tagCompound.func_74762_e("maxY");
        this.minZ = tagCompound.func_74762_e("minZ");
        this.maxZ = tagCompound.func_74762_e("maxZ");
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        WarpDrive.starMap.updateInRegistry(this);
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            WarpDrive.starMap.removeFromRegistry(this);
        }
        super.func_145843_s();
    }

    @Override
    public EnumStarMapEntryType getStarMapType() {
        return EnumStarMapEntryType.SHIP;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public AxisAlignedBB getStarMapArea() {
        return AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    @Override
    public int getMass() {
        return this.shipMass;
    }

    @Override
    public double getIsolationRate() {
        return this.isolationRate;
    }

    @Override
    public String getStarMapName() {
        return this.shipName;
    }

    @Override
    public void onBlockUpdatedInArea(VectorI vector, Block block, int metadata) {
    }

    @Override
    public String toString() {
        return String.format("%s '%s' @ %s (%d %d %d)", this.getClass().getSimpleName(), this.shipName, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

