/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IItemTransporterBeacon;
import cr0s.warpdrive.api.IStarMapRegistryTileEntity;
import cr0s.warpdrive.api.computer.ITransporterBeacon;
import cr0s.warpdrive.api.computer.ITransporterCore;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceField;
import cr0s.warpdrive.block.movement.BlockTransporterBeacon;
import cr0s.warpdrive.block.movement.BlockTransporterContainment;
import cr0s.warpdrive.block.movement.BlockTransporterCore;
import cr0s.warpdrive.block.movement.BlockTransporterScanner;
import cr0s.warpdrive.block.movement.TileEntityTransporterBeacon;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumStarMapEntryType;
import cr0s.warpdrive.data.EnumTransporterState;
import cr0s.warpdrive.data.ForceFieldRegistry;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.StarMapRegistry;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTransporterCore
extends TileEntityAbstractEnergy
implements ITransporterCore,
IBeamFrequency,
IStarMapRegistryTileEntity {
    private UUID uuid = null;
    private ArrayList<VectorI> vLocalScanners = null;
    private int beamFrequency = -1;
    private String transporterName = "";
    private boolean isEnabled = true;
    private boolean isLockRequested = false;
    private boolean isEnergizeRequested = false;
    private Object remoteLocationRequested = null;
    private double energyFactor = 1.0;
    private double lockStrengthActual = 0.0;
    private int tickCooldown = 0;
    private EnumTransporterState transporterState = EnumTransporterState.DISABLED;
    private ArrayList<VectorI> vLocalContainments = null;
    private AxisAlignedBB aabbLocalScanners = null;
    private boolean isBlockUpdated = false;
    private int tickUpdateRegistry = 0;
    private int tickUpdateParameters = 0;
    private int tickComputerPulse = 0;
    private boolean isConnected = false;
    private GlobalPosition globalPositionBeacon = null;
    private double energyCostForAcquiring = 0.0;
    private double energyCostForEnergizing = 0.0;
    private double lockStrengthOptimal = -1.0;
    private double lockStrengthSpeed = 0.0;
    private boolean isJammed = false;
    private String reasonJammed = "";
    private GlobalPosition globalPositionLocal = null;
    private GlobalPosition globalPositionRemote = null;
    private ArrayList<VectorI> vRemoteScanners = null;
    private HashMap<Integer, MovingEntity> movingEntitiesLocal = new HashMap(8);
    private HashMap<Integer, MovingEntity> movingEntitiesRemote = new HashMap(8);
    private int tickEnergizing = 0;

    public TileEntityTransporterCore() {
        this.IC2_sinkTier = 2;
        this.IC2_sourceTier = 2;
        this.peripheralName = "warpdriveTransporterCore";
        this.addMethods(new String[]{"beamFrequency", "transporterName", "enable", "state", "remoteLocation", "lock", "energyFactor", "getLockStrength", "getEnergyRequired", "energize"});
        this.CC_scripts = Collections.singletonList("startup");
        this.setUpgradeMaxCount(EnumComponentType.ENDER_CRYSTAL, WarpDriveConfig.TRANSPORTER_RANGE_UPGRADE_MAX_QUANTITY);
        this.setUpgradeMaxCount(EnumComponentType.CAPACITIVE_CRYSTAL, WarpDriveConfig.TRANSPORTER_ENERGY_STORED_UPGRADE_MAX_QUANTITY);
        this.setUpgradeMaxCount(EnumComponentType.EMERALD_CRYSTAL, WarpDriveConfig.TRANSPORTER_LOCKING_UPGRADE_MAX_QUANTITY);
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.tickUpdateParameters = 0;
        this.globalPositionLocal = new GlobalPosition(this);
    }

    @Override
    public void func_145845_h() {
        boolean isPowered;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = this.isConnected = this.beamFrequency > 0 && this.beamFrequency <= 65000;
        this.tickCooldown = this.tickCooldown > 0 ? --this.tickCooldown : 0;
        if (!this.isEnabled) {
            this.transporterState = EnumTransporterState.DISABLED;
            isPowered = false;
        } else {
            int energyRequired = this.getEnergyRequired(this.transporterState);
            if (energyRequired > 0) {
                isPowered = this.energy_consume(energyRequired, false);
                if (!isPowered) {
                    this.reasonJammed = "Insufficient energy for operation";
                    this.transporterState = EnumTransporterState.IDLE;
                    this.tickCooldown = Math.max(this.tickCooldown, WarpDriveConfig.TRANSPORTER_JAMMED_COOLDOWN_TICKS);
                }
            } else {
                isPowered = true;
            }
            if (isPowered && (this.transporterState == EnumTransporterState.ACQUIRING || this.transporterState == EnumTransporterState.ENERGIZING)) {
                double overshoot = 0.01;
                this.lockStrengthActual = Math.min(this.lockStrengthOptimal, this.lockStrengthActual + this.lockStrengthSpeed * (this.lockStrengthOptimal - this.lockStrengthActual + 0.01));
            } else {
                this.lockStrengthActual = Math.max(0.0, this.lockStrengthActual * WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_FACTOR_PER_TICK);
            }
        }
        if (this.isBlockUpdated) {
            this.tickUpdateRegistry = Math.min(10, this.tickUpdateRegistry);
        }
        --this.tickUpdateRegistry;
        if (this.tickUpdateRegistry <= 0) {
            this.tickUpdateRegistry = 20 * WarpDriveConfig.STARMAP_REGISTRY_UPDATE_INTERVAL_SECONDS;
            this.isBlockUpdated = false;
            this.updateScanners();
            if (this.uuid == null || this.uuid.getMostSignificantBits() == 0L && this.uuid.getLeastSignificantBits() == 0L) {
                this.uuid = UUID.randomUUID();
            }
            WarpDrive.starMap.updateInRegistry(this);
        }
        this.updateMetadata(!this.isConnected ? 0 : (!this.isEnabled ? 1 : (!isPowered ? 2 : 3)));
        if (this.isConnected && this.isEnabled) {
            if (this.isLockRequested && this.isJammed) {
                PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3(this).translate(0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
            }
            if (this.lockStrengthActual > (double)0.01f || this.transporterState == EnumTransporterState.ENERGIZING && this.tickEnergizing > 0 || this.tickCooldown > 0) {
                PacketHandler.sendTransporterEffectPacket(this.field_145850_b, this.globalPositionLocal, this.globalPositionRemote, this.lockStrengthActual, this.movingEntitiesLocal.values(), this.movingEntitiesRemote.values(), this.tickEnergizing, this.tickCooldown, 64);
            }
        }
        --this.tickComputerPulse;
        if (this.tickComputerPulse < 0) {
            this.tickComputerPulse = 20;
            if (this.lockStrengthActual > (double)0.01f) {
                this.sendEvent("transporterPulse", this.lockStrengthActual);
            }
        }
        --this.tickUpdateParameters;
        if (this.tickUpdateParameters <= 0) {
            this.tickUpdateParameters = WarpDriveConfig.TRANSPORTER_SETUP_UPDATE_PARAMETERS_TICKS;
            this.updateParameters();
        }
        switch (this.transporterState) {
            case DISABLED: {
                this.isLockRequested = false;
                this.isEnergizeRequested = false;
                this.lockStrengthActual = 0.0;
                if (!this.isConnected || !this.isEnabled) break;
                this.transporterState = EnumTransporterState.IDLE;
                break;
            }
            case IDLE: {
                if (!this.isLockRequested || this.tickCooldown != 0) break;
                this.tickUpdateParameters = 0;
                this.transporterState = EnumTransporterState.ACQUIRING;
                break;
            }
            case ACQUIRING: {
                if (!this.isLockRequested) {
                    this.transporterState = EnumTransporterState.IDLE;
                    break;
                }
                if (this.isJammed) {
                    this.tickCooldown += WarpDriveConfig.TRANSPORTER_JAMMED_COOLDOWN_TICKS;
                    this.transporterState = EnumTransporterState.IDLE;
                    break;
                }
                if (this.tickCooldown != 0) break;
                if (this.globalPositionBeacon != null && !this.isEnergizeRequested && this.lockStrengthActual >= 0.85) {
                    this.isEnergizeRequested = true;
                    break;
                }
                if (!this.isEnergizeRequested) break;
                this.tickUpdateParameters = 0;
                this.tickEnergizing = WarpDriveConfig.TRANSPORTER_ENERGIZING_CHARGING_TICKS;
                this.transporterState = EnumTransporterState.ENERGIZING;
                break;
            }
            case ENERGIZING: {
                if (!this.isLockRequested) {
                    this.transporterState = EnumTransporterState.IDLE;
                    break;
                }
                if (!this.isEnergizeRequested) {
                    this.transporterState = EnumTransporterState.ACQUIRING;
                    break;
                }
                if (this.isJammed) {
                    this.tickCooldown += WarpDriveConfig.TRANSPORTER_JAMMED_COOLDOWN_TICKS;
                    this.transporterState = EnumTransporterState.IDLE;
                    break;
                }
                if (this.tickCooldown > 0) break;
                this.state_energizing();
                break;
            }
            default: {
                this.transporterState = EnumTransporterState.DISABLED;
            }
        }
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.rebootTransporter();
            WarpDrive.starMap.removeFromRegistry(this);
        }
        super.func_145843_s();
    }

    private void rebootTransporter() {
        if (this.vLocalScanners != null) {
            for (VectorI vScanner : this.vLocalScanners) {
                Block block = this.field_145850_b.func_147439_a(vScanner.x, vScanner.y, vScanner.z);
                if (block != WarpDrive.blockTransporterScanner) continue;
                this.field_145850_b.func_72921_c(vScanner.x, vScanner.y, vScanner.z, 0, 2);
            }
        }
    }

    private void state_energizing() {
        WorldServer worldRemote = Commons.getOrCreateWorldServer(this.globalPositionRemote.dimensionId);
        if (worldRemote == null) {
            WarpDrive.logger.error(String.format("Unable to initialize dimension %d for %s", this.globalPositionRemote.dimensionId, this));
            this.isJammed = true;
            this.reasonJammed = String.format("Unable to initialize dimension %d", this.globalPositionRemote.dimensionId);
            return;
        }
        EntityValues entityValues = this.updateEntitiesToEnergize(worldRemote);
        if (this.tickEnergizing == WarpDriveConfig.TRANSPORTER_ENERGIZING_CHARGING_TICKS) {
            this.sendEvent("transporterEnergizing", entityValues.count);
        }
        if (entityValues.count == 0) {
            this.isEnergizeRequested = false;
            this.tickCooldown += WarpDriveConfig.TRANSPORTER_ENERGIZING_COOLDOWN_TICKS;
            this.transporterState = EnumTransporterState.ACQUIRING;
            return;
        }
        if (this.tickEnergizing > 0) {
            --this.tickEnergizing;
            return;
        }
        if (this.vRemoteScanners == null || this.vRemoteScanners.isEmpty()) {
            this.energizeEntities(this.lockStrengthActual, this.movingEntitiesLocal, (World)worldRemote, this.globalPositionRemote.getVectorI());
        } else {
            this.energizeEntities(this.lockStrengthActual, this.movingEntitiesLocal, (World)worldRemote, this.vRemoteScanners);
        }
        if (this.vLocalScanners != null && !this.vLocalScanners.isEmpty()) {
            this.energizeEntities(this.lockStrengthActual, this.movingEntitiesRemote, this.field_145850_b, this.vLocalScanners);
        }
        this.isEnergizeRequested = false;
        this.tickUpdateParameters = 0;
        this.tickCooldown += WarpDriveConfig.TRANSPORTER_ENERGIZING_COOLDOWN_TICKS;
        this.lockStrengthActual = Math.max(0.0, this.lockStrengthActual - WarpDriveConfig.TRANSPORTER_ENERGIZING_LOCKING_LOST);
        this.transporterState = EnumTransporterState.ACQUIRING;
        if (this.globalPositionBeacon != null) {
            WorldServer world = this.globalPositionBeacon.getWorldServerIfLoaded();
            if (world == null) {
                WarpDrive.logger.warn("Unable to disable TransporterBeacon %s: world isn't loaded", new Object[]{this.globalPositionBeacon});
            } else {
                TileEntity tileEntity = world.func_147438_o(this.globalPositionBeacon.x, this.globalPositionBeacon.y, this.globalPositionBeacon.z);
                if (tileEntity instanceof ITransporterBeacon) {
                    ((ITransporterBeacon)tileEntity).energizeDone();
                } else {
                    WarpDrive.logger.warn("Unable to disable TransporterBeacon %s: unsupported tile entity %s", new Object[]{this.globalPositionBeacon, tileEntity});
                }
            }
        }
    }

    private void energizeEntities(double lockStrength, HashMap<Integer, MovingEntity> movingEntities, World world, VectorI vPosition) {
        for (Map.Entry<Integer, MovingEntity> entryEntity : movingEntities.entrySet()) {
            MovingEntity movingEntity = entryEntity.getValue();
            this.energizeEntity(lockStrength, movingEntity, world, vPosition);
        }
    }

    private void energizeEntities(double lockStrength, HashMap<Integer, MovingEntity> movingEntities, World world, ArrayList<VectorI> vScanners) {
        for (Map.Entry<Integer, MovingEntity> entryEntity : movingEntities.entrySet()) {
            int indexEntity = entryEntity.getKey();
            MovingEntity movingEntity = entryEntity.getValue();
            VectorI vScanner = vScanners.get(indexEntity);
            this.energizeEntity(lockStrength, movingEntity, world, vScanner);
        }
    }

    private void energizeEntity(double lockStrength, MovingEntity movingEntity, World world, VectorI vPosition) {
        if (movingEntity == MovingEntity.INVALID) {
            return;
        }
        if (movingEntity == null || vPosition == null) {
            WarpDrive.logger.warn(String.format("Invalid entity %s for position %s, skipping transportation...", movingEntity, vPosition));
            return;
        }
        Entity entity = movingEntity.getEntity();
        if (entity == null) {
            WarpDrive.logger.warn("Entity went missing, skipping transportation...");
            return;
        }
        String nameEntity = entity.func_70005_c_();
        if (lockStrength < 1.0 && world.field_73012_v.nextDouble() > lockStrength) {
            if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                WarpDrive.logger.info(String.format("Insufficient lock strength %.3f to transport %s", lockStrength, entity));
            }
            TileEntityTransporterCore.applyTeleportationDamages(false, entity, lockStrength);
            this.sendEvent("transporterFailure", nameEntity);
            return;
        }
        Vector3 v3Target = new Vector3((double)vPosition.x + 0.5, (double)vPosition.y + 0.99, (double)vPosition.z + 0.5);
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(String.format("Transporting entity %s to %s", entity, v3Target));
        }
        Commons.moveEntity(entity, world, v3Target);
        TileEntityTransporterCore.applyTeleportationDamages(false, entity, lockStrength);
        this.sendEvent("transporterSuccess", nameEntity);
    }

    @Override
    public String getStatusHeader() {
        if (this.globalPositionLocal == null || this.globalPositionRemote == null) {
            return super.getStatusHeader();
        }
        return super.getStatusHeader() + "\n" + StatCollector.func_74837_a((String)"warpdrive.transporter.status", (Object[])new Object[]{this.globalPositionLocal.x, this.globalPositionLocal.y, this.globalPositionLocal.z, this.globalPositionRemote.x, this.globalPositionRemote.y, this.globalPositionRemote.z});
    }

    @Override
    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    @Override
    public void setBeamFrequency(int beamFrequency) {
        if (this.beamFrequency != beamFrequency && beamFrequency <= 65000 && beamFrequency > 0) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Beam frequency set from " + this.beamFrequency + " to " + beamFrequency);
            }
            if (this.func_145830_o()) {
                ForceFieldRegistry.removeFromRegistry(this);
            }
            this.beamFrequency = beamFrequency;
            this.tickUpdateParameters = 0;
        }
        this.func_70296_d();
    }

    @Override
    public EnumStarMapEntryType getStarMapType() {
        return EnumStarMapEntryType.TRANSPORTER;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public AxisAlignedBB getStarMapArea() {
        return AxisAlignedBB.func_72330_a((double)Math.min((double)(this.field_145851_c - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_145851_c : this.aabbLocalScanners.field_72340_a), (double)Math.min((double)(this.field_145848_d - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_Y_BELOW_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_145848_d : this.aabbLocalScanners.field_72338_b), (double)Math.min((double)(this.field_145849_e - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_145849_e : this.aabbLocalScanners.field_72339_c), (double)Math.max((double)(this.field_145851_c + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_145851_c : this.aabbLocalScanners.field_72336_d), (double)Math.max((double)(this.field_145848_d + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_Y_ABOVE_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_145848_d : this.aabbLocalScanners.field_72337_e), (double)Math.max((double)(this.field_145849_e + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS), this.aabbLocalScanners == null ? (double)this.field_145849_e : this.aabbLocalScanners.field_72334_f));
    }

    @Override
    public int getMass() {
        return this.vLocalScanners == null ? 0 : this.vLocalScanners.size();
    }

    @Override
    public double getIsolationRate() {
        return 0.0;
    }

    @Override
    public String getStarMapName() {
        return this.transporterName;
    }

    @Override
    public void onBlockUpdatedInArea(VectorI vector, Block block, int metadata) {
        if (this.isBlockUpdated) {
            return;
        }
        if (block instanceof BlockTransporterScanner || block instanceof BlockTransporterContainment) {
            this.isBlockUpdated = true;
            return;
        }
        if (this.aabbLocalScanners != null && (double)vector.x >= this.aabbLocalScanners.field_72340_a && (double)vector.y >= this.aabbLocalScanners.field_72338_b && (double)vector.z >= this.aabbLocalScanners.field_72339_c && (double)vector.x < this.aabbLocalScanners.field_72336_d && (double)vector.y < this.aabbLocalScanners.field_72337_e && (double)vector.z < this.aabbLocalScanners.field_72334_f) {
            this.isBlockUpdated = true;
        }
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info("onBlockUpdatedInArea block " + block);
        }
    }

    private void updateScanners() {
        int xMin = this.field_145851_c - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
        int xMax = this.field_145851_c + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
        int yMin = this.field_145848_d - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_Y_BELOW_BLOCKS;
        int yMax = this.field_145848_d + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_Y_ABOVE_BLOCKS;
        int zMin = this.field_145849_e - WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
        int zMax = this.field_145849_e + WarpDriveConfig.TRANSPORTER_SETUP_SCANNER_RANGE_XZ_BLOCKS;
        ArrayList<VectorI> vScanners = new ArrayList<VectorI>(16);
        HashSet<VectorI> vContainments = new HashSet<VectorI>(64);
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                if (y < 0 || y > 254) continue;
                for (int z = zMin; z <= zMax; ++z) {
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    if (!(block instanceof BlockTransporterScanner)) continue;
                    VectorI vScanner = new VectorI(x, y, z);
                    Collection<VectorI> vValidContainments = ((BlockTransporterScanner)block).getValidContainment(this.field_145850_b, vScanner);
                    if (vValidContainments == null || vValidContainments.isEmpty()) {
                        this.field_145850_b.func_72921_c(x, y, z, 0, 2);
                        PacketHandler.sendSpawnParticlePacket(this.field_145850_b, "jammed", (byte)5, new Vector3((double)x + 0.5, (double)y + 1.5, (double)z + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
                        continue;
                    }
                    vScanners.add(vScanner);
                    vContainments.addAll(vValidContainments);
                    this.field_145850_b.func_72921_c(x, y, z, 1, 2);
                }
            }
        }
        this.setLocalScanners(vScanners, vContainments);
    }

    private void setLocalScanners(ArrayList<VectorI> vScanners, Collection<VectorI> vContainments) {
        if (vScanners == null || vScanners.isEmpty()) {
            this.vLocalScanners = null;
            this.vLocalContainments = null;
            this.aabbLocalScanners = null;
            return;
        }
        VectorI vMin = vScanners.get(0).clone();
        VectorI vMax = vScanners.get(0).clone();
        for (VectorI vScanner : vScanners) {
            vMin.x = Math.min(vMin.x, vScanner.x - 1);
            vMin.y = Math.min(vMin.y, vScanner.y);
            vMin.z = Math.min(vMin.z, vScanner.z - 1);
            vMax.x = Math.max(vMax.x, vScanner.x + 1);
            vMax.y = Math.max(vMax.y, vScanner.y + 2);
            vMax.z = Math.max(vMax.z, vScanner.z + 1);
        }
        this.vLocalScanners = vScanners;
        this.vLocalContainments = new ArrayList<VectorI>(vContainments);
        this.aabbLocalScanners = AxisAlignedBB.func_72330_a((double)vMin.x, (double)vMin.y, (double)vMin.z, (double)((double)vMax.x + 1.0), (double)((double)vMax.y + 1.0), (double)((double)vMax.z + 1.0));
    }

    public Collection<VectorI> getContainments() {
        return this.vLocalContainments;
    }

    private void updateParameters() {
        WorldServer worldRemote;
        this.isJammed = false;
        this.reasonJammed = "";
        if (this.transporterState != EnumTransporterState.ENERGIZING) {
            this.movingEntitiesLocal.clear();
            this.movingEntitiesRemote.clear();
        }
        if (!this.isConnected) {
            this.isJammed = true;
            this.reasonJammed = "Beam frequency not set";
            return;
        }
        CelestialObject celestialObjectLocal = CelestialObjectManager.get(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        Vector3 v3Local_universal = StarMapRegistry.getUniversalCoordinates(celestialObjectLocal, this.globalPositionLocal.x, this.globalPositionLocal.y, this.globalPositionLocal.z);
        if (this.globalPositionBeacon != null) {
            WorldServer worldBeacon = this.globalPositionBeacon.getWorldServerIfLoaded();
            if (worldBeacon == null) {
                this.globalPositionBeacon = null;
                this.isLockRequested = false;
                this.isEnergizeRequested = false;
            } else {
                TileEntity tileEntity = worldBeacon.func_147438_o(this.globalPositionBeacon.x, this.globalPositionBeacon.y, this.globalPositionBeacon.z);
                if (!(tileEntity instanceof ITransporterBeacon) || !((ITransporterBeacon)tileEntity).isActive()) {
                    this.globalPositionBeacon = null;
                    this.isLockRequested = false;
                    this.isEnergizeRequested = false;
                }
            }
        }
        GlobalPosition globalPositionRemoteNew = null;
        if (this.globalPositionBeacon != null) {
            globalPositionRemoteNew = this.globalPositionBeacon;
        } else if (this.remoteLocationRequested instanceof VectorI) {
            VectorI vRequest = ((VectorI)this.remoteLocationRequested).clone();
            if (vRequest.y < 0) {
                CelestialObject celestialObjectChild = CelestialObjectManager.getClosestChild(this.field_145850_b, this.field_145851_c, this.field_145849_e);
                if (celestialObjectChild == null) {
                    this.reasonJammed = "Not in orbit of a planet";
                } else {
                    vRequest.translate(celestialObjectChild.getEntryOffset());
                    globalPositionRemoteNew = new GlobalPosition(celestialObjectChild.dimensionId, vRequest.x, (vRequest.y + 1024) % 256, vRequest.z);
                }
            } else if (vRequest.y > 256) {
                vRequest.translateBack(celestialObjectLocal.getEntryOffset());
                globalPositionRemoteNew = new GlobalPosition(celestialObjectLocal.parent.dimensionId, vRequest.x, vRequest.y % 256, vRequest.z);
            } else {
                globalPositionRemoteNew = new GlobalPosition(this.field_145850_b.field_73011_w.field_76574_g, vRequest.x, vRequest.y, vRequest.z);
            }
        } else if (this.remoteLocationRequested instanceof UUID) {
            globalPositionRemoteNew = WarpDrive.starMap.getByUUID(EnumStarMapEntryType.TRANSPORTER, (UUID)this.remoteLocationRequested);
            if (globalPositionRemoteNew == null) {
                this.reasonJammed = "Unknown transporter signature";
            }
        } else if (this.remoteLocationRequested instanceof String) {
            EntityPlayerMP entityPlayer = Commons.getOnlinePlayerByName((String)this.remoteLocationRequested);
            if (entityPlayer == null) {
                this.reasonJammed = "No player by that name";
            } else {
                ItemStack itemStackHeld = entityPlayer.func_70694_bm();
                if (itemStackHeld == null || itemStackHeld.field_77994_a <= 0 || !(itemStackHeld.func_77973_b() instanceof IItemTransporterBeacon)) {
                    this.reasonJammed = "No transporter beacon in player hand";
                } else if (!((IItemTransporterBeacon)itemStackHeld.func_77973_b()).isActive(itemStackHeld)) {
                    this.reasonJammed = "Player beacon is out of power";
                } else {
                    globalPositionRemoteNew = new GlobalPosition((Entity)entityPlayer);
                }
            }
        } else {
            this.reasonJammed = "No remote location defined";
        }
        if (globalPositionRemoteNew == null || !globalPositionRemoteNew.equals(this.globalPositionRemote)) {
            this.globalPositionRemote = globalPositionRemoteNew;
            this.lockStrengthActual = 0.0;
            if (this.transporterState == EnumTransporterState.ENERGIZING) {
                this.transporterState = EnumTransporterState.ACQUIRING;
            }
            boolean bl = this.isJammed = globalPositionRemoteNew == null;
            if (this.isJammed) {
                return;
            }
        }
        CelestialObject celestialObjectRemote = this.globalPositionRemote.getCelestialObject(this.field_145850_b.field_72995_K);
        Vector3 v3Remote_universal = this.globalPositionRemote.getUniversalCoordinates(this.field_145850_b.field_72995_K);
        if (celestialObjectRemote == null) {
            this.isJammed = true;
            this.reasonJammed = "Unknown remote celestial object";
            return;
        }
        if (celestialObjectLocal != celestialObjectRemote) {
            if (celestialObjectLocal.isHyperspace() || celestialObjectRemote.isHyperspace()) {
                this.isJammed = true;
                this.reasonJammed = "Blocked by warp field barrier";
                return;
            }
            if (celestialObjectRemote.isVirtual()) {
                this.isJammed = true;
                this.reasonJammed = "Unable to reach virtual planet";
                return;
            }
        }
        if (this.transporterState == EnumTransporterState.ACQUIRING || this.transporterState == EnumTransporterState.ENERGIZING) {
            worldRemote = Commons.getOrCreateWorldServer(celestialObjectRemote.dimensionId);
            if (worldRemote == null) {
                WarpDrive.logger.error(String.format("Unable to initialize dimension %d for %s", celestialObjectRemote.dimensionId, this));
                this.isJammed = true;
                this.reasonJammed = String.format("Unable to initialize dimension %d", celestialObjectRemote.dimensionId);
                return;
            }
        } else {
            worldRemote = DimensionManager.getWorld((int)celestialObjectRemote.dimensionId);
        }
        double rangeActualSquared = v3Local_universal.clone().subtract(v3Remote_universal).getMagnitudeSquared();
        int rangeActual = (int)Math.ceil(Math.sqrt(rangeActualSquared));
        FocusValues focusValuesLocal = TileEntityTransporterCore.getFocusValueAtCoordinates(this.field_145850_b, this.globalPositionLocal.getVectorI(), 0);
        FocusValues focusValuesRemote = TileEntityTransporterCore.getFocusValueAtCoordinates((World)worldRemote, this.globalPositionRemote.getVectorI(), WarpDriveConfig.TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS);
        double focusBoost = Commons.interpolate(1.0, 0.0, WarpDriveConfig.TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR, WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_BONUS_AT_MAX_ENERGY_FACTOR, this.energyFactor);
        this.lockStrengthOptimal = (focusValuesLocal.strength + focusValuesRemote.strength) / 2.0 + focusBoost;
        this.lockStrengthSpeed = (focusValuesLocal.speed + focusValuesRemote.speed) / 2.0 / (double)WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_OPTIMAL_TICKS;
        int rangeMax = WarpDriveConfig.TRANSPORTER_RANGE_BASE_BLOCKS + WarpDriveConfig.TRANSPORTER_RANGE_UPGRADE_BLOCKS * focusValuesLocal.countRangeUpgrades + WarpDriveConfig.TRANSPORTER_RANGE_UPGRADE_BLOCKS * focusValuesRemote.countRangeUpgrades;
        this.vRemoteScanners = focusValuesRemote.vScanners;
        EntityValues entityValues = this.updateEntitiesToEnergize(worldRemote);
        this.energyCostForAcquiring = Math.max(0.0, WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[0] + WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[1] * (double)(this.vLocalScanners == null ? 1 : this.vLocalScanners.size()) * (Math.log(1.0 + WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[2] * (double)rangeActual) + Math.pow(WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[3] + (double)rangeActual, WarpDriveConfig.TRANSPORTER_LOCKING_ENERGY_FACTORS[4])));
        this.energyCostForEnergizing = Math.max(0.0, WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[0] + WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[1] * (double)entityValues.mass * (Math.log(1.0 + WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[2] * (double)rangeActual) + Math.pow(WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[3] + (double)rangeActual, WarpDriveConfig.TRANSPORTER_ENERGIZING_ENERGY_FACTORS[4])));
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(String.format("Transporter parameters at (%d %d %d) are range (actual %d max %d) lockStrength (actual %.5f optimal %.5f speed %.5f)", this.field_145851_c, this.field_145848_d, this.field_145849_e, rangeActual, rangeMax, this.lockStrengthActual, this.lockStrengthOptimal, this.lockStrengthSpeed));
        }
        if (rangeActual < 16) {
            this.isJammed = true;
            this.reasonJammed = "Remote location is too close";
            return;
        }
        if (rangeActual > rangeMax) {
            this.isJammed = true;
            this.reasonJammed = String.format("Out of range: %d > %d m", rangeActual, rangeMax);
            return;
        }
        if (this.field_145850_b == worldRemote) {
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory(this.field_145850_b, this.globalPositionLocal.getVectorI(), this.globalPositionRemote.getVectorI(), this.beamFrequency);
        } else if (v3Local_universal.y > v3Remote_universal.y) {
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory(this.field_145850_b, this.globalPositionLocal.getVectorI(), new VectorI(this.globalPositionLocal.x, -1, this.globalPositionLocal.z), this.beamFrequency);
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory((World)worldRemote, new VectorI(this.globalPositionRemote.x, 256, this.globalPositionRemote.z), this.globalPositionRemote.getVectorI(), this.beamFrequency);
        } else {
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory(this.field_145850_b, this.globalPositionLocal.getVectorI(), new VectorI(this.globalPositionLocal.x, 256, this.globalPositionLocal.z), this.beamFrequency);
            this.isJammed |= TileEntityTransporterCore.isJammedTrajectory((World)worldRemote, new VectorI(this.globalPositionRemote.x, -1, this.globalPositionRemote.z), this.globalPositionRemote.getVectorI(), this.beamFrequency);
        }
        if (this.isJammed) {
            this.reasonJammed = "Blocked by force field or unbreakable block";
        }
    }

    boolean updateBeacon(TileEntity tileEntity, UUID uuid) {
        if (tileEntity == null || !this.uuid.equals(uuid)) {
            WarpDrive.logger.error(String.format("%s Invalid parameters in beacon call to transporter as %s, %s", this, tileEntity, uuid));
            return false;
        }
        if (this.globalPositionBeacon != null && !this.globalPositionBeacon.equals(tileEntity)) {
            int radius2 = WarpDriveConfig.TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS * WarpDriveConfig.TRANSPORTER_FOCUS_SEARCH_RADIUS_BLOCKS;
            if (this.globalPositionBeacon.distance2To(tileEntity) <= radius2) {
                return true;
            }
            if (!this.isJammed && WarpDriveConfig.LOGGING_TRANSPORTER) {
                WarpDrive.logger.info(String.format("%s Conflicting beacon requests received %s is not %s", this, tileEntity, uuid));
            }
            this.isJammed = true;
            this.reasonJammed = "Conflicting beacon requests received";
            this.tickCooldown = Math.max(this.tickCooldown, WarpDriveConfig.TRANSPORTER_JAMMED_COOLDOWN_TICKS);
            return false;
        }
        if (this.globalPositionBeacon == null) {
            this.globalPositionBeacon = new GlobalPosition(tileEntity);
            this.energyFactor = Math.max(4.0, this.energyFactor);
            this.isJammed = true;
            this.reasonJammed = "Beacon request received";
            this.lockStrengthActual = 0.0;
            if (this.transporterState == EnumTransporterState.ENERGIZING) {
                this.transporterState = EnumTransporterState.ACQUIRING;
            }
        }
        this.isLockRequested = true;
        return true;
    }

    private static FocusValues getFocusValueAtCoordinates(World world, VectorI vLocation, int radius) {
        if (world == null) {
            FocusValues result = new FocusValues();
            result.countRangeUpgrades = 0;
            result.speed = WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_IN_WILDERNESS;
            result.strength = WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_IN_WILDERNESS;
            return result;
        }
        int countBeacons = 0;
        int countTransporters = 0;
        int sumRangeUpgrades = 0;
        int sumFocusUpgrades = 0;
        int xMin = vLocation.x - radius;
        int xMax = vLocation.x + radius;
        int yMin = vLocation.y - radius;
        int yMax = vLocation.y + radius;
        int zMin = vLocation.z - radius;
        int zMax = vLocation.z + radius;
        ArrayList<VectorI> vScanners = null;
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                if (y < 0 || y > 254) continue;
                for (int z = zMin; z <= zMax; ++z) {
                    TileEntity tileEntity;
                    Block block = world.func_147439_a(x, y, z);
                    if (block instanceof BlockTransporterBeacon) {
                        tileEntity = world.func_147438_o(x, y, z);
                        if (!(tileEntity instanceof TileEntityTransporterBeacon) || !((TileEntityTransporterBeacon)tileEntity).isActive()) continue;
                        ++countBeacons;
                        continue;
                    }
                    if (!(block instanceof BlockTransporterCore) || !((tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityTransporterCore) || !((TileEntityTransporterCore)tileEntity).isEnabled || !((TileEntityTransporterCore)tileEntity).isConnected) continue;
                    ++countTransporters;
                    vScanners = ((TileEntityTransporterCore)tileEntity).vLocalScanners;
                    sumRangeUpgrades += ((TileEntityTransporterCore)tileEntity).getUpgradeCount(EnumComponentType.ENDER_CRYSTAL);
                    sumFocusUpgrades += ((TileEntityTransporterCore)tileEntity).getUpgradeCount(EnumComponentType.EMERALD_CRYSTAL);
                }
            }
        }
        FocusValues result = new FocusValues();
        if (countTransporters == 1) {
            result.vScanners = vScanners;
            result.countRangeUpgrades = sumRangeUpgrades;
            result.speed = WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_AT_TRANSPORTER + (double)sumFocusUpgrades * WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_UPGRADE;
            result.strength = WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_AT_TRANSPORTER + (double)sumFocusUpgrades * WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_UPGRADE;
        } else if (countBeacons > 0) {
            result.countRangeUpgrades = 0;
            result.speed = WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_AT_BEACON;
            result.strength = WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_AT_BEACON;
        } else {
            result.countRangeUpgrades = 0;
            result.speed = WarpDriveConfig.TRANSPORTER_LOCKING_SPEED_IN_WILDERNESS;
            result.strength = WarpDriveConfig.TRANSPORTER_LOCKING_STRENGTH_IN_WILDERNESS;
        }
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(String.format("Transporter getFocusValueAtCoordinates %s gives range %d speed %.3f strength %.3f", vLocation, result.countRangeUpgrades, result.speed, result.strength));
        }
        return result;
    }

    private static boolean isJammedTrajectory(World world, VectorI vSource, VectorI vDestination, int beamFrequency) {
        if (world == null) {
            return false;
        }
        VectorI vPath = vDestination.clone().translateBack(vSource);
        int length = (int)Math.ceil(3.0 * Math.sqrt(vPath.getMagnitudeSquared()));
        Vector3 v3Delta = new Vector3((double)vPath.x / (double)length, (double)vPath.y / (double)length, (double)vPath.z / (double)length);
        Vector3 v3Current = new Vector3(vSource.x, vSource.y, vSource.z).translate(0.5);
        VectorI vCurrent = vSource.clone();
        VectorI vPrevious = vCurrent.clone();
        for (int step = 0; step < length; ++step) {
            v3Current.translate(v3Delta);
            vCurrent.x = (int)Math.round(v3Current.x);
            vCurrent.y = (int)Math.round(v3Current.y);
            vCurrent.z = (int)Math.round(v3Current.z);
            if (vCurrent.equals(vPrevious)) continue;
            if (TileEntityTransporterCore.isJammedCoordinate(world, vCurrent, beamFrequency)) {
                return true;
            }
            vPrevious.x = vCurrent.x;
            vPrevious.y = vCurrent.y;
            vPrevious.z = vCurrent.z;
        }
        return false;
    }

    private static boolean isJammedCoordinate(World world, VectorI vCurrent, int beamFrequency) {
        TileEntity tileEntity;
        Block block = vCurrent.getBlock((IBlockAccess)world);
        if (Dictionary.BLOCKS_NOBLINK.contains(block)) {
            if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                WarpDrive.logger.info(String.format("Transporter beam jammed by blacklisted block %s", block));
            }
            return true;
        }
        if (block instanceof BlockForceField && (tileEntity = vCurrent.getTileEntity((IBlockAccess)world)) instanceof TileEntityForceField) {
            ForceFieldSetup forceFieldSetup = ((TileEntityForceField)tileEntity).getForceFieldSetup();
            if (forceFieldSetup == null) {
                WarpDrive.logger.warn(String.format("Transporter beam jammed by non-loaded force field projector at %s", tileEntity));
                return true;
            }
            if (forceFieldSetup.beamFrequency != beamFrequency) {
                if (WarpDriveConfig.LOGGING_TRANSPORTER) {
                    WarpDrive.logger.info(String.format("Transporter beam jammed by invalid frequency against %s", tileEntity));
                }
                return true;
            }
        }
        return false;
    }

    private int getEnergyRequired(EnumTransporterState transporterState) {
        switch (transporterState) {
            case DISABLED: {
                return 0;
            }
            case IDLE: {
                return 0;
            }
            case ACQUIRING: {
                return (int)Math.ceil(this.energyCostForAcquiring * this.energyFactor);
            }
            case ENERGIZING: {
                return (int)Math.ceil(this.energyCostForEnergizing * this.energyFactor / (double)WarpDriveConfig.TRANSPORTER_ENERGIZING_CHARGING_TICKS);
            }
        }
        return 0;
    }

    private static void applyTeleportationDamages(boolean isPreTeleportation, Entity entity, double strength) {
        if (entity.field_70128_L || entity.func_85032_ar()) {
            return;
        }
        double strengthToUse = isPreTeleportation ? strength : Math.random() * WarpDriveConfig.TRANSPORTER_ENERGIZING_SUCCESS_LOCK_BONUS + strength;
        double strengthSafe = 0.95;
        double strengthMaxDamage = 0.65;
        double strengthNoDamage = 0.1;
        if (strengthToUse > 0.95) {
            return;
        }
        double damageNormalized = (0.95 - strengthToUse) / 0.29999999999999993;
        double damageMax = isPreTeleportation ? (double)WarpDriveConfig.TRANSPORTER_ENERGIZING_FAILURE_MAX_DAMAGE : (double)WarpDriveConfig.TRANSPORTER_ENERGIZING_SUCCESS_MAX_DAMAGE;
        double damageAmount = Commons.clamp(1.0, 1000.0, damageMax * damageNormalized);
        if (WarpDriveConfig.LOGGING_TRANSPORTER) {
            WarpDrive.logger.info(String.format("Applying teleportation damages %s transport with %.3f strength, %.2f damage towards %s", isPreTeleportation ? "pre" : "post", strengthToUse, damageAmount, entity));
        }
        if (entity instanceof EntityLivingBase) {
            boolean isCreative;
            entity.func_70097_a((DamageSource)WarpDrive.damageTeleportation, (float)damageAmount);
            boolean bl = isCreative = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
            if (!isCreative) {
                if (isPreTeleportation) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 20, 0, true));
                } else {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100, 0, true));
                }
            }
        } else if (strengthToUse > 0.1) {
            VectorI vPosition = new VectorI(entity);
            if (entity.field_70170_p.func_147437_c(vPosition.x, vPosition.y, vPosition.z)) {
                entity.field_70170_p.func_147465_d(vPosition.x, vPosition.y, vPosition.z, (Block)Blocks.field_150356_k, 6, 2);
            }
        }
    }

    private EntityValues updateEntitiesToEnergize(WorldServer worldRemote) {
        int countLocalScanners = this.vLocalScanners == null ? 0 : this.vLocalScanners.size();
        int countScanners = this.vRemoteScanners == null ? countLocalScanners : Math.min(countLocalScanners, this.vRemoteScanners.size());
        EntityValues entityValues = new EntityValues();
        if (this.transporterState != EnumTransporterState.ENERGIZING && this.transporterState != EnumTransporterState.ACQUIRING) {
            entityValues.count = countScanners;
            entityValues.mass = 2 * countScanners;
            return entityValues;
        }
        EntityValues entityValuesLocal = TileEntityTransporterCore.updateEntitiesOnScanners(this.field_145850_b, this.vLocalScanners, countScanners, this.movingEntitiesLocal);
        EntityValues entityValuesRemote = this.vRemoteScanners != null ? TileEntityTransporterCore.updateEntitiesOnScanners((World)worldRemote, this.vRemoteScanners, countScanners, this.movingEntitiesRemote) : TileEntityTransporterCore.updateEntitiesInArea((World)worldRemote, this.globalPositionRemote, countScanners, this.movingEntitiesRemote);
        entityValues.count = entityValuesLocal.count + entityValuesRemote.count;
        entityValues.mass = entityValuesLocal.mass + entityValuesRemote.mass;
        return entityValues;
    }

    private static EntityValues updateEntitiesOnScanners(World world, ArrayList<VectorI> vScanners, int countScanners, HashMap<Integer, MovingEntity> movingEntities) {
        double tolerance2 = WarpDriveConfig.TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS * WarpDriveConfig.TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS;
        HashSet<Entity> entitiesOnScanners = new HashSet<Entity>(countScanners);
        EntityValues entityValues = new EntityValues();
        for (int index = 0; index < countScanners; ++index) {
            Entity entityOnScanner;
            MovingEntity movingEntity = movingEntities.get(index);
            if (movingEntity == MovingEntity.INVALID) continue;
            if (movingEntity != null) {
                Entity entity = movingEntity.getEntity();
                if (entity == null || entity.field_70128_L) {
                    movingEntity = null;
                } else {
                    double distance2 = movingEntity.getDistanceMoved_square();
                    if (distance2 > tolerance2) {
                        double strength = Math.sqrt(distance2) / Math.sqrt(tolerance2) / 2.0;
                        TileEntityTransporterCore.applyTeleportationDamages(true, entity, strength);
                        movingEntity = MovingEntity.INVALID;
                    }
                }
            }
            if (movingEntity == null && vScanners != null && (entityOnScanner = TileEntityTransporterCore.getCandidateEntityOnScanner(world, vScanners.get(index), entitiesOnScanners)) != null) {
                movingEntity = new MovingEntity(entityOnScanner);
                entitiesOnScanners.add(entityOnScanner);
            }
            if (movingEntity == null) {
                movingEntities.put(index, MovingEntity.INVALID);
                continue;
            }
            movingEntities.put(index, movingEntity);
            ++entityValues.count;
            entityValues.mass = (long)((float)entityValues.mass + movingEntity.getMassFactor());
        }
        return entityValues;
    }

    private static EntityValues updateEntitiesInArea(World world, GlobalPosition globalPosition, int countScanners, HashMap<Integer, MovingEntity> movingEntities) {
        double tolerance2 = WarpDriveConfig.TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS * WarpDriveConfig.TRANSPORTER_ENERGIZING_ENTITY_MOVEMENT_TOLERANCE_BLOCKS;
        LinkedHashSet<Entity> entities = TileEntityTransporterCore.getCandidateEntitiesInArea(world, globalPosition);
        EntityValues entityValues = new EntityValues();
        for (int index = 0; index < countScanners; ++index) {
            Iterator entityIterable;
            Entity entity;
            MovingEntity movingEntity = movingEntities.get(index);
            if (movingEntity == MovingEntity.INVALID) continue;
            if (movingEntity != null) {
                Entity entity2 = movingEntity.getEntity();
                if (entity2 == null || entity2.field_70128_L) {
                    movingEntity = null;
                } else if (entities.contains(entity2)) {
                    double distance2 = movingEntity.getDistanceMoved_square();
                    if (distance2 > tolerance2) {
                        double strength = Math.sqrt(distance2) / Math.sqrt(tolerance2) / 2.0;
                        TileEntityTransporterCore.applyTeleportationDamages(true, entity2, strength);
                        movingEntity = MovingEntity.INVALID;
                    } else {
                        entities.remove(entity2);
                    }
                } else {
                    movingEntity = MovingEntity.INVALID;
                }
            }
            if (movingEntity == null && !entities.isEmpty() && (entity = (Entity)(entityIterable = entities.iterator()).next()) != null) {
                movingEntity = new MovingEntity(entity);
                entityIterable.remove();
            }
            if (movingEntity == null) {
                movingEntities.put(index, MovingEntity.INVALID);
                continue;
            }
            movingEntities.put(index, movingEntity);
            ++entityValues.count;
            entityValues.mass = (long)((float)entityValues.mass + movingEntity.getMassFactor());
        }
        return entityValues;
    }

    private static Entity getCandidateEntityOnScanner(World world, VectorI vScanner, HashSet<Entity> entitiesOnScanners) {
        if (vScanner == null || world == null) {
            return null;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)vScanner.x - 0.05), (double)((double)vScanner.y - 1.0), (double)((double)vScanner.z - 0.05), (double)((double)vScanner.x + 1.05), (double)((double)vScanner.y + 2.0), (double)((double)vScanner.z + 1.05));
        List entities = world.func_72839_b(null, aabb);
        Entity entityReturn = null;
        int countEntities = 0;
        for (Object object : entities) {
            if (!(object instanceof Entity)) continue;
            Entity entity = (Entity)object;
            String entityId = EntityList.func_75621_b((Entity)entity);
            if (Dictionary.ENTITIES_LEFTBEHIND.contains(entityId)) {
                if (!WarpDriveConfig.LOGGING_TRANSPORTER) continue;
                WarpDrive.logger.info(String.format("Entity is not valid for transportation (id %s) %s", entityId, entity));
                continue;
            }
            if (entitiesOnScanners.contains(entity)) continue;
            entityReturn = entity;
            ++countEntities;
        }
        if (countEntities > 1) {
            PacketHandler.sendSpawnParticlePacket(world, "jammed", (byte)5, new Vector3((double)vScanner.x + 0.5, (double)vScanner.y + 1.5, (double)vScanner.z + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
            return null;
        }
        return entityReturn;
    }

    private static LinkedHashSet<Entity> getCandidateEntitiesInArea(World world, GlobalPosition globalPosition) {
        if (world == null) {
            return new LinkedHashSet<Entity>(0);
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(globalPosition.x - WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS), (double)((double)globalPosition.y - 1.0), (double)(globalPosition.z - WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS), (double)((double)(globalPosition.x + WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS) + 1.0), (double)((double)globalPosition.y + 2.0), (double)((double)(globalPosition.z + WarpDriveConfig.TRANSPORTER_ENTITY_GRAB_RADIUS_BLOCKS) + 1.0));
        List entities = world.func_72839_b(null, aabb);
        LinkedHashSet<Entity> entitiesReturn = new LinkedHashSet<Entity>(entities.size());
        for (Object object : entities) {
            if (!(object instanceof Entity)) continue;
            Entity entity = (Entity)object;
            String entityId = EntityList.func_75621_b((Entity)entity);
            if (Dictionary.ENTITIES_LEFTBEHIND.contains(entityId)) {
                if (!WarpDriveConfig.LOGGING_TRANSPORTER) continue;
                WarpDrive.logger.info(String.format("Entity is not valid for transportation (id %s) %s", entityId, entity));
                continue;
            }
            entitiesReturn.add(entity);
        }
        return entitiesReturn;
    }

    @Override
    public int energy_getMaxStorage() {
        int energyUpgrades = this.getUpgradeCount(EnumComponentType.CAPACITIVE_CRYSTAL);
        return WarpDriveConfig.TRANSPORTER_MAX_ENERGY_STORED + energyUpgrades * WarpDriveConfig.TRANSPORTER_ENERGY_STORED_UPGRADE_BONUS;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.uuid != null) {
            tagCompound.func_74772_a("uuidMost", this.uuid.getMostSignificantBits());
            tagCompound.func_74772_a("uuidLeast", this.uuid.getLeastSignificantBits());
        }
        if (this.vLocalScanners != null && this.vLocalContainments != null) {
            NBTTagList tagListScanners = new NBTTagList();
            for (VectorI vScanner : this.vLocalScanners) {
                NBTTagCompound tagCompoundScanner = vScanner.writeToNBT(new NBTTagCompound());
                tagListScanners.func_74742_a((NBTBase)tagCompoundScanner);
            }
            tagCompound.func_74782_a("scanners", (NBTBase)tagListScanners);
            NBTTagList tagListContainments = new NBTTagList();
            for (VectorI vContainment : this.vLocalContainments) {
                NBTTagCompound tagCompoundContainment = vContainment.writeToNBT(new NBTTagCompound());
                tagListContainments.func_74742_a((NBTBase)tagCompoundContainment);
            }
            tagCompound.func_74782_a("containments", (NBTBase)tagListContainments);
        }
        tagCompound.func_74768_a("beamFrequency", this.beamFrequency);
        tagCompound.func_74778_a("name", this.transporterName);
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        tagCompound.func_74757_a("isLockRequested", this.isLockRequested);
        tagCompound.func_74757_a("isEnergizeRequested", this.isEnergizeRequested);
        NBTTagCompound tagRemoteLocation = new NBTTagCompound();
        if (this.remoteLocationRequested instanceof UUID) {
            tagRemoteLocation.func_74772_a("uuidMost", ((UUID)this.remoteLocationRequested).getMostSignificantBits());
            tagRemoteLocation.func_74772_a("uuidLeast", ((UUID)this.remoteLocationRequested).getLeastSignificantBits());
        } else if (this.remoteLocationRequested instanceof VectorI) {
            tagRemoteLocation = ((VectorI)this.remoteLocationRequested).writeToNBT(tagRemoteLocation);
        } else if (this.remoteLocationRequested instanceof String) {
            tagRemoteLocation.func_74778_a("playerName", (String)this.remoteLocationRequested);
        }
        tagCompound.func_74782_a("remoteLocation", (NBTBase)tagRemoteLocation);
        tagCompound.func_74780_a("energyFactor", this.energyFactor);
        tagCompound.func_74780_a("lockStrengthActual", this.lockStrengthActual);
        tagCompound.func_74768_a("tickCooldown", this.tickCooldown);
        tagCompound.func_74778_a("state", this.transporterState.toString());
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.uuid = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (this.uuid.getMostSignificantBits() == 0L && this.uuid.getLeastSignificantBits() == 0L) {
            this.uuid = UUID.randomUUID();
        }
        if (tagCompound.func_150297_b("scanners", 9) && tagCompound.func_150297_b("containments", 9)) {
            NBTTagList tagListScanners = (NBTTagList)tagCompound.func_74781_a("scanners");
            ArrayList<VectorI> vScanners = new ArrayList<VectorI>(tagListScanners.func_74745_c());
            for (int indexScanner = 0; indexScanner < tagListScanners.func_74745_c(); ++indexScanner) {
                VectorI vScanner = VectorI.createFromNBT(tagListScanners.func_150305_b(indexScanner));
                vScanners.add(vScanner);
            }
            NBTTagList tagListContainments = (NBTTagList)tagCompound.func_74781_a("containments");
            ArrayList<VectorI> vContainments = new ArrayList<VectorI>(tagListContainments.func_74745_c());
            for (int indexContainment = 0; indexContainment < tagListContainments.func_74745_c(); ++indexContainment) {
                VectorI vContainment = VectorI.createFromNBT(tagListContainments.func_150305_b(indexContainment));
                vContainments.add(vContainment);
            }
            this.setLocalScanners(vScanners, vContainments);
        }
        this.beamFrequency = tagCompound.func_74762_e("beamFrequency");
        this.transporterName = tagCompound.func_74779_i("name");
        this.isEnabled = tagCompound.func_74767_n("isEnabled");
        this.isLockRequested = tagCompound.func_74767_n("isLockRequested");
        this.isEnergizeRequested = tagCompound.func_74767_n("isEnergizeRequested");
        NBTBase tagRemoteLocation = tagCompound.func_74781_a("remoteLocation");
        if (tagRemoteLocation instanceof NBTTagCompound) {
            NBTTagCompound tagCompoundRemoteLocation = (NBTTagCompound)tagRemoteLocation;
            if (tagCompoundRemoteLocation.func_74764_b("uuidMost")) {
                this.remoteLocationRequested = new UUID(tagCompoundRemoteLocation.func_74763_f("uuidMost"), tagCompoundRemoteLocation.func_74763_f("uuidLeast"));
            } else if (tagCompoundRemoteLocation.func_74764_b("x")) {
                this.remoteLocationRequested = new VectorI();
                ((VectorI)this.remoteLocationRequested).readFromNBT(tagCompoundRemoteLocation);
            } else if (tagCompoundRemoteLocation.func_74764_b("playerName")) {
                this.remoteLocationRequested = tagCompoundRemoteLocation.func_74779_i("playerName");
            }
        }
        this.energyFactor = Commons.clamp(1.0, WarpDriveConfig.TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR, tagCompound.func_74769_h("energyFactor"));
        this.lockStrengthActual = tagCompound.func_74769_h("lockStrengthActual");
        this.tickCooldown = tagCompound.func_74762_e("tickCooldown");
        try {
            this.transporterState = EnumTransporterState.valueOf(tagCompound.func_74779_i("state"));
        }
        catch (IllegalArgumentException exception) {
            this.transporterState = EnumTransporterState.DISABLED;
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        tagCompound.func_82580_o("uuidMost");
        tagCompound.func_82580_o("uuidLeast");
        tagCompound.func_82580_o("beamFrequency");
        tagCompound.func_82580_o("name");
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("isEnabled");
        return tagCompound;
    }

    public String[] transporterName(Object[] arguments) {
        String transporterNameNew;
        if (arguments.length == 1 && arguments[0] != null && !this.transporterName.equals(transporterNameNew = arguments[0].toString())) {
            this.transporterName = transporterNameNew;
            this.uuid = UUID.randomUUID();
        }
        return new String[]{this.transporterName, this.uuid == null ? null : this.uuid.toString()};
    }

    public Boolean[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isEnabled = Commons.toBool(arguments[0]);
            this.func_70296_d();
        }
        return new Boolean[]{this.isEnabled};
    }

    @Override
    public Object[] state() {
        int energy = this.energy_getEnergyStored();
        String status = this.getStatusHeaderInPureText();
        String state = this.isJammed ? this.reasonJammed : (this.tickCooldown > 0 ? String.format("Cooling down %d s", Math.round(this.tickCooldown / 20)) : this.transporterState.getName());
        return new Object[]{status, state, this.isConnected, this.isEnabled, this.isJammed, energy, this.lockStrengthActual};
    }

    @Override
    public Object[] remoteLocation(Object[] arguments) {
        if (arguments.length == 3) {
            VectorI vNew;
            if (this.remoteLocationRequested instanceof VectorI) {
                vNew = this.computer_getVectorI((VectorI)this.remoteLocationRequested, arguments);
                if (!vNew.equals(this.remoteLocationRequested)) {
                    this.remoteLocationRequested = vNew;
                    this.tickUpdateParameters = 0;
                }
            } else {
                vNew = this.computer_getVectorI(null, arguments);
                if (vNew != null) {
                    this.remoteLocationRequested = vNew;
                    this.tickUpdateParameters = 0;
                }
            }
        } else if (arguments.length == 1 && arguments[0] != null) {
            UUID uuidNew = this.computer_getUUID(null, arguments);
            if (uuidNew != null) {
                if (this.remoteLocationRequested instanceof UUID) {
                    if (!uuidNew.equals(this.remoteLocationRequested)) {
                        this.remoteLocationRequested = uuidNew;
                        this.tickUpdateParameters = 0;
                    }
                } else {
                    this.remoteLocationRequested = uuidNew;
                    this.tickUpdateParameters = 0;
                }
            } else {
                String playerNameNew = (String)arguments[0];
                if (playerNameNew != null && !playerNameNew.equals(this.remoteLocationRequested)) {
                    this.remoteLocationRequested = playerNameNew;
                    this.tickUpdateParameters = 0;
                }
            }
        }
        if (this.remoteLocationRequested instanceof VectorI) {
            VectorI vRemoteLocation = (VectorI)this.remoteLocationRequested;
            return new Integer[]{vRemoteLocation.x, vRemoteLocation.y, vRemoteLocation.z};
        }
        return new Object[]{this.remoteLocationRequested == null ? null : this.remoteLocationRequested.toString()};
    }

    public Boolean[] lock(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isLockRequested = Commons.toBool(arguments[0]);
            this.func_70296_d();
        }
        return new Boolean[]{this.isLockRequested};
    }

    public Double[] energyFactor(Object[] arguments) {
        try {
            if (arguments.length >= 1) {
                this.energyFactor = Commons.clamp(1.0, WarpDriveConfig.TRANSPORTER_ENERGIZING_MAX_ENERGY_FACTOR, Commons.toDouble(arguments[0]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Double[]{this.energyFactor};
    }

    public Double[] getLockStrength() {
        return new Double[]{this.lockStrengthActual};
    }

    public Integer[] getEnergyRequired() {
        return new Integer[]{this.getEnergyRequired(EnumTransporterState.ACQUIRING), this.getEnergyRequired(EnumTransporterState.ENERGIZING)};
    }

    public Boolean[] energize(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.isEnergizeRequested = Commons.toBool(arguments[0]);
            this.func_70296_d();
        }
        return new Boolean[]{this.isEnergizeRequested};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] beamFrequency(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setBeamFrequency(arguments.checkInteger(0));
        }
        return new Integer[]{this.beamFrequency};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] transporterName(Context context, Arguments arguments) {
        return this.transporterName(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] remoteLocation(Context context, Arguments arguments) {
        return this.remoteLocation(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] lock(Context context, Arguments arguments) {
        return this.lock(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energyFactor(Context context, Arguments arguments) {
        return this.energyFactor(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getLockStrength(Context context, Arguments arguments) {
        return this.getLockStrength();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyRequired(Context context, Arguments arguments) {
        return this.getEnergyRequired();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energize(Context context, Arguments arguments) {
        return this.energize(this.argumentsOCtoCC(arguments));
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "beamFrequency": {
                if (arguments.length == 1 && arguments[0] != null) {
                    this.setBeamFrequency(Commons.toInt(arguments[0]));
                }
                return new Integer[]{this.beamFrequency};
            }
            case "transporterName": {
                return this.transporterName(arguments);
            }
            case "enable": {
                return this.enable(arguments);
            }
            case "state": {
                return this.state();
            }
            case "remoteLocation": {
                return this.remoteLocation(arguments);
            }
            case "lock": {
                return this.lock(arguments);
            }
            case "energyFactor": {
                return this.energyFactor(arguments);
            }
            case "getLockStrength": {
                return this.getLockStrength();
            }
            case "getEnergyRequired": {
                return this.getEnergyRequired();
            }
            case "energize": {
                return this.energize(arguments);
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public String toString() {
        return String.format("%s '%s' %s Beam %d @ %s (%d %d %d)", this.getClass().getSimpleName(), this.transporterName, this.uuid, this.beamFrequency, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private static class EntityValues {
        int count;
        long mass;

        private EntityValues() {
        }
    }

    private static class FocusValues {
        ArrayList<VectorI> vScanners;
        int countRangeUpgrades;
        double strength;
        double speed;

        private FocusValues() {
        }
    }
}

