/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatAdvancedRepulsionSystems
implements IBlockTransformer {
    private static Class<?> classBlockDFDoor;
    private static Class<?> classBlockMachine;
    private static Class<?> classBlockUpgrades;
    private static Class<?> classBlockBeam;
    private static final byte[] mrotBeam;
    private static final short[] rotFacing;
    private static final byte[] rotOutputFace;

    public static void register() {
        try {
            classBlockDFDoor = Class.forName("mods.immibis.ars.DeFence.BlockDFDoor");
            classBlockBeam = Class.forName("mods.immibis.ars.beams.BlockBeam");
            classBlockMachine = Class.forName("mods.immibis.ars.BlockMachine");
            classBlockUpgrades = Class.forName("mods.immibis.ars.BlockUpgrades");
            WarpDriveConfig.registerBlockTransformer("AdvancedRepulsionSystems", new CompatAdvancedRepulsionSystems());
        }
        catch (ClassNotFoundException | SecurityException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockDFDoor.isInstance(block) || classBlockBeam.isInstance(block) || classBlockMachine.isInstance(block) || classBlockUpgrades.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockBeam.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotBeam[metadata];
                }
                case 2: {
                    return mrotBeam[mrotBeam[metadata]];
                }
                case 3: {
                    return mrotBeam[mrotBeam[mrotBeam[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("facing")) {
            short facing = nbtTileEntity.func_74765_d("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74777_a("facing", rotFacing[facing]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74777_a("facing", rotFacing[rotFacing[facing]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74777_a("facing", rotFacing[rotFacing[rotFacing[facing]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("outputFace")) {
            byte outputFace = nbtTileEntity.func_74771_c("outputFace");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("outputFace", rotOutputFace[outputFace]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("outputFace", rotOutputFace[rotOutputFace[outputFace]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("outputFace", rotOutputFace[rotOutputFace[rotOutputFace[outputFace]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotBeam = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 14, 15};
        rotFacing = new short[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotOutputFace = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

