/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatBuildCraft
implements IBlockTransformer {
    private static Class<?> classTileEntityBuildCraft;
    private static Class<?> classTileEntityGenericPipe;
    private static Class<?> classTileEntityQuarry;
    private static Class<?> classTileEntityFiller;
    private static Class<?> classTileEntityZonePlanner;
    private static final byte[] mrotByte;
    private static final short[] mrotShort;
    private static final Map<String, String> rotPipeNames;

    public static void register() {
        try {
            classTileEntityBuildCraft = Class.forName("buildcraft.core.lib.block.TileBuildCraft");
            classTileEntityGenericPipe = Class.forName("buildcraft.transport.TileGenericPipe");
            classTileEntityQuarry = Class.forName("buildcraft.builders.TileQuarry");
            classTileEntityFiller = Class.forName("buildcraft.builders.TileFiller");
            classTileEntityZonePlanner = Class.forName("buildcraft.robotics.TileZonePlan");
            WarpDriveConfig.registerBlockTransformer("BuildCraft", new CompatBuildCraft());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classTileEntityBuildCraft.isInstance(tileEntity) || classTileEntityGenericPipe.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        if (classTileEntityQuarry.isInstance(tileEntity)) {
            reason.append("Quarry detected on board!");
            return false;
        }
        if (classTileEntityFiller.isInstance(tileEntity)) {
            reason.append("Filler detected on board!");
            return false;
        }
        if (classTileEntityZonePlanner.isInstance(tileEntity)) {
            reason.append("Zone Planner detected on board!");
            return false;
        }
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        String idTileEntity;
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity == null) {
            return metadata;
        }
        switch (idTileEntity = nbtTileEntity.func_74779_i("id")) {
            case "net.minecraft.src.buildcraft.energy.TileEngineWood": 
            case "net.minecraft.src.buildcraft.energy.TileEngineStone": 
            case "net.minecraft.src.buildcraft.energy.TileEngineIron": 
            case "net.minecraft.src.buildcraft.energy.TileEngineCreative": {
                if (nbtTileEntity.func_74764_b("orientation")) {
                    byte facing = nbtTileEntity.func_74771_c("orientation");
                    switch (rotationSteps) {
                        case 1: {
                            nbtTileEntity.func_74774_a("orientation", mrotByte[facing]);
                            return metadata;
                        }
                        case 2: {
                            nbtTileEntity.func_74774_a("orientation", mrotByte[mrotByte[facing]]);
                            return metadata;
                        }
                        case 3: {
                            nbtTileEntity.func_74774_a("orientation", mrotByte[mrotByte[mrotByte[facing]]]);
                            return metadata;
                        }
                    }
                    return metadata;
                }
                return metadata;
            }
            case "net.minecraft.src.buildcraft.factory.Refinery": 
            case "MiningWell": 
            case "net.minecraft.src.buildcraft.commander.TileZonePlan": 
            case "net.minecraft.src.buildcraft.commander.TileRequester": 
            case "net.minecraft.src.buildcraft.factory.TileLaser": 
            case "net.minecraft.src.builders.TileBuilder": 
            case "net.minecraft.src.builders.TileBlueprintLibrary": 
            case "net.minecraft.src.builders.TileTemplate": 
            case "Marker": 
            case "net.minecraft.src.builders.TilePathMarker": {
                switch (rotationSteps) {
                    case 1: {
                        return mrotShort[metadata];
                    }
                    case 2: {
                        return mrotShort[mrotShort[metadata]];
                    }
                    case 3: {
                        return mrotShort[mrotShort[mrotShort[metadata]]];
                    }
                }
                return metadata;
            }
            case "net.minecraft.src.builders.TileConstructionMarker": {
                byte directionMarker = nbtTileEntity.func_74771_c("direction");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("direction", mrotByte[directionMarker]);
                        break;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("direction", mrotByte[mrotByte[directionMarker]]);
                        break;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("direction", mrotByte[mrotByte[mrotByte[directionMarker]]]);
                        break;
                    }
                }
                switch (rotationSteps) {
                    case 1: {
                        return mrotShort[metadata];
                    }
                    case 2: {
                        return mrotShort[mrotShort[metadata]];
                    }
                    case 3: {
                        return mrotShort[mrotShort[mrotShort[metadata]]];
                    }
                }
                return metadata;
            }
            case "net.minecraft.src.buildcraft.transport.GenericPipe": {
                Object[] objectKeys;
                NBTTagCompound tagsNew = new NBTTagCompound();
                block56: for (Object objectKey : objectKeys = nbtTileEntity.func_150296_c().toArray()) {
                    int direction;
                    String keyOld;
                    String keyNew;
                    if (!(objectKey instanceof String) || (keyNew = rotPipeNames.get(keyOld = (String)objectKey)) == null) continue;
                    NBTBase nbtBase = nbtTileEntity.func_74781_a(keyOld);
                    tagsNew.func_74782_a(keyNew, nbtBase);
                    nbtTileEntity.func_82580_o(keyOld);
                    if (!(nbtBase instanceof NBTTagCompound) || (direction = ((NBTTagCompound)nbtBase).func_74762_e("direction")) == 0) continue;
                    switch (rotationSteps) {
                        case 1: {
                            ((NBTTagCompound)nbtBase).func_74768_a("direction", (int)mrotByte[direction]);
                            continue block56;
                        }
                        case 2: {
                            ((NBTTagCompound)nbtBase).func_74768_a("direction", (int)mrotByte[mrotByte[direction]]);
                            continue block56;
                        }
                        case 3: {
                            ((NBTTagCompound)nbtBase).func_74768_a("direction", (int)mrotByte[mrotByte[mrotByte[direction]]]);
                            continue block56;
                        }
                    }
                }
                Set keysNew = tagsNew.func_150296_c();
                for (String keyNew : keysNew) {
                    nbtTileEntity.func_74782_a(keyNew, tagsNew.func_74781_a(keyNew));
                }
                switch (rotationSteps) {
                    case 1: {
                        return mrotShort[metadata];
                    }
                    case 2: {
                        return mrotShort[mrotShort[metadata]];
                    }
                    case 3: {
                        return mrotShort[mrotShort[mrotShort[metadata]]];
                    }
                }
                return metadata;
            }
            case "net.minecraft.src.buildcraft.factory.TilePump": {
                nbtTileEntity.func_74768_a("aimY", 0);
                nbtTileEntity.func_74776_a("tubeY", Float.NaN);
                return metadata;
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotByte = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotShort = new short[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("redstoneInputSide[0]", "redstoneInputSide[0]");
        map.put("redstoneInputSide[1]", "redstoneInputSide[1]");
        map.put("redstoneInputSide[2]", "redstoneInputSide[5]");
        map.put("redstoneInputSide[3]", "redstoneInputSide[4]");
        map.put("redstoneInputSide[4]", "redstoneInputSide[2]");
        map.put("redstoneInputSide[5]", "redstoneInputSide[3]");
        map.put("pluggable[0]", "pluggable[0]");
        map.put("pluggable[1]", "pluggable[1]");
        map.put("pluggable[2]", "pluggable[5]");
        map.put("pluggable[3]", "pluggable[4]");
        map.put("pluggable[4]", "pluggable[2]");
        map.put("pluggable[5]", "pluggable[3]");
        map.put("Gate[0]", "Gate[0]");
        map.put("Gate[1]", "Gate[1]");
        map.put("Gate[2]", "Gate[5]");
        map.put("Gate[3]", "Gate[4]");
        map.put("Gate[4]", "Gate[2]");
        map.put("Gate[5]", "Gate[3]");
        rotPipeNames = Collections.unmodifiableMap(map);
    }
}

