/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatForgeMultipart
implements IBlockTransformer {
    public static Method methodMultipartHelper_createTileFromNBT = null;
    public static Method methodMultipartHelper_sendDescPacket = null;
    public static Method methodTileMultipart_onChunkLoad = null;
    private static Class<?> classBlockMultipart;
    private static final byte[] rotMicroblockCorner;
    private static final byte[] rotMicroblockFace;
    private static final byte[] rotMicroblockEdge;
    private static final byte[] rotMicroblockPost;
    private static final byte[] rotWRCBEstate;

    public static boolean register() {
        try {
            Class<?> forgeMultipart_helper = Class.forName("codechicken.multipart.MultipartHelper");
            methodMultipartHelper_createTileFromNBT = forgeMultipart_helper.getDeclaredMethod("createTileFromNBT", World.class, NBTTagCompound.class);
            methodMultipartHelper_sendDescPacket = forgeMultipart_helper.getDeclaredMethod("sendDescPacket", World.class, TileEntity.class);
            Class<?> forgeMultipart_tileMultipart = Class.forName("codechicken.multipart.TileMultipart");
            methodTileMultipart_onChunkLoad = forgeMultipart_tileMultipart.getDeclaredMethod("onChunkLoad", new Class[0]);
            classBlockMultipart = Class.forName("codechicken.multipart.BlockMultipart");
            WarpDriveConfig.registerBlockTransformer("ForgeMultipart", new CompatForgeMultipart());
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockMultipart.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    private NBTTagCompound rotate_part(byte rotationSteps, NBTTagCompound nbtPart) {
        NBTTagCompound nbtNewPart = (NBTTagCompound)nbtPart.func_74737_b();
        if (!nbtNewPart.func_74764_b("id")) {
            WarpDrive.logger.error("Ignoring ForgeMultipart with missing id: " + nbtPart);
        } else {
            String id = nbtPart.func_74779_i("id");
            String propertyName = null;
            int mask = -1;
            byte[] rot = null;
            switch (id) {
                case "mcr_cnr": {
                    propertyName = "shape";
                    mask = 15;
                    rot = rotMicroblockCorner;
                    break;
                }
                case "mcr_face": 
                case "mcr_hllw": {
                    propertyName = "shape";
                    mask = 15;
                    rot = rotMicroblockFace;
                    break;
                }
                case "mcr_edge": {
                    propertyName = "shape";
                    mask = 15;
                    rot = rotMicroblockEdge;
                    break;
                }
                case "mcr_post": {
                    propertyName = "shape";
                    mask = 15;
                    rot = rotMicroblockPost;
                    break;
                }
                case "wrcbe-recv": 
                case "wrcbe-tran": 
                case "wrcbe-jamm": {
                    propertyName = "state";
                    mask = 31;
                    rot = rotWRCBEstate;
                    break;
                }
                default: {
                    WarpDrive.logger.error("Ignoring part of ForgeMultipart with unknown id: " + nbtPart);
                }
            }
            if (propertyName != null && rot != null && nbtPart.func_74764_b(propertyName)) {
                byte value = nbtPart.func_74771_c(propertyName);
                byte masked = (byte)(value & mask);
                byte notmasked = (byte)(value - masked);
                switch (rotationSteps) {
                    case 1: {
                        nbtNewPart.func_74774_a(propertyName, (byte)(notmasked | rot[masked]));
                        break;
                    }
                    case 2: {
                        nbtNewPart.func_74774_a(propertyName, (byte)(notmasked | rot[rot[masked]]));
                        break;
                    }
                    case 3: {
                        nbtNewPart.func_74774_a(propertyName, (byte)(notmasked | rot[rot[rot[masked]]]));
                        break;
                    }
                }
            }
        }
        return nbtNewPart;
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("parts")) {
            NBTTagList nbtParts = nbtTileEntity.func_150295_c("parts", 10);
            NBTTagList nbtNewParts = new NBTTagList();
            for (int index = 0; index < nbtParts.func_74745_c(); ++index) {
                NBTTagCompound nbtPart = nbtParts.func_150305_b(index);
                NBTTagCompound nbtNewPart = this.rotate_part(rotationSteps, nbtPart);
                nbtNewParts.func_74742_a((NBTBase)nbtNewPart);
            }
            nbtTileEntity.func_74782_a("parts", (NBTBase)nbtNewParts);
        } else {
            WarpDrive.logger.error("Ignoring ForgeMultipart with no 'parts': " + nbtTileEntity);
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotMicroblockCorner = new byte[]{4, 5, 0, 1, 6, 7, 2, 3, 8, 9, 10, 11, 12, 13, 14, 15};
        rotMicroblockFace = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotMicroblockEdge = new byte[]{2, 0, 3, 1, 8, 10, 9, 11, 5, 7, 4, 6, 12, 13, 14, 15};
        rotMicroblockPost = new byte[]{0, 2, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotWRCBEstate = new byte[]{1, 2, 3, 0, 7, 4, 5, 6, 20, 21, 22, 23, 16, 17, 18, 19, 8, 9, 10, 11, 12, 13, 14, 15, 24, 25, 26, 27, 28, 29, 30, 31};
    }
}

