/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CompatIndustrialCraft2
implements IBlockTransformer {
    private static Class<?> classIC2tileEntity;
    private static final short[] mrotFacing;

    public static void register() {
        try {
            classIC2tileEntity = Class.forName("ic2.core.block.TileEntityBlock");
            WarpDriveConfig.registerBlockTransformer("IC2", new CompatIndustrialCraft2());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classIC2tileEntity.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        int targetZ;
        int targetY;
        int targetX;
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity.func_74767_n("targetSet") && transformation.isInside(targetX = nbtTileEntity.func_74762_e("targetX"), targetY = nbtTileEntity.func_74762_e("targetY"), targetZ = nbtTileEntity.func_74762_e("targetZ"))) {
            ChunkCoordinates chunkCoordinates = transformation.apply(targetX, targetY, targetZ);
            nbtTileEntity.func_74768_a("targetX", chunkCoordinates.field_71574_a);
            nbtTileEntity.func_74768_a("targetY", chunkCoordinates.field_71572_b);
            nbtTileEntity.func_74768_a("targetZ", chunkCoordinates.field_71573_c);
        }
        if (rotationSteps == 0 || !nbtTileEntity.func_74764_b("facing")) {
            return metadata;
        }
        short facing = nbtTileEntity.func_74765_d("facing");
        switch (rotationSteps) {
            case 1: {
                nbtTileEntity.func_74777_a("facing", mrotFacing[facing]);
                return metadata;
            }
            case 2: {
                nbtTileEntity.func_74777_a("facing", mrotFacing[mrotFacing[facing]]);
                return metadata;
            }
            case 3: {
                nbtTileEntity.func_74777_a("facing", mrotFacing[mrotFacing[mrotFacing[facing]]]);
                return metadata;
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotFacing = new short[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

