/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatMekanism
implements IBlockTransformer {
    private static Class<?> tileEntityBasicBlock;
    private static final int[] rotFacing;
    private static final Map<String, String> rotConAttachmentNames;

    public static void register() {
        try {
            tileEntityBasicBlock = Class.forName("mekanism.common.tile.TileEntityBasicBlock");
            WarpDriveConfig.registerBlockTransformer("Mekanism", new CompatMekanism());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return tileEntityBasicBlock.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("facing")) {
            int facing = nbtTileEntity.func_74762_e("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[rotFacing[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[rotFacing[rotFacing[facing]]]);
                    break;
                }
            }
        }
        HashMap<String, NBTBase> mapRotated = new HashMap<String, NBTBase>(9);
        block10: for (String string : rotConAttachmentNames.keySet()) {
            if (!nbtTileEntity.func_74764_b(string)) continue;
            NBTBase nbtBase = nbtTileEntity.func_74781_a(string);
            nbtTileEntity.func_82580_o(string);
            switch (rotationSteps) {
                case 1: {
                    mapRotated.put(rotConAttachmentNames.get(string), nbtBase);
                    continue block10;
                }
                case 2: {
                    mapRotated.put(rotConAttachmentNames.get(rotConAttachmentNames.get(string)), nbtBase);
                    continue block10;
                }
                case 3: {
                    mapRotated.put(rotConAttachmentNames.get(rotConAttachmentNames.get(rotConAttachmentNames.get(string))), nbtBase);
                    continue block10;
                }
            }
            mapRotated.put(string, nbtBase);
        }
        for (Map.Entry entry : mapRotated.entrySet()) {
            nbtTileEntity.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3};
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("conTypes2", "conTypes5");
        map.put("conTypes5", "conTypes3");
        map.put("conTypes3", "conTypes4");
        map.put("conTypes4", "conTypes2");
        map.put("attachment2", "attachment5");
        map.put("attachment5", "attachment3");
        map.put("attachment3", "attachment4");
        map.put("attachment4", "attachment2");
        rotConAttachmentNames = Collections.unmodifiableMap(map);
    }
}

