/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatMetallurgy
implements IBlockTransformer {
    private static Class<?> classBlockMetallurgyMachine;
    private static final int[] mrot;

    public static void register() {
        try {
            classBlockMetallurgyMachine = Class.forName("com.teammetallurgy.metallurgy.machines.BlockMetallurgy");
            WarpDriveConfig.registerBlockTransformer("Metallurgy", new CompatMetallurgy());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockMetallurgyMachine.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockMetallurgyMachine.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrot[metadata];
                }
                case 2: {
                    return mrot[mrot[metadata]];
                }
                case 3: {
                    return mrot[mrot[mrot[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrot = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

