/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CompatSGCraft
implements IBlockTransformer {
    private static Class<?> classBaseTileEntity;
    private static Class<?> classDHDBlock;
    private static Class<?> classSGBaseBlock;
    private static Class<?> classSGBaseTE;
    private static Method methodSGBaseTE_sgStateDescription;
    private static final byte[] mrotDHD;

    public static void register() {
        try {
            classBaseTileEntity = Class.forName("gcewing.sg.BaseTileEntity");
            classDHDBlock = Class.forName("gcewing.sg.DHDBlock");
            classSGBaseBlock = Class.forName("gcewing.sg.SGBaseBlock");
            classSGBaseTE = Class.forName("gcewing.sg.SGBaseTE");
            methodSGBaseTE_sgStateDescription = classSGBaseTE.getMethod("sgStateDescription", new Class[0]);
            WarpDriveConfig.registerBlockTransformer("SGCraft", new CompatSGCraft());
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBaseTileEntity.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        if (classSGBaseTE.isInstance(tileEntity)) {
            try {
                Object object = methodSGBaseTE_sgStateDescription.invoke((Object)tileEntity, new Object[0]);
                String state = (String)object;
                if (!state.equalsIgnoreCase("Idle")) {
                    reason.append(String.format("Stargate is active (%s)!", state));
                    return false;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        ChunkCoordinates targetLink;
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity.func_74764_b("isLinkedToStargate") && nbtTileEntity.func_74767_n("isLinkedToStargate") && nbtTileEntity.func_74764_b("linkedX") && nbtTileEntity.func_74764_b("linkedY") && nbtTileEntity.func_74764_b("linkedZ")) {
            targetLink = transformation.apply(nbtTileEntity.func_74762_e("linkedX"), nbtTileEntity.func_74762_e("linkedY"), nbtTileEntity.func_74762_e("linkedZ"));
            nbtTileEntity.func_74768_a("linkedX", targetLink.field_71574_a);
            nbtTileEntity.func_74768_a("linkedY", targetLink.field_71572_b);
            nbtTileEntity.func_74768_a("linkedZ", targetLink.field_71573_c);
        }
        if (nbtTileEntity.func_74764_b("isMerged") && nbtTileEntity.func_74767_n("isMerged") && nbtTileEntity.func_74764_b("baseX") && nbtTileEntity.func_74764_b("baseY") && nbtTileEntity.func_74764_b("baseZ")) {
            targetLink = transformation.apply(nbtTileEntity.func_74762_e("baseX"), nbtTileEntity.func_74762_e("baseY"), nbtTileEntity.func_74762_e("baseZ"));
            nbtTileEntity.func_74768_a("baseX", targetLink.field_71574_a);
            nbtTileEntity.func_74768_a("baseY", targetLink.field_71572_b);
            nbtTileEntity.func_74768_a("baseZ", targetLink.field_71573_c);
        }
        if (classDHDBlock.isInstance(block) || classSGBaseBlock.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotDHD[metadata];
                }
                case 2: {
                    return mrotDHD[mrotDHD[metadata]];
                }
                case 3: {
                    return mrotDHD[mrotDHD[mrotDHD[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotDHD = new byte[]{3, 0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

