/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IXmlRepresentableUnit;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.data.JumpBlock;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.w3c.dom.Element;

public class Filler
implements IXmlRepresentableUnit {
    public static final Filler DEFAULT = new Filler();
    private String name;
    public Block block;
    public int metadata;
    public NBTTagCompound tagCompound = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        if (!element.hasAttribute("block")) {
            throw new InvalidXmlException("Filler " + element + " is missing a block attribute!");
        }
        String nameBlock = element.getAttribute("block");
        this.block = Block.func_149684_b((String)nameBlock);
        if (this.block == null) {
            WarpDrive.logger.warn("Skipping missing block " + nameBlock);
            return false;
        }
        this.metadata = 0;
        String stringMetadata = element.getAttribute("metadata");
        if (!stringMetadata.isEmpty()) {
            try {
                this.metadata = Integer.parseInt(stringMetadata);
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Invalid metadata for block " + nameBlock);
            }
        }
        this.tagCompound = null;
        String stringNBT = element.getAttribute("nbt");
        if (!stringNBT.isEmpty()) {
            try {
                this.tagCompound = (NBTTagCompound)JsonToNBT.func_150315_a((String)stringNBT);
            }
            catch (NBTException exception) {
                throw new InvalidXmlException("Invalid nbt for block " + nameBlock);
            }
        }
        this.name = nameBlock + "@" + this.metadata + "{" + this.tagCompound + "}";
        return true;
    }

    public void setBlock(World world, int x, int y, int z) {
        JumpBlock.setBlockNoLight(world, x, y, z, this.block, this.metadata, 2);
        if (this.tagCompound != null) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity == null) {
                WarpDrive.logger.error("No TileEntity found for Filler %s at (%d %d %d)", new Object[]{this.getName(), x, y, z});
                return;
            }
            NBTTagCompound nbtTagCompoundTileEntity = new NBTTagCompound();
            tileEntity.func_145841_b(nbtTagCompoundTileEntity);
            for (Object key : this.tagCompound.func_150296_c()) {
                if (!(key instanceof String)) continue;
                nbtTagCompoundTileEntity.func_74782_a((String)key, this.tagCompound.func_74781_a((String)key));
            }
            tileEntity.onChunkUnload();
            tileEntity.func_145839_a(nbtTagCompoundTileEntity);
            tileEntity.func_145829_t();
            tileEntity.func_70296_d();
            JumpBlock.refreshBlockStateOnClient(world, x, y, z);
        }
    }

    @Override
    public IXmlRepresentableUnit constructor() {
        return new Filler();
    }

    public boolean equals(Object object) {
        return !(!(object instanceof Filler) || this.block != null && !this.block.equals(((Filler)object).block) || this.metadata != ((Filler)object).metadata || this.tagCompound != null && !this.tagCompound.equals((Object)((Filler)object).tagCompound));
    }

    public String toString() {
        return "Filler(" + this.block.func_149739_a() + "@" + this.metadata + ")";
    }

    public int hashCode() {
        return Block.func_149682_b((Block)this.block) * 16 + this.metadata + (this.tagCompound == null ? 0 : this.tagCompound.hashCode() * 4096 * 16);
    }

    static {
        Filler.DEFAULT.name = "-default-";
        Filler.DEFAULT.block = Blocks.field_150350_a;
        Filler.DEFAULT.metadata = 0;
        Filler.DEFAULT.tagCompound = null;
    }
}

