/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.config.structures.AbstractStructure;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class AbstractStructureInstance
extends WorldGenerator {
    protected AbstractStructure structure;
    protected HashMap<String, Double> variables = new HashMap();

    public AbstractStructureInstance(AbstractStructure structure, Random random) {
        this.structure = structure;
        for (Map.Entry<String, String> entry : structure.variables.entrySet()) {
            double value;
            String stringValue = entry.getValue();
            try {
                if (stringValue.contains(",")) {
                    String[] values = stringValue.split(",");
                    stringValue = values[random.nextInt(values.length)];
                }
                value = Double.parseDouble(entry.getValue());
            }
            catch (NumberFormatException exception) {
                throw new RuntimeException("Invalid expression '" + entry.getValue() + "'" + (stringValue.equalsIgnoreCase(entry.getValue()) ? "" : " in '" + entry.getValue() + "'") + " for variable " + entry.getKey() + " in deployable structure " + structure.name + ": a numeric value is expected. Check the related XML configuration file...");
            }
            this.variables.put(entry.getKey(), value);
        }
    }

    protected String evaluate(String valueOrExpression) {
        if (!valueOrExpression.contains("%")) {
            return valueOrExpression;
        }
        String result = valueOrExpression;
        for (Map.Entry<String, Double> variable : this.variables.entrySet()) {
            result = result.replaceAll(variable.getKey(), "" + variable.getValue());
        }
        return result;
    }

    public AbstractStructureInstance(NBTTagCompound tagCompound) {
    }

    public void WriteToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("wd_structureGroup", this.structure.group);
        tagCompound.func_74778_a("wd_structureName", this.structure.name);
        NBTTagCompound tagVariables = new NBTTagCompound();
        for (Map.Entry<String, Double> entry : this.variables.entrySet()) {
            tagVariables.func_74780_a(entry.getKey(), entry.getValue().doubleValue());
        }
        tagCompound.func_74782_a("wd_variables", (NBTBase)tagVariables);
    }
}

