/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IXmlRepresentable;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.MetaOrbInstance;
import cr0s.warpdrive.config.structures.Orb;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import org.w3c.dom.Element;

public class MetaOrb
extends Orb {
    protected MetaShell metaShell;

    public MetaOrb(String group, String name) {
        super(group, name);
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        super.loadFromXmlElement(element);
        List<Element> listMetaShells = XmlFileManager.getChildrenElementByTagName(element, "metaShell");
        if (listMetaShells.size() > 1) {
            throw new InvalidXmlException("Too many metaShell defined in structure " + this.getFullName() + ". Maximum is 1.");
        }
        if (listMetaShells.size() == 1) {
            this.metaShell = new MetaShell(this.getFullName());
            this.metaShell.loadFromXmlElement(listMetaShells.get(0));
        }
        return true;
    }

    @Override
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        return this.instantiate(random).func_76484_a(world, random, x, y, z);
    }

    @Override
    public AbstractStructureInstance instantiate(Random random) {
        return new MetaOrbInstance(this, random);
    }

    public class MetaShell
    implements IXmlRepresentable {
        private final String parentFullName;
        protected Block block;
        protected int metadata;
        protected int minCount;
        protected int maxCount;
        protected double minRadius;
        protected double relativeRadius;

        public MetaShell(String parentFullName) {
            this.parentFullName = parentFullName;
        }

        @Override
        public String getName() {
            return "metashell";
        }

        @Override
        public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
            String stringValue;
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.info("  + found metashell");
            }
            if (!(stringValue = element.getAttribute("block")).isEmpty()) {
                this.block = Block.func_149684_b((String)stringValue);
                if (this.block == null) {
                    WarpDrive.logger.warn("Skipping missing metashell core block " + stringValue + " in " + this.parentFullName);
                } else {
                    stringValue = element.getAttribute("metadata");
                    if (stringValue.isEmpty()) {
                        this.metadata = 0;
                    } else {
                        try {
                            this.metadata = Integer.parseInt(stringValue);
                        }
                        catch (NumberFormatException exception) {
                            throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid metadata " + stringValue + ", expecting an integer");
                        }
                    }
                    if (this.metadata < 0 || this.metadata > 15) {
                        throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid metadata " + this.metadata + ", expecting a value between 0 and 15 included");
                    }
                }
            }
            try {
                this.minCount = Integer.parseInt(element.getAttribute("minCount"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid minCount " + element.getAttribute("minCount") + ", expecting an integer");
            }
            if (this.minCount < 1) {
                throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid minCount " + this.minCount + ", expecting greater then 0");
            }
            try {
                this.maxCount = Integer.parseInt(element.getAttribute("maxCount"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid maxCount " + element.getAttribute("maxCount") + ", expecting an integer");
            }
            if (this.maxCount < this.minCount) {
                throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid maxCount " + this.maxCount + ", expecting greater than or equal to minCount " + this.minCount);
            }
            try {
                stringValue = element.getAttribute("minRadius");
                this.minRadius = stringValue.isEmpty() ? 2.0 : Double.parseDouble(element.getAttribute("minRadius"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid minRadius " + element.getAttribute("minRadius") + ", expecting a double");
            }
            if (this.minRadius < 0.0 || this.minRadius > 20.0) {
                throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid minRadius " + this.minRadius + ", expecting a value between 0.0 and 20.0 included");
            }
            try {
                stringValue = element.getAttribute("relativeRadius");
                this.relativeRadius = stringValue.isEmpty() ? 0.5 : Double.parseDouble(element.getAttribute("relativeRadius"));
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid relativeRadius " + element.getAttribute("relativeRadius") + ", expecting a double");
            }
            if (this.relativeRadius < 0.0 || this.relativeRadius > 2.0) {
                throw new InvalidXmlException("Structure " + this.parentFullName + " has an invalid relativeRadius " + this.relativeRadius + ", expecting a value between 0.0 and 2.0 included");
            }
            return true;
        }
    }
}

