/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.structures.MetaOrb;
import cr0s.warpdrive.config.structures.Orb;
import cr0s.warpdrive.config.structures.OrbInstance;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class MetaOrbInstance
extends OrbInstance {
    private static final int CORE_MAX_TRIES = 10;
    protected final MetaShell metaShell;

    public MetaOrbInstance(MetaOrb asteroid, Random random) {
        super(asteroid, random);
        this.metaShell = new MetaShell(asteroid, random);
    }

    @Override
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
            WarpDrive.logger.info("Generating MetaOrb " + this.structure.name + " of " + this.metaShell.count + " cores with radius of " + this.totalThickness);
        }
        LocalProfiler.start("[AsteroidInstance] Generating MetaOrb " + this.structure.name + " of " + this.metaShell.count + " cores with radius of " + this.totalThickness);
        int y2 = Math.min(WarpDriveConfig.SPACE_GENERATOR_Y_MAX_BORDER - this.totalThickness - (int)this.metaShell.radius, Math.max(y, WarpDriveConfig.SPACE_GENERATOR_Y_MIN_BORDER + this.totalThickness + (int)this.metaShell.radius));
        if (((MetaOrb)this.structure).metaShell == null) {
            return super.func_76484_a(world, random, x, y2, z);
        }
        for (VectorI location : this.metaShell.locations) {
            if (this.metaShell.block != null) {
                world.func_147465_d(x + location.x, y2 + location.y, z + location.z, this.metaShell.block, this.metaShell.metadata, 2);
            }
            int maxRadX = this.totalThickness - Math.abs(location.x);
            int maxRadY = this.totalThickness - Math.abs(location.y);
            int maxRadZ = this.totalThickness - Math.abs(location.z);
            int maxLocalRadius = Math.max(maxRadX, Math.max(maxRadY, maxRadZ));
            maxLocalRadius = Math.max(this.minThickness, maxLocalRadius);
            this.addShell(world, new VectorI(x, y2, z).add(location), maxLocalRadius);
        }
        int minY_clamped = Math.max(0, y2 - this.totalThickness);
        int maxY_clamped = Math.min(255, y2 + this.totalThickness);
        for (int xIndex = x - this.totalThickness; xIndex <= x + this.totalThickness; ++xIndex) {
            for (int zIndex = z - this.totalThickness; zIndex <= z + this.totalThickness; ++zIndex) {
                for (int yIndex = minY_clamped; yIndex <= maxY_clamped; ++yIndex) {
                    if (world.func_147439_a(xIndex, yIndex, zIndex) == Blocks.field_150350_a) continue;
                    world.func_147471_g(xIndex, yIndex, zIndex);
                }
            }
        }
        LocalProfiler.stop();
        return false;
    }

    private void addShell(World world, VectorI location, int radius) {
        double sqRadius = radius * radius;
        for (int x = location.x - radius; x <= location.x + radius; ++x) {
            int dX2 = (x - location.x) * (x - location.x);
            for (int y = location.y - radius; y <= location.y + radius; ++y) {
                int dX2Y2 = dX2 + (y - location.y) * (y - location.y);
                for (int z = location.z - radius; z <= location.z + radius; ++z) {
                    int sqRange = dX2Y2 + (location.z - z) * (location.z - z);
                    if (!((double)sqRange <= sqRadius) || !MetaOrbInstance.isReplaceableOreGen(world, x, y, z)) continue;
                    Orb.OrbShell shell = this.getShellForSqRadius(sqRange);
                    Filler filler = (Filler)shell.getRandomUnit(world.field_73012_v);
                    filler.setBlock(world, x, y, z);
                }
            }
        }
    }

    private static boolean isReplaceableOreGen(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isReplaceableOreGen(world, x, y, z, Blocks.field_150350_a);
    }

    public class MetaShell {
        protected final int count;
        protected final double radius;
        protected ArrayList<VectorI> locations;
        protected final Block block;
        protected final int metadata;

        public MetaShell(MetaOrb asteroid, Random random) {
            if (asteroid.metaShell == null) {
                this.count = 1;
                this.radius = 0.0;
                this.block = null;
                this.metadata = 0;
                return;
            }
            this.count = Commons.randomRange(random, asteroid.metaShell.minCount, asteroid.metaShell.maxCount);
            this.radius = Math.max(asteroid.metaShell.minRadius, asteroid.metaShell.relativeRadius * (double)MetaOrbInstance.this.totalThickness);
            this.block = asteroid.metaShell.block;
            this.metadata = asteroid.metaShell.metadata;
            this.locations = new ArrayList();
            double diameter = Math.max(1.0, 2.0 * this.radius);
            double xMin = -this.radius;
            double yMin = -this.radius;
            double zMin = -this.radius;
            for (int index = 0; index < this.count; ++index) {
                boolean found = false;
                for (int step = 0; step < 10 && !found; ++step) {
                    VectorI location = new VectorI((int)Math.round(xMin + diameter * random.nextDouble()), (int)Math.round(yMin + diameter * random.nextDouble()), (int)Math.round(zMin + diameter * random.nextDouble()));
                    if (this.locations.contains(location)) continue;
                    this.locations.add(location);
                    found = true;
                }
            }
        }
    }
}

