/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.Orb;
import cr0s.warpdrive.world.EntitySphereGen;
import cr0s.warpdrive.world.EntityStarCore;
import cr0s.warpdrive.world.WorldGenSmallShip;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class OrbInstance
extends AbstractStructureInstance {
    protected Orb.OrbShell[] orbShells;
    protected int[] orbShellThicknesses;
    protected int totalThickness;
    protected int minThickness;
    protected String schematicName;
    private Orb.OrbShell[] sqRadiusToOrbShell;

    public OrbInstance(Orb orb, Random random) {
        super(orb, random);
        this.orbShells = new Orb.OrbShell[orb.orbShells.length];
        this.orbShellThicknesses = new int[orb.orbShells.length];
        this.totalThickness = 0;
        this.minThickness = 0;
        int orbShellIndexOut = 0;
        for (int orbShellIndexIn = 0; orbShellIndexIn < orb.orbShells.length; ++orbShellIndexIn) {
            int thickness;
            Orb.OrbShell orbShell = orb.orbShells[orbShellIndexIn].instantiate(random);
            if (orbShell == null) continue;
            this.orbShells[orbShellIndexOut] = orbShell;
            this.orbShellThicknesses[orbShellIndexOut] = thickness = Commons.randomRange(random, orbShell.minThickness, orbShell.maxThickness);
            this.totalThickness += thickness;
            this.minThickness += orbShell.minThickness;
            ++orbShellIndexOut;
        }
        this.sqRadiusToOrbShell = new Orb.OrbShell[this.totalThickness * this.totalThickness];
        block1: for (int sqRadius = 0; sqRadius < this.sqRadiusToOrbShell.length; ++sqRadius) {
            int cumulatedRange = 0;
            for (int shellIndex = 0; shellIndex < this.orbShells.length; ++shellIndex) {
                if (sqRadius > (cumulatedRange += this.orbShellThicknesses[shellIndex]) * cumulatedRange) continue;
                this.sqRadiusToOrbShell[sqRadius] = this.orbShells[shellIndex];
                continue block1;
            }
        }
        this.schematicName = orb.schematicName;
    }

    public OrbInstance(NBTTagCompound tagCompound) {
        super(tagCompound);
    }

    @Override
    public void WriteToNBT(NBTTagCompound tagCompound) {
        super.WriteToNBT(tagCompound);
    }

    public int getTotalThickness() {
        return this.totalThickness;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        boolean hasShip = this.schematicName != null && !this.schematicName.isEmpty();
        int y2 = Math.min(WarpDriveConfig.SPACE_GENERATOR_Y_MAX_BORDER - this.totalThickness, Math.max(y, WarpDriveConfig.SPACE_GENERATOR_Y_MIN_BORDER + this.totalThickness));
        if (hasShip) {
            new WorldGenSmallShip(random.nextFloat() < 0.2f, false).func_76484_a(world, random, x, y2, z);
        }
        EntitySphereGen entitySphereGen = new EntitySphereGen(world, x, y2, z, this, !hasShip);
        world.func_72838_d((Entity)entitySphereGen);
        if (((Orb)this.structure).hasStarCore) {
            return world.func_72838_d((Entity)new EntityStarCore(world, x, y2, z, this.totalThickness));
        }
        return true;
    }

    public Orb.OrbShell getShellForSqRadius(double sqRadius) {
        int intSqRadius = (int)Math.round(sqRadius);
        if (intSqRadius < this.sqRadiusToOrbShell.length) {
            return this.sqRadiusToOrbShell[intSqRadius];
        }
        return this.sqRadiusToOrbShell[this.sqRadiusToOrbShell.length - 1];
    }
}

