/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IStringSerializable;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.StructureManager;
import java.util.Random;
import net.minecraft.world.World;

public class StructureGroup
implements IStringSerializable {
    private static final String NONE = "-none-";
    protected String group;
    protected String name;

    public StructureGroup(String group, String name) {
        this.group = group == null || group.isEmpty() ? NONE : group;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.group + ":" + (this.name == null || this.name.isEmpty() ? "*" : this.name);
    }

    public void generate(World world, Random random, int x, int y, int z) {
        if (this.group.equals(NONE)) {
            return;
        }
        AbstractStructure abstractStructure = StructureManager.getStructure(random, this.group, this.name);
        if (abstractStructure == null) {
            WarpDrive.logger.warn(String.format("Celestial object @ %s (%d %d %d) refers to unknown structure %s. Probably a bad configuration. Skipping for now.", world.field_73011_w.func_80007_l(), x, y, z, this.getName()));
            return;
        }
        AbstractStructureInstance abstractStructureInstance = abstractStructure.instantiate(random);
        abstractStructureInstance.func_76484_a(world, random, x, y, z);
    }

    public String getGroup() {
        return this.group;
    }

    public String toString() {
        return String.format("StructureGroup %s", this.getName());
    }
}

