/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.core;

import cr0s.warpdrive.core.FMLLoadingPlugin;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    private static HashMap<String, String> nodeMap = new HashMap();
    public static ConcurrentSkipListMap<String, Integer> countClass = new ConcurrentSkipListMap();
    public static ConcurrentHashMap<String, Long> sizeClass = new ConcurrentHashMap(8192);
    private static final String GRAVITY_MANAGER_CLASS = "cr0s/warpdrive/GravityManager";
    private static final String CLOAK_MANAGER_CLASS = "cr0s/warpdrive/data/CloakManager";
    private boolean debugLog = false;
    private static boolean opcodeToString_firstDump = true;

    public ClassTransformer() {
        nodeMap.put("EntityLivingBase.class", "sv");
        nodeMap.put("moveEntityWithHeading.name", "func_70612_e");
        nodeMap.put("moveEntityWithHeading.desc", "(FF)V");
        nodeMap.put("EntityItem.class", "xk");
        nodeMap.put("onUpdate.name", "func_70071_h_");
        nodeMap.put("onUpdate.desc", "()V");
        nodeMap.put("WorldClient.class", "bjf");
        nodeMap.put("func_147492_c.name", "func_147492_c");
        nodeMap.put("func_147492_c.desc", "(IIILnet/minecraft/block/Block;I)Z");
        nodeMap.put("setBlock.name", "func_147465_d");
        nodeMap.put("Chunk.class", "apx");
        nodeMap.put("fillChunk.name", "func_76607_a");
        nodeMap.put("fillChunk.desc", "([BIIZ)V");
        nodeMap.put("generateHeightMap.name", "func_76590_a");
        nodeMap.put("generateHeightMap.desc", "()V");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (nodeMap == null) {
            FMLLoadingPlugin.logger.info(String.format("Nodemap is null, transformation cancelled for %s", name));
            return bytes;
        }
        if (bytes == null) {
            FMLLoadingPlugin.logger.trace(String.format("bytes is null, transformation cancelled for %s", name));
            return null;
        }
        this.saveClassToFile(false, transformedName, bytes);
        switch (transformedName) {
            case "net.minecraft.entity.EntityLivingBase": {
                bytes = this.transformMinecraftEntityLivingBase(bytes);
                this.saveClassToFile(true, transformedName, bytes);
                break;
            }
            case "net.minecraft.entity.item.EntityItem": {
                bytes = this.transformMinecraftEntityItem(bytes);
                this.saveClassToFile(true, transformedName, bytes);
                break;
            }
            case "com.creativemd.itemphysic.physics.ServerPhysic": {
                bytes = this.transformItemPhysicEntityItem(bytes);
                this.saveClassToFile(true, transformedName, bytes);
                break;
            }
            case "micdoodle8.mods.galacticraft.core.util.WorldUtil": {
                bytes = this.transformGalacticraftWorldUtil(bytes);
                this.saveClassToFile(true, transformedName, bytes);
                break;
            }
            case "net.minecraft.client.multiplayer.WorldClient": {
                bytes = this.transformMinecraftWorldClient(bytes);
                this.saveClassToFile(true, transformedName, bytes);
                break;
            }
            case "net.minecraft.world.chunk.Chunk": {
                bytes = this.transformMinecraftChunk(bytes);
                this.saveClassToFile(true, transformedName, bytes);
            }
        }
        try {
            ClassTransformer.collectClientValidation(transformedName, bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bytes;
    }

    private static void collectClientValidation(String transformedName, byte[] bytes) {
        String[] names = transformedName.split("[.$]");
        String shortName = names[0] + "." + (names.length > 1 ? names[1] : "");
        Integer count = countClass.get(shortName);
        Long size = sizeClass.get(shortName);
        if (count == null) {
            count = 0;
            size = 0L;
        }
        countClass.put(shortName, count + 1);
        sizeClass.put(shortName, size + (long)bytes.length);
    }

    public static String getClientValidation() {
        StringBuilder result = new StringBuilder().append(new Date().toString());
        for (String key : countClass.keySet()) {
            result.append("\n").append(key).append("\t").append(countClass.get(key)).append("\t").append(sizeClass.get(key));
        }
        return result.toString();
    }

    private static String SHA1(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            Formatter formatter = new Formatter();
            for (byte byteValue : md.digest(bytes)) {
                formatter.format("%02x", byteValue);
            }
            return formatter.toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    private byte[] transformMinecraftEntityLivingBase(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean operationCount = true;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("moveEntityWithHeading.name")) && !methodNode.name.equals("moveEntityWithHeading") || !methodNode.desc.equals(nodeMap.get("moveEntityWithHeading.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                AbstractInsnNode abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (!nodeAt.cst.equals(0.08)) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getGravityForEntity", "(Lnet/minecraft/entity/Entity;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != 1) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + 1 + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformMinecraftEntityItem(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 2;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("onUpdate.name")) && !methodNode.name.equals("onUpdate") || !methodNode.desc.equals(nodeMap.get("onUpdate.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                MethodInsnNode overwriteNode;
                VarInsnNode beforeNode;
                AbstractInsnNode abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (nodeAt.cst.equals(0.04f)) {
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    if (this.debugLog) {
                        FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                    }
                    ++injectedCount;
                }
                if (!nodeAt.cst.equals(0.98f)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity2", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != 2) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + 2 + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformItemPhysicEntityItem(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 2;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals("update") || !methodNode.desc.equals("(Lnet/minecraft/entity/item/EntityItem;)V")) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                MethodInsnNode overwriteNode;
                VarInsnNode beforeNode;
                AbstractInsnNode abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (nodeAt.cst.equals(0.04)) {
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    if (this.debugLog) {
                        FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                    }
                    ++injectedCount;
                }
                if (!nodeAt.cst.equals(0.98)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity2", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != 2) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + 2 + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformGalacticraftWorldUtil(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 5;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            MethodInsnNode overwriteNode;
            VarInsnNode beforeNode;
            LdcInsnNode nodeAt;
            AbstractInsnNode abstractNode;
            int instructionIndex;
            if (methodNode.name.equals("getGravityForEntity") && methodNode.desc.equals("(Lnet/minecraft/entity/Entity;)D")) {
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Method found!");
                }
                for (instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                    abstractNode = methodNode.instructions.get(instructionIndex);
                    if (!(abstractNode instanceof LdcInsnNode)) continue;
                    nodeAt = (LdcInsnNode)abstractNode;
                    if (!nodeAt.cst.equals(0.08)) continue;
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getGravityForEntity", "(Lnet/minecraft/entity/Entity;)D", false);
                    methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    if (this.debugLog) {
                        FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                    }
                    ++injectedCount;
                }
            }
            if (!methodNode.name.equals("getItemGravity") || !methodNode.desc.equals("(Lnet/minecraft/entity/item/EntityItem;)D")) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                nodeAt = (LdcInsnNode)abstractNode;
                if (!nodeAt.cst.equals(0.04f)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, GRAVITY_MANAGER_CLASS, "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodNode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount < 5) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + 5 + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformMinecraftWorldClient(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean operationCount = true;
        int injectedCount = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(nodeMap.get("func_147492_c.name")) && !methodNode.name.equals("func_147492_c") || !methodNode.desc.equals(nodeMap.get("func_147492_c.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodNode.instructions.size(); ++instructionIndex) {
                AbstractInsnNode abstractNode = methodNode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)abstractNode;
                if (!nodeAt.name.equals(nodeMap.get("setBlock.name")) && !nodeAt.name.equals("setBlock")) continue;
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLOAK_MANAGER_CLASS, "onBlockChange", "(IIILnet/minecraft/block/Block;II)Z", false);
                methodNode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodNode.name + " " + methodNode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != 1) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + 1 + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformMinecraftChunk(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean operationCount = true;
        int injectedCount = 0;
        for (MethodNode methodnode : classNode.methods) {
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("- Method " + methodnode.name + " " + methodnode.desc);
            }
            if (!methodnode.name.equals(nodeMap.get("fillChunk.name")) && !methodnode.name.equals("fillChunk") || !methodnode.desc.equals(nodeMap.get("fillChunk.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodnode.instructions.size(); ++instructionIndex) {
                AbstractInsnNode abstractNode = methodnode.instructions.get(instructionIndex);
                if (this.debugLog) {
                    ClassTransformer.decompile(abstractNode);
                }
                if (!(abstractNode instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)abstractNode;
                if (!nodeAt.name.equals(nodeMap.get("generateHeightMap.name")) && !nodeAt.name.equals("generateHeightMap") || !nodeAt.desc.equals(nodeMap.get("generateHeightMap.desc"))) continue;
                MethodInsnNode insertMethodNode = new MethodInsnNode(184, CLOAK_MANAGER_CLASS, "onFillChunk", "(Lnet/minecraft/world/chunk/Chunk;)V", false);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)insertMethodNode);
                ++instructionIndex;
                VarInsnNode insertVarNode = new VarInsnNode(25, 0);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)insertVarNode);
                ++instructionIndex;
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != 1) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + 1 + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private void saveClassToFile(boolean isAfter, String nameClass, byte[] bytes) {
        if (this.debugLog) {
            try {
                File fileDirRoot = new File(isAfter ? "asm" : "asm");
                if (!fileDirRoot.exists() && !fileDirRoot.mkdirs()) {
                    FMLLoadingPlugin.logger.info("Unable to create ASM dump folder, skipping...");
                    return;
                }
                File fileDir = new File(isAfter ? "asm/warpdrive.after" : "asm/warpdrive.before");
                if (!fileDir.exists() && !fileDir.mkdirs()) {
                    FMLLoadingPlugin.logger.info("Unable to create ASM dump sub-folder, skipping...");
                    return;
                }
                String nameClass_clean = nameClass.replace("/", "_").replace("\\", "_").replace(" ", "_");
                File fileClass = new File(fileDir, nameClass_clean + ".class");
                FileOutputStream fileOutputStream = new FileOutputStream(fileClass);
                DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                dataOutputStream.write(bytes);
                dataOutputStream.flush();
                dataOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static String opcodeToString(int opcode) {
        Field[] fields;
        for (Field field : fields = Opcodes.class.getFields()) {
            if (field.getType() != Integer.TYPE) continue;
            try {
                if (field.getInt(null) != opcode) continue;
                return field.getName();
            }
            catch (Throwable throwable) {
                if (!opcodeToString_firstDump) continue;
                throwable.printStackTrace();
                opcodeToString_firstDump = false;
            }
        }
        return String.format("0x%x", opcode);
    }

    private static void decompile(AbstractInsnNode abstractNode) {
        String opcode = ClassTransformer.opcodeToString(abstractNode.getOpcode());
        if (abstractNode instanceof VarInsnNode) {
            VarInsnNode node = (VarInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Var", node.var));
        } else if (abstractNode instanceof LabelNode) {
            LabelNode node = (LabelNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Label", node.getLabel()));
        } else if (abstractNode instanceof LineNumberNode) {
            LineNumberNode node = (LineNumberNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Line", node.line));
        } else if (abstractNode instanceof TypeInsnNode) {
            TypeInsnNode node = (TypeInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Typed instruction", node.desc));
        } else if (abstractNode instanceof JumpInsnNode) {
            JumpInsnNode node = (JumpInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Jump", node.label.getLabel()));
        } else if (abstractNode instanceof FrameNode) {
            FrameNode node = (FrameNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %d %s %s", opcode, "Frame", node.type, node.local, node.stack));
        } else if (abstractNode instanceof InsnNode) {
            InsnNode node = (InsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Instruction", node));
        } else if (abstractNode instanceof LdcInsnNode) {
            LdcInsnNode node = (LdcInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s", opcode, "Load", node.cst));
        } else if (abstractNode instanceof FieldInsnNode) {
            FieldInsnNode node = (FieldInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s %s", opcode, "Field", node.owner, node.name, node.desc));
        } else if (abstractNode instanceof MethodInsnNode) {
            MethodInsnNode node = (MethodInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s %s %s", opcode, "Method", node.owner, node.name, node.desc, node.itf));
        } else {
            FMLLoadingPlugin.logger.info(String.format("%20s %-20s %s %s %s", opcode, "Instruction", abstractNode.getOpcode(), abstractNode.getType(), abstractNode));
        }
    }
}

