/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ExceptionChunkNotLoaded;
import cr0s.warpdrive.block.breathing.BlockAirGeneratorTiered;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AirSpreader {
    private static StateAir stateCenter = new StateAir(null);
    private static StateAir[] stateAround = new StateAir[]{new StateAir(null), new StateAir(null), new StateAir(null), new StateAir(null), new StateAir(null), new StateAir(null)};
    private static StateAir stateAirParent = new StateAir(null);

    protected static void execute(World world, int x, int y, int z) throws ExceptionChunkNotLoaded {
        int new_concentration;
        int mid_concentration;
        boolean isGrowth;
        ForgeDirection[] stateAir;
        int concentration;
        stateCenter.refresh(world, x, y, z);
        stateCenter.updateBlockCache(world);
        if (!stateCenter.isAir()) {
            stateCenter.setConcentration(world, (byte)0);
            stateCenter.removeGeneratorAndCascade(world);
            stateCenter.removeVoidAndCascade(world);
            return;
        }
        ForgeDirection[] directions = ForgeDirection.VALID_DIRECTIONS;
        if (stateCenter.isLeakingHorizontally()) {
            directions = Commons.HORIZONTAL_DIRECTIONS;
        } else if (stateCenter.isLeakingVertically()) {
            directions = Commons.VERTICAL_DIRECTIONS;
        }
        short max_pressureGenerator = 0;
        ForgeDirection max_directionGenerator = null;
        short max_pressureVoid = 0;
        ForgeDirection max_directionVoid = null;
        int sum_concentration = concentration = AirSpreader.stateCenter.concentration;
        int max_concentration = concentration;
        int min_concentration = concentration;
        int air_count = 1;
        int empty_count = 0;
        for (ForgeDirection forgeDirection : directions) {
            stateAir = stateAround[forgeDirection.ordinal()];
            stateAir.refresh(world, x + forgeDirection.offsetX, y + forgeDirection.offsetY, z + forgeDirection.offsetZ);
            if (!stateAir.isAir(forgeDirection)) continue;
            ++air_count;
            if (stateAir.concentration > 0) {
                sum_concentration += stateAir.concentration;
                max_concentration = Math.max(max_concentration, stateAir.concentration);
                min_concentration = Math.min(min_concentration, stateAir.concentration);
            } else {
                ++empty_count;
            }
            if (max_pressureGenerator < stateAir.pressureGenerator && (stateAir.isAirSource() || stateAir.directionGenerator != ForgeDirection.UNKNOWN)) {
                max_pressureGenerator = stateAir.pressureGenerator;
                max_directionGenerator = forgeDirection;
            }
            if (max_pressureVoid >= stateAir.pressureVoid || !stateAir.isVoidSource() && stateAir.directionVoid == ForgeDirection.UNKNOWN) continue;
            max_pressureVoid = stateAir.pressureVoid;
            max_directionVoid = forgeDirection;
        }
        if (!stateCenter.isAirSource()) {
            if (AirSpreader.stateCenter.pressureGenerator < max_pressureGenerator && max_pressureGenerator > 1) {
                stateCenter.setGeneratorAndUpdateVoid(world, (short)(max_pressureGenerator - 1), max_directionGenerator);
            } else if (AirSpreader.stateCenter.pressureGenerator != 0) {
                stateCenter.removeGeneratorAndCascade(world);
                for (ForgeDirection forgeDirection : directions) {
                    stateAir = stateAround[forgeDirection.ordinal()];
                    stateAir.refresh(world, x + forgeDirection.offsetX, y + forgeDirection.offsetY, z + forgeDirection.offsetZ);
                }
            }
        }
        if (!stateCenter.isVoidSource()) {
            if (AirSpreader.stateCenter.pressureVoid < max_pressureVoid && max_pressureVoid > 1) {
                stateCenter.setVoid((short)(max_pressureVoid - 1), max_directionVoid);
            } else if (AirSpreader.stateCenter.pressureVoid != 0) {
                stateCenter.removeVoidAndCascade(world);
                for (ForgeDirection forgeDirection : directions) {
                    stateAir = stateAround[forgeDirection.ordinal()];
                    stateAir.refresh(world, x + forgeDirection.offsetX, y + forgeDirection.offsetY, z + forgeDirection.offsetZ);
                }
            }
        }
        if (sum_concentration == 0) {
            if (AirSpreader.stateCenter.pressureVoid > 0 && AirSpreader.stateCenter.pressureGenerator > 0 && AirSpreader.stateCenter.directionGenerator == AirSpreader.stateCenter.directionVoid.getOpposite() && world.field_73012_v.nextInt(4) == 2) {
                Vector3 v3Origin = new Vector3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                Vector3 v3Direction = new Vector3(AirSpreader.stateCenter.directionVoid).scale(0.5);
                PacketHandler.sendSpawnParticlePacket(world, "cloud", (byte)2, v3Origin, v3Direction, 0.2f + 0.1f * world.field_73012_v.nextFloat(), 0.25f + 0.25f * world.field_73012_v.nextFloat(), 0.6f + 0.3f * world.field_73012_v.nextFloat(), 0.0f, 0.0f, 0.0f, 32);
            }
            return;
        }
        if (empty_count > 0) {
            if (concentration < 4) {
                sum_concentration -= empty_count + (world.field_73012_v.nextBoolean() ? 0 : empty_count);
            } else if (concentration < 8) {
                sum_concentration -= empty_count;
            } else if (concentration < 12) {
                sum_concentration -= air_count;
            }
        }
        if (sum_concentration < 0) {
            sum_concentration = 0;
        }
        boolean bl = isGrowth = AirSpreader.stateCenter.pressureGenerator > 0 && (AirSpreader.stateCenter.pressureVoid == 0 || stateCenter.isAirSource()) && max_concentration - min_concentration > 2;
        if (isGrowth) {
            mid_concentration = (int)Math.ceil((float)sum_concentration / (float)air_count);
            new_concentration = sum_concentration - mid_concentration * (air_count - 1);
            new_concentration = Math.max(Math.max(concentration + 1, max_concentration - 1), new_concentration - 20);
        } else {
            mid_concentration = (int)Math.floor((float)sum_concentration / (float)air_count);
            new_concentration = sum_concentration - mid_concentration * (air_count - 1);
            if (empty_count > 0) {
                new_concentration = Math.max(0, new_concentration - 5);
            }
        }
        if (AirSpreader.stateCenter.pressureVoid > 0) {
            mid_concentration = Math.min(mid_concentration, 160);
            new_concentration = Math.min(new_concentration, 160);
        } else if (AirSpreader.stateCenter.pressureGenerator > 20 && new_concentration > 16) {
            mid_concentration += 2;
            new_concentration += 2;
        }
        if (mid_concentration < 0) {
            mid_concentration = 0;
        } else if (mid_concentration > 31) {
            mid_concentration = 31;
        }
        if (new_concentration < 0) {
            new_concentration = 0;
        } else if (isGrowth && new_concentration > max_concentration) {
            new_concentration = Math.max(0, max_concentration);
        } else if (!isGrowth && new_concentration > max_concentration - 1) {
            new_concentration = Math.max(0, max_concentration - 1);
        }
        if (WarpDrive.isDev) {
            assert (new_concentration >= 0);
            assert (mid_concentration >= 0);
            assert (new_concentration <= 31);
            assert (mid_concentration <= 31);
            if (WarpDriveConfig.LOGGING_BREATHING) {
                StringBuilder debugConcentrations = new StringBuilder();
                stateAir = directions;
                int n = stateAir.length;
                for (int i = 0; i < n; ++i) {
                    ForgeDirection forgeDirection = stateAir[i];
                    debugConcentrations.append(String.format(" %3d", AirSpreader.stateAround[forgeDirection.ordinal()].concentration));
                }
                WarpDrive.logger.info(String.format("Updating air 0x%8x @ %6d %3d %6d %s from %3d near %s total %3d, empty %d/%d -> %3d + %d * %3d", AirSpreader.stateCenter.dataAir, x, y, z, isGrowth ? "growing" : "stable ", concentration, debugConcentrations.toString(), sum_concentration, empty_count, air_count, new_concentration, air_count - 1, mid_concentration));
            }
        }
        if (concentration != new_concentration) {
            if (!stateCenter.isAirSource()) {
                if (AirSpreader.stateCenter.directionGenerator != ForgeDirection.UNKNOWN || concentration > new_concentration) {
                    stateCenter.setConcentration(world, (byte)new_concentration);
                } else if (WarpDriveConfig.LOGGING_BREATHING) {
                    WarpDrive.logger.warn(String.format("AirSpreader trying to increase central concentration without a generator in range at %s", stateCenter));
                }
            } else {
                int metadataGenerator;
                ForgeDirection facingGenerator;
                boolean hasGenerator = false;
                int metadataSource = world.func_72805_g(x, y, z);
                ForgeDirection facingSource = ForgeDirection.getOrientation((int)(metadataSource & 7));
                Block block = world.func_147439_a(x - facingSource.offsetX, y - facingSource.offsetY, z - facingSource.offsetZ);
                if (block instanceof BlockAirGeneratorTiered && (facingGenerator = ForgeDirection.getOrientation((int)((metadataGenerator = world.func_72805_g(x - facingSource.offsetX, y - facingSource.offsetY, z - facingSource.offsetZ)) & 7))) == facingSource) {
                    hasGenerator = true;
                }
                if (!hasGenerator) {
                    if (WarpDriveConfig.LOGGING_BREATHING) {
                        WarpDrive.logger.info(String.format("AirGenerator not found, removing AirSource block at (%d %d %d) -> expecting BlockAirGeneratorTiered, found %s", x, y, z, block));
                    }
                    stateCenter.removeAirSource(world);
                }
            }
        } else if (stateCenter.isAirFlow() && new_concentration == 0) {
            WarpDrive.logger.error(String.format("AirSpreader removing invalid central airFlow of %s", stateCenter));
            stateCenter.setConcentration(world, (byte)new_concentration);
        }
        for (ForgeDirection forgeDirection : directions) {
            StateAir stateAir2 = stateAround[forgeDirection.ordinal()];
            if (!stateAir2.isAirFlow() && (!stateAir2.isAir(forgeDirection) || stateAir2.isAirSource())) continue;
            if (!(stateAir2.concentration == mid_concentration || isGrowth && stateAir2.concentration >= mid_concentration)) {
                stateAir2.setConcentration(world, (byte)mid_concentration);
                continue;
            }
            if (mid_concentration != 0 || stateAir2.concentration == 0) continue;
            if (WarpDriveConfig.LOGGING_BREATHING) {
                WarpDrive.logger.warn(String.format("AirSpreader removing connected airFlow of %s", stateAir2));
            }
            stateAir2.setConcentration(world, (byte)mid_concentration);
        }
    }

    public static void clearCache() {
        stateCenter.clearCache();
        for (StateAir stateAir : stateAround) {
            stateAir.clearCache();
        }
        stateAirParent.clearCache();
    }
}

