/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CameraRegistryItem;
import cr0s.warpdrive.data.EnumCameraType;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class CamerasRegistry {
    private LinkedList<CameraRegistryItem> registry = new LinkedList();

    public CameraRegistryItem getCameraByVideoChannel(World world, int videoChannel) {
        if (world == null) {
            return null;
        }
        Iterator it = this.registry.iterator();
        while (it.hasNext()) {
            CameraRegistryItem cam = (CameraRegistryItem)it.next();
            if (cam.videoChannel != videoChannel || cam.dimensionId != world.field_73011_w.field_76574_g) continue;
            if (CamerasRegistry.isCamAlive(world, cam)) {
                return cam;
            }
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Removing 'dead' camera at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c + " (while searching)");
            }
            it.remove();
        }
        this.printRegistry(world);
        return null;
    }

    private CameraRegistryItem getCamByPosition(World world, ChunkPosition position) {
        for (CameraRegistryItem cam : this.registry) {
            if (cam.position.field_151329_a != position.field_151329_a || cam.position.field_151327_b != position.field_151327_b || cam.position.field_151328_c != position.field_151328_c || cam.dimensionId != world.field_73011_w.field_76574_g) continue;
            return cam;
        }
        return null;
    }

    private static boolean isCamAlive(World world, CameraRegistryItem cam) {
        if (world.field_73011_w.field_76574_g != cam.dimensionId) {
            WarpDrive.logger.error("Inconsistent worldObj with camera " + world.field_73011_w.field_76574_g + " vs " + cam.dimensionId);
            return false;
        }
        if (!world.func_72938_d((int)cam.position.field_151329_a, (int)cam.position.field_151328_c).field_76636_d) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Reporting an 'unloaded' camera in dimension " + cam.dimensionId + " at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
            }
            return false;
        }
        Block block = world.func_147439_a(cam.position.field_151329_a, cam.position.field_151327_b, cam.position.field_151328_c);
        if (block != WarpDrive.blockCamera && block != WarpDrive.blockLaserCamera) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Reporting a 'dead' camera in dimension " + cam.dimensionId + " at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
            }
            return false;
        }
        return true;
    }

    private void removeDeadCams(World world) {
        Iterator it = this.registry.iterator();
        while (it.hasNext()) {
            CameraRegistryItem cam = (CameraRegistryItem)it.next();
            if (CamerasRegistry.isCamAlive(world, cam)) continue;
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Removing 'dead' camera in dimension " + cam.dimensionId + " at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
            }
            it.remove();
        }
    }

    public void removeFromRegistry(World world, ChunkPosition position) {
        CameraRegistryItem cam = this.getCamByPosition(world, position);
        if (cam != null) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Removing camera by request in dimension " + cam.dimensionId + " at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
            }
            this.registry.remove(cam);
        }
    }

    public void updateInRegistry(World world, ChunkPosition position, int videoChannel, EnumCameraType enumCameraType) {
        CameraRegistryItem cam = new CameraRegistryItem(world, position, videoChannel, enumCameraType);
        this.removeDeadCams(world);
        if (CamerasRegistry.isCamAlive(world, cam)) {
            CameraRegistryItem existingCam = this.getCamByPosition(world, cam.position);
            if (existingCam == null) {
                if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                    WarpDrive.logger.info("Adding 'live' camera at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c + " with video channel '" + cam.videoChannel + "'");
                }
                this.registry.add(cam);
            } else if (existingCam.videoChannel != cam.videoChannel) {
                if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                    WarpDrive.logger.info("Updating 'live' camera at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c + " from video channel '" + existingCam.videoChannel + "' to video channel '" + cam.videoChannel + "'");
                }
                existingCam.videoChannel = cam.videoChannel;
            }
        } else if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info("Unable to update 'dead' camera at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
        }
    }

    public void printRegistry(World world) {
        if (world == null) {
            return;
        }
        WarpDrive.logger.info("Cameras registry for dimension " + world.field_73011_w.field_76574_g + ":");
        for (CameraRegistryItem cam : this.registry) {
            WarpDrive.logger.info("- " + cam.videoChannel + " (" + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c + ")");
        }
    }
}

