/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ICelestialObject;
import cr0s.warpdrive.api.IStringSerializable;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.RandomCollection;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.structures.StructureGroup;
import cr0s.warpdrive.data.VectorI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.Element;

public class CelestialObject
implements Cloneable,
IStringSerializable,
ICelestialObject {
    public static final double GRAVITY_NONE = 0.0;
    public static final double GRAVITY_LEGACY_SPACE = -1.0;
    public static final double GRAVITY_LEGACY_HYPERSPACE = -2.0;
    public static final double GRAVITY_NORMAL = 1.0;
    public static final String PROVIDER_AUTO = "auto";
    public static final String PROVIDER_HYPERSPACE = "WarpDriveHyperspace";
    public static final String PROVIDER_SPACE = "WarpDriveSpace";
    public static final String PROVIDER_OTHER = "other";
    public static final String PROVIDER_NONE = "";
    public String id;
    public String parentId;
    public CelestialObject parent;
    private boolean isParentResolved;
    protected int parentCenterX;
    protected int parentCenterZ;
    public int borderRadiusX;
    public int borderRadiusZ;
    private String displayName;
    private String description;
    private NBTTagCompound tagCompound;
    private boolean isVirtual;
    public int dimensionId;
    public int dimensionCenterX;
    public int dimensionCenterZ;
    private double gravity;
    private boolean isBreathable;
    protected String provider;
    private boolean isHyperspace;
    private final RandomCollection<StructureGroup> randomStructures = new RandomCollection();
    public ColorData backgroundColor;
    public float baseStarBrightness;
    public float vanillaStarBrightness;
    public float opacityCelestialObjects;
    public ColorData colorFog;
    public ColorData factorFog;
    public LinkedHashSet<RenderData> setRenderData;

    public CelestialObject(String location, String parentId, Element elementCelestialObject) throws InvalidXmlException {
        this.loadFromXmlElement(location, parentId, elementCelestialObject);
    }

    public CelestialObject(int parDimensionId, int parDimensionCenterX, int parDimensionCenterZ, int parBorderRadiusX, int parBorderRadiusZ, String parParentId, int parParentCenterX, int parParentCenterZ) {
        this.isVirtual = false;
        this.isParentResolved = false;
        this.dimensionId = parDimensionId;
        this.dimensionCenterX = parDimensionCenterX;
        this.dimensionCenterZ = parDimensionCenterZ;
        this.borderRadiusX = parBorderRadiusX;
        this.borderRadiusZ = parBorderRadiusZ;
        this.parentId = parParentId;
        this.parentCenterX = parParentCenterX;
        this.parentCenterZ = parParentCenterZ;
    }

    public CelestialObject(NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    @Override
    public String getName() {
        return this.id;
    }

    protected boolean loadFromXmlElement(String location, String parentElementId, Element elementCelestialObject) throws InvalidXmlException {
        List<Element> listDimensions;
        String stringNBT;
        Element elementName;
        List<Element> listElements;
        Element elementCenter;
        List<Element> listElements2;
        this.id = elementCelestialObject.getAttribute("id");
        if (this.id.isEmpty()) {
            throw new InvalidXmlException(String.format("Celestial object %s is missing an id attribute!", location));
        }
        WarpDrive.logger.info("- found Celestial object " + this.id);
        this.parentId = parentElementId;
        List<Element> listParents = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "parent");
        if (listParents.size() > 1) {
            throw new InvalidXmlException(String.format("Celestial object %s can only have up to one parent element", this.id));
        }
        if (listParents.size() == 1) {
            Element elementParent = listParents.get(0);
            String parentIdRead = elementParent.getAttribute("id");
            if (!parentIdRead.isEmpty()) {
                this.parentId = parentIdRead;
            }
            if ((listElements2 = XmlFileManager.getChildrenElementByTagName(elementParent, "center")).size() != 1) {
                throw new InvalidXmlException(String.format("Celestial object %s parent requires exactly one center element", this.id));
            }
            elementCenter = listElements2.get(0);
            this.parentCenterX = Integer.parseInt(elementCenter.getAttribute("x"));
            this.parentCenterZ = Integer.parseInt(elementCenter.getAttribute("z"));
        }
        if ((listElements = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "size")).size() != 1) {
            throw new InvalidXmlException(String.format("Celestial object %s requires exactly one size element", this.id));
        }
        Element elementSize = listElements.get(0);
        this.borderRadiusX = Integer.parseInt(elementSize.getAttribute("x")) / 2;
        this.borderRadiusZ = Integer.parseInt(elementSize.getAttribute("z")) / 2;
        listElements = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "name");
        if (listElements.size() > 1) {
            throw new InvalidXmlException(String.format("Celestial object %s can only have up to one name element", this.id));
        }
        if (listElements.size() == 1) {
            elementName = listElements.get(0);
            this.displayName = elementName.getTextContent();
        } else {
            this.displayName = this.id;
        }
        listElements = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "description");
        if (listElements.size() > 1) {
            throw new InvalidXmlException(String.format("Celestial object %s can only have up to one description element", this.id));
        }
        if (listElements.size() == 1) {
            elementName = listElements.get(0);
            this.description = elementName.getTextContent();
        } else {
            this.description = PROVIDER_NONE;
        }
        listElements = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "nbt");
        if (listElements.size() > 1) {
            throw new InvalidXmlException(String.format("Celestial object %s can only have up to one nbt element", this.id));
        }
        this.tagCompound = null;
        if (listElements.size() == 1 && !(stringNBT = (elementName = listElements.get(0)).getTextContent()).isEmpty()) {
            try {
                this.tagCompound = (NBTTagCompound)JsonToNBT.func_150315_a((String)stringNBT);
            }
            catch (NBTException exception) {
                throw new InvalidXmlException(String.format("Invalid nbt for Celestial object %s", this.id));
            }
        }
        if ((listDimensions = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "dimension")).size() > 1) {
            throw new InvalidXmlException(String.format("Celestial object %s can only have up to one dimension element", this.id));
        }
        if (listDimensions.size() == 0) {
            this.isVirtual = true;
            this.dimensionId = 0;
            this.gravity = 1.0;
            this.isBreathable = true;
            this.provider = PROVIDER_NONE;
            this.isHyperspace = false;
            this.dimensionCenterX = 0;
            this.dimensionCenterZ = 0;
        } else {
            this.isVirtual = false;
            Element elementDimension = listDimensions.get(0);
            this.dimensionId = Integer.parseInt(elementDimension.getAttribute("id"));
            this.gravity = CelestialObject.parseGravity(elementDimension.getAttribute("gravity"));
            this.isBreathable = Boolean.parseBoolean(elementDimension.getAttribute("isBreathable"));
            this.isHyperspace = Boolean.parseBoolean(elementDimension.getAttribute("isHyperspace"));
            listElements2 = XmlFileManager.getChildrenElementByTagName(elementDimension, "provider");
            if (listElements2.size() > 1) {
                throw new InvalidXmlException(String.format("Celestial object %s dimension can only have up to one provider element", this.id));
            }
            if (listElements2.size() == 1) {
                Element element = listElements2.get(0);
                this.provider = element.getAttribute("type");
            } else {
                this.provider = PROVIDER_AUTO;
            }
            List<Element> listCenters = XmlFileManager.getChildrenElementByTagName(elementDimension, "center");
            if (listCenters.size() != 1) {
                throw new InvalidXmlException(String.format("Celestial object %s dimension requires exactly one center element", this.id));
            }
            elementCenter = listCenters.get(0);
            this.dimensionCenterX = Integer.parseInt(elementCenter.getAttribute("x"));
            this.dimensionCenterZ = Integer.parseInt(elementCenter.getAttribute("z"));
            StructureGroup structureGroup = new StructureGroup(null, null);
            this.randomStructures.add(structureGroup, PROVIDER_NONE, "100");
            List<Element> listGenerates = XmlFileManager.getChildrenElementByTagName(elementDimension, "generate");
            for (int indexElement = 0; indexElement < listGenerates.size(); ++indexElement) {
                Element elementGenerate = listGenerates.get(indexElement);
                String locationGenerate = String.format("Celestial object %s generate %d/%d", this.id, indexElement + 1, listGenerates.size());
                this.parseGenerateElement(locationGenerate, elementGenerate);
            }
        }
        List<Element> listSkyboxes = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "skybox");
        if (listSkyboxes.size() > 1) {
            throw new InvalidXmlException(String.format("Celestial object %s can only have up to one skybox element", this.id));
        }
        if (listSkyboxes.isEmpty()) {
            this.backgroundColor = new ColorData(0.0f, 0.0f, 0.0f);
            this.baseStarBrightness = 0.0f;
            this.vanillaStarBrightness = 1.0f;
            this.opacityCelestialObjects = 1.0f;
            this.colorFog = new ColorData(0.7529412f, 0.84705883f, 1.0f);
            this.factorFog = new ColorData(0.94f, 0.94f, 0.91f);
        } else {
            Element elementSkybox = listSkyboxes.get(0);
            String locationSkybox = String.format("Celestial object %s skybox 1/1", this.id);
            this.backgroundColor = this.getColorData(locationSkybox, elementSkybox, "backgroundColor", 0.0f, 0.0f, 0.0f);
            this.baseStarBrightness = this.getFloat(locationSkybox, elementSkybox, "starBrightnessBase", 0.0f);
            this.vanillaStarBrightness = this.getFloat(locationSkybox, elementSkybox, "starBrightnessVanilla", 1.0f);
            this.opacityCelestialObjects = this.getFloat(locationSkybox, elementSkybox, "celestialObjectOpacity", 1.0f);
            this.colorFog = this.getColorData(locationSkybox, elementSkybox, "fogColor", 0.7529412f, 0.84705883f, 1.0f);
            this.factorFog = this.getColorData(locationSkybox, elementSkybox, "fogFactor", 0.94f, 0.94f, 0.91f);
        }
        List<Element> listRenders = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "render");
        this.setRenderData = new LinkedHashSet(listRenders.size());
        if (!listRenders.isEmpty()) {
            for (int indexElement = 0; indexElement < listRenders.size(); ++indexElement) {
                Element elementRender = listRenders.get(indexElement);
                String locationRender = String.format("Celestial object %s render %d/%d", this.id, indexElement + 1, listRenders.size());
                RenderData renderData = new RenderData(locationRender, elementRender);
                this.setRenderData.add(renderData);
            }
        }
        if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
            WarpDrive.logger.info("  loaded " + this);
        }
        return true;
    }

    private float getFloat(String locationParent, Element elementParent, String tagName, float value) throws InvalidXmlException {
        List<Element> listElements = XmlFileManager.getChildrenElementByTagName(elementParent, tagName);
        if (listElements.size() > 1) {
            throw new InvalidXmlException(String.format("%s can only have up to one %s element", locationParent, tagName));
        }
        if (listElements.isEmpty()) {
            return value;
        }
        Element elementSub = listElements.get(0);
        String valueSub = elementSub.getTextContent();
        return Commons.clamp(0.0f, 1.0f, Float.parseFloat(valueSub));
    }

    private ColorData getColorData(String locationParent, Element elementParent, String tagName, float red, float green, float blue) throws InvalidXmlException {
        List<Element> listElements = XmlFileManager.getChildrenElementByTagName(elementParent, tagName);
        if (listElements.size() > 1) {
            throw new InvalidXmlException(String.format("%s can only have up to one %s element", locationParent, tagName));
        }
        if (listElements.isEmpty()) {
            return new ColorData(red, green, blue);
        }
        Element elementChild = listElements.get(0);
        String locationChild = String.format("%s %s 1/1", locationParent, tagName);
        return new ColorData(locationChild, elementChild);
    }

    private static double parseGravity(String stringGravity) {
        try {
            switch (stringGravity) {
                case "none": {
                    return 0.0;
                }
                case "legacySpace": {
                    return -1.0;
                }
                case "legacyHyperspace": {
                    return -2.0;
                }
                case "normal": {
                    return 1.0;
                }
            }
            double gravity = Double.parseDouble(stringGravity);
            if (gravity < 0.0) {
                throw new RuntimeException();
            }
            return Math.min(gravity, 1.0);
        }
        catch (Exception exception) {
            WarpDrive.logger.error("Invalid gravity value, expecting none, legacySpace, legacyHyperspace, normal or a positive double. Found: " + stringGravity);
            exception.printStackTrace();
            return 1.0;
        }
    }

    private void parseGenerateElement(String location, Element elementGenerate) throws InvalidXmlException {
        String group = elementGenerate.getAttribute("group");
        if (group.isEmpty()) {
            throw new InvalidXmlException(location + " is missing a group attribute!");
        }
        String name = elementGenerate.getAttribute("name");
        if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
            WarpDrive.logger.info("  + found Generate " + group + ":" + name);
        }
        String stringRatio = elementGenerate.getAttribute("ratio");
        String stringWeight = elementGenerate.getAttribute("weight");
        StructureGroup structureGroup = new StructureGroup(group, name);
        this.randomStructures.add(structureGroup, stringRatio, stringWeight);
    }

    protected void resolveParent(CelestialObject celestialObjectParent) {
        this.parent = celestialObjectParent;
        this.isParentResolved = true;
        if (this.parent == null && this.provider.equals(PROVIDER_HYPERSPACE)) {
            this.isHyperspace = true;
        }
    }

    protected void lateUpdate() {
        if (this.provider.equals(PROVIDER_AUTO)) {
            this.provider = this.isSpace() ? PROVIDER_SPACE : PROVIDER_OTHER;
        }
    }

    public CelestialObject clone() {
        return new CelestialObject(this.dimensionId, this.dimensionCenterX, this.dimensionCenterZ, this.borderRadiusX, this.borderRadiusZ, this.parentId, this.parentCenterX, this.parentCenterZ);
    }

    public StructureGroup getRandomStructure(Random random, int x, int z) {
        return this.randomStructures.getRandomEntry(random);
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? PROVIDER_NONE : this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description == null ? PROVIDER_NONE : this.description;
    }

    @Override
    public NBTTagCompound getTag() {
        return this.tagCompound;
    }

    @Override
    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public boolean isHyperspace() {
        return this.isHyperspace;
    }

    @Override
    public boolean isSpace() {
        return !this.isHyperspace() && this.parent != null && this.parent.isHyperspace();
    }

    @Override
    public double getGravity() {
        return this.gravity;
    }

    @Override
    public boolean hasAtmosphere() {
        return this.isBreathable && !this.isHyperspace() && !this.isSpace();
    }

    public VectorI getEntryOffset() {
        return new VectorI(this.dimensionCenterX - this.parentCenterX, 0, this.dimensionCenterZ - this.parentCenterZ);
    }

    @Override
    public AxisAlignedBB getWorldBorderArea() {
        return AxisAlignedBB.func_72330_a((double)(this.dimensionCenterX - this.borderRadiusX), (double)0.0, (double)(this.dimensionCenterZ - this.borderRadiusZ), (double)(this.dimensionCenterX + this.borderRadiusX), (double)255.0, (double)(this.dimensionCenterZ + this.borderRadiusZ));
    }

    @Override
    public AxisAlignedBB getAreaToReachParent() {
        return AxisAlignedBB.func_72330_a((double)(this.dimensionCenterX - this.borderRadiusX), (double)250.0, (double)(this.dimensionCenterZ - this.borderRadiusZ), (double)(this.dimensionCenterX + this.borderRadiusX), (double)255.0, (double)(this.dimensionCenterZ + this.borderRadiusZ));
    }

    @Override
    public AxisAlignedBB getAreaInParent() {
        return AxisAlignedBB.func_72330_a((double)(this.parentCenterX - this.borderRadiusX), (double)0.0, (double)(this.parentCenterZ - this.borderRadiusZ), (double)(this.parentCenterX + this.borderRadiusX), (double)8.0, (double)(this.parentCenterZ + this.borderRadiusZ));
    }

    @Override
    public boolean isInsideBorder(AxisAlignedBB aabb) {
        double rangeX = Math.max(Math.abs(aabb.field_72340_a - (double)this.dimensionCenterX), Math.abs(aabb.field_72336_d - (double)this.dimensionCenterX));
        double rangeZ = Math.max(Math.abs(aabb.field_72339_c - (double)this.dimensionCenterZ), Math.abs(aabb.field_72334_f - (double)this.dimensionCenterZ));
        return rangeX <= (double)this.borderRadiusX && rangeZ <= (double)this.borderRadiusZ;
    }

    @Override
    public boolean isInsideBorder(double x, double z) {
        double rangeX = Math.abs(x - (double)this.dimensionCenterX);
        double rangeZ = Math.abs(z - (double)this.dimensionCenterZ);
        return rangeX <= (double)this.borderRadiusX && rangeZ <= (double)this.borderRadiusZ;
    }

    public double getSquareDistanceOutsideBorder(double x, double z) {
        double rangeX = Math.abs(x - (double)this.dimensionCenterX);
        double rangeZ = Math.abs(z - (double)this.dimensionCenterZ);
        double dX = rangeX - (double)this.borderRadiusX;
        double dZ = rangeZ - (double)this.borderRadiusZ;
        if (rangeX <= (double)this.borderRadiusX && rangeZ <= (double)this.borderRadiusZ) {
            double dMax = Math.max(dX, dZ);
            return -(dMax * dMax);
        }
        if (rangeX > (double)this.borderRadiusX && rangeZ > (double)this.borderRadiusZ) {
            return dX * dX + dZ * dZ;
        }
        double dMax = Math.max(dX, dZ);
        return dMax * dMax;
    }

    public double getSquareDistanceInParent(int dimensionId, double x, double z) {
        if (!this.isParentResolved || this.parent == null || dimensionId != this.parent.dimensionId) {
            return Double.POSITIVE_INFINITY;
        }
        if (Math.abs(x - (double)this.parentCenterX) <= (double)this.borderRadiusX && Math.abs(z - (double)this.parentCenterZ) <= (double)this.borderRadiusZ) {
            return 0.0;
        }
        double dx = Math.max(0.0, Math.abs(x - (double)this.parentCenterX) - (double)this.borderRadiusX);
        double dz = Math.max(0.0, Math.abs(z - (double)this.parentCenterZ) - (double)this.borderRadiusZ);
        return dx * dx + dz * dz;
    }

    @Override
    public boolean isInOrbit(int dimensionId, double x, double z) {
        if (!this.isParentResolved || this.parent == null || dimensionId != this.parent.dimensionId) {
            return false;
        }
        return Math.abs(x - (double)this.parentCenterX) <= (double)this.borderRadiusX && Math.abs(z - (double)this.parentCenterZ) <= (double)this.borderRadiusZ;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.isParentResolved = false;
        this.id = tagCompound.func_74779_i("id");
        this.parentId = tagCompound.func_74779_i("parentId");
        this.parentCenterX = tagCompound.func_74762_e("parentCenterX");
        this.parentCenterZ = tagCompound.func_74762_e("parentCenterZ");
        this.borderRadiusX = tagCompound.func_74762_e("borderRadiusX");
        this.borderRadiusZ = tagCompound.func_74762_e("borderRadiusZ");
        this.displayName = tagCompound.func_74779_i("displayName");
        this.description = tagCompound.func_74779_i("description");
        this.isVirtual = tagCompound.func_74767_n("isVirtual");
        if (this.isVirtual) {
            this.dimensionId = 0;
            this.dimensionCenterX = 0;
            this.dimensionCenterZ = 0;
            this.gravity = 1.0;
            this.isBreathable = true;
            this.isHyperspace = false;
            this.provider = PROVIDER_NONE;
        } else {
            this.dimensionId = tagCompound.func_74762_e("dimensionId");
            this.dimensionCenterX = tagCompound.func_74762_e("dimensionCenterX");
            this.dimensionCenterZ = tagCompound.func_74762_e("dimensionCenterZ");
            this.gravity = tagCompound.func_74769_h("gravity");
            this.isBreathable = tagCompound.func_74767_n("isBreathable");
            this.isHyperspace = tagCompound.func_74767_n("isHyperspace");
            this.provider = tagCompound.func_74779_i("provider");
        }
        this.backgroundColor = new ColorData(tagCompound.func_74775_l("backgroundColor"));
        this.baseStarBrightness = tagCompound.func_74760_g("baseStarBrightness");
        this.vanillaStarBrightness = tagCompound.func_74760_g("vanillaStarBrightness");
        this.opacityCelestialObjects = tagCompound.func_74760_g("opacityCelestialObjects");
        this.colorFog = new ColorData(tagCompound.func_74775_l("colorFog"));
        this.factorFog = new ColorData(tagCompound.func_74775_l("factorFog"));
        NBTTagList tagListRenderData = tagCompound.func_150295_c("renderData", 10);
        int countRender = tagListRenderData.func_74745_c();
        this.setRenderData = new LinkedHashSet(countRender);
        for (int indexRenderData = 0; indexRenderData < countRender; ++indexRenderData) {
            NBTTagCompound tagCompoundRenderData = tagListRenderData.func_150305_b(indexRenderData);
            this.setRenderData.add(new RenderData(tagCompoundRenderData));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("id", this.id);
        tagCompound.func_74778_a("parentId", this.parentId);
        tagCompound.func_74768_a("parentCenterX", this.parentCenterX);
        tagCompound.func_74768_a("parentCenterZ", this.parentCenterZ);
        tagCompound.func_74768_a("borderRadiusX", this.borderRadiusX);
        tagCompound.func_74768_a("borderRadiusZ", this.borderRadiusZ);
        if (this.displayName != null && !this.displayName.isEmpty()) {
            tagCompound.func_74778_a("displayName", this.displayName);
        }
        if (this.description != null && !this.description.isEmpty()) {
            tagCompound.func_74778_a("description", this.description);
        }
        tagCompound.func_74757_a("isVirtual", this.isVirtual);
        if (!this.isVirtual) {
            tagCompound.func_74768_a("dimensionId", this.dimensionId);
            tagCompound.func_74768_a("dimensionCenterX", this.dimensionCenterX);
            tagCompound.func_74768_a("dimensionCenterZ", this.dimensionCenterZ);
            tagCompound.func_74780_a("gravity", this.gravity);
            tagCompound.func_74757_a("isBreathable", this.isBreathable);
            tagCompound.func_74757_a("isHyperspace", this.isHyperspace);
            tagCompound.func_74778_a("provider", this.provider);
        }
        tagCompound.func_74782_a("backgroundColor", (NBTBase)this.backgroundColor.writeToNBT(new NBTTagCompound()));
        tagCompound.func_74776_a("baseStarBrightness", this.baseStarBrightness);
        tagCompound.func_74776_a("vanillaStarBrightness", this.vanillaStarBrightness);
        tagCompound.func_74776_a("opacityCelestialObjects", this.opacityCelestialObjects);
        tagCompound.func_74782_a("colorFog", (NBTBase)this.colorFog.writeToNBT(new NBTTagCompound()));
        tagCompound.func_74782_a("factorFog", (NBTBase)this.factorFog.writeToNBT(new NBTTagCompound()));
        NBTTagList nbtTagListRenderData = new NBTTagList();
        for (RenderData renderData : this.setRenderData) {
            nbtTagListRenderData.func_74742_a((NBTBase)renderData.writeToNBT(new NBTTagCompound()));
        }
        tagCompound.func_74782_a("renderData", (NBTBase)nbtTagListRenderData);
        return tagCompound;
    }

    public int hashCode() {
        return this.dimensionId << 16 + (this.dimensionCenterX >> 10) << 8 + (this.dimensionCenterZ >> 10);
    }

    public boolean equals(Object object) {
        if (object instanceof CelestialObject) {
            CelestialObject celestialObject = (CelestialObject)object;
            return this.dimensionId == celestialObject.dimensionId && this.dimensionCenterX == celestialObject.dimensionCenterX && this.dimensionCenterZ == celestialObject.dimensionCenterZ && this.borderRadiusX == celestialObject.borderRadiusX && this.borderRadiusZ == celestialObject.borderRadiusZ && this.parentId.equals(celestialObject.parentId) && this.parentCenterX == celestialObject.parentCenterX && this.parentCenterZ == celestialObject.parentCenterZ;
        }
        return false;
    }

    public String toString() {
        String stringParent = this.isParentResolved && this.parent != null ? String.format("Parent(%d @ %d %d)", this.parent.dimensionId, this.parentCenterX, this.parentCenterZ) : String.format("Parent(%s @ %d %d)", this.parentId, this.parentCenterX, this.parentCenterZ);
        if (this.isVirtual) {
            return String.format("CelestialObject %s [-Virtual- Border(%d %d) %s]", this.id, 2 * this.borderRadiusX, 2 * this.borderRadiusZ, stringParent);
        }
        return String.format("CelestialObject %s [Dimension %d @ %d %d Border(%d %d) %s provider %s gravity %.3f isBreathable %s]", this.id, this.dimensionId, this.dimensionCenterX, this.dimensionCenterZ, 2 * this.borderRadiusX, 2 * this.borderRadiusZ, stringParent, this.provider, this.gravity, this.isBreathable);
    }

    public class RenderData {
        public float red;
        public float green;
        public float blue;
        public float alpha;
        public String texture;
        public ResourceLocation resourceLocation;
        public double periodU;
        public double periodV;
        public boolean isAdditive;

        RenderData(String location, Element elementRender) throws InvalidXmlException {
            try {
                this.red = Commons.clamp(0.0f, 1.0f, Float.parseFloat(elementRender.getAttribute("red")));
                this.green = Commons.clamp(0.0f, 1.0f, Float.parseFloat(elementRender.getAttribute("green")));
                this.blue = Commons.clamp(0.0f, 1.0f, Float.parseFloat(elementRender.getAttribute("blue")));
                this.alpha = Commons.clamp(0.0f, 1.0f, Float.parseFloat(elementRender.getAttribute("alpha")));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                WarpDrive.logger.error(String.format("Exception while parsing Render element RGBA attributes at %s", location));
                this.red = 0.5f;
                this.green = 0.5f;
                this.blue = 0.5f;
                this.alpha = 0.5f;
            }
            this.texture = elementRender.getAttribute("texture");
            if (this.texture == null || this.texture.isEmpty()) {
                this.texture = null;
                this.resourceLocation = null;
                this.periodU = 1.0;
                this.periodV = 1.0;
                this.isAdditive = false;
            } else {
                this.resourceLocation = new ResourceLocation(this.texture);
                this.periodU = 0.001;
                String stringPeriodU = elementRender.getAttribute("periodU");
                if (!stringPeriodU.isEmpty()) {
                    try {
                        this.periodU = Commons.clampMantisse(0.001, 1000000.0, Double.parseDouble(stringPeriodU));
                    }
                    catch (NumberFormatException exception) {
                        throw new InvalidXmlException(String.format("Invalid periodU attribute '%s' at %s", stringPeriodU, location));
                    }
                }
                this.periodV = 0.001;
                String stringPeriodV = elementRender.getAttribute("periodV");
                if (!stringPeriodV.isEmpty()) {
                    try {
                        this.periodV = Commons.clampMantisse(0.001, 1000000.0, Double.parseDouble(stringPeriodV));
                    }
                    catch (NumberFormatException exception) {
                        throw new InvalidXmlException(String.format("Invalid periodV attribute '%s' at %s", stringPeriodV, location));
                    }
                }
                this.isAdditive = Boolean.parseBoolean(elementRender.getAttribute("additive"));
            }
        }

        RenderData(NBTTagCompound tagCompound) {
            this.readFromNBT(tagCompound);
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            this.red = tagCompound.func_74760_g("red");
            this.green = tagCompound.func_74760_g("green");
            this.blue = tagCompound.func_74760_g("blue");
            this.alpha = tagCompound.func_74760_g("alpha");
            this.texture = tagCompound.func_74779_i("texture");
            if (this.texture == null || this.texture.isEmpty()) {
                this.texture = null;
                this.resourceLocation = null;
                this.periodU = 1.0;
                this.periodV = 1.0;
                this.isAdditive = false;
            } else {
                this.resourceLocation = new ResourceLocation(this.texture);
                this.periodU = tagCompound.func_74769_h("periodU");
                this.periodV = tagCompound.func_74769_h("periodV");
                this.isAdditive = tagCompound.func_74767_n("isAdditive");
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
            tagCompound.func_74776_a("red", this.red);
            tagCompound.func_74776_a("green", this.green);
            tagCompound.func_74776_a("blue", this.blue);
            tagCompound.func_74776_a("alpha", this.alpha);
            if (this.texture != null) {
                tagCompound.func_74778_a("texture", this.texture);
                tagCompound.func_74780_a("periodU", this.periodU);
                tagCompound.func_74780_a("periodV", this.periodV);
                tagCompound.func_74757_a("isAdditive", this.isAdditive);
            }
            return tagCompound;
        }
    }

    public class ColorData {
        public float red;
        public float green;
        public float blue;

        ColorData(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        ColorData(String location, Element elementColor) {
            try {
                this.red = Commons.clamp(0.0f, 1.0f, Float.parseFloat(elementColor.getAttribute("red")));
                this.green = Commons.clamp(0.0f, 1.0f, Float.parseFloat(elementColor.getAttribute("green")));
                this.blue = Commons.clamp(0.0f, 1.0f, Float.parseFloat(elementColor.getAttribute("blue")));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                WarpDrive.logger.error("Exception while parsing Color element at " + location);
                this.red = 0.5f;
                this.green = 0.5f;
                this.blue = 0.5f;
            }
        }

        ColorData(NBTTagCompound tagCompound) {
            this.readFromNBT(tagCompound);
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            this.red = tagCompound.func_74760_g("red");
            this.green = tagCompound.func_74760_g("green");
            this.blue = tagCompound.func_74760_g("blue");
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
            tagCompound.func_74776_a("red", this.red);
            tagCompound.func_74776_a("green", this.green);
            tagCompound.func_74776_a("blue", this.blue);
            return tagCompound;
        }
    }
}

