/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.data.CelestialObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.w3c.dom.Element;

public class CelestialObjectManager
extends XmlFileManager {
    private static final CelestialObjectManager SERVER = new CelestialObjectManager();
    private static final CelestialObjectManager CLIENT = new CelestialObjectManager();
    private HashMap<String, CelestialObject> celestialObjectsById = new HashMap();
    public CelestialObject[] celestialObjects = new CelestialObject[0];

    public static void clearForReload(boolean isRemote) {
        (isRemote ? CelestialObjectManager.CLIENT : CelestialObjectManager.SERVER).celestialObjectsById = new HashMap();
    }

    public static CelestialObject get(boolean isRemote, String id) {
        return (isRemote ? CelestialObjectManager.CLIENT : CelestialObjectManager.SERVER).celestialObjectsById.get(id);
    }

    public static CelestialObject get(World world, int x, int z) {
        if (world == null) {
            return null;
        }
        return (world.field_72995_K ? CLIENT : SERVER).get(world.field_73011_w.field_76574_g, x, z);
    }

    public static CelestialObject get(boolean isRemote, int dimensionId, int x, int z) {
        return (isRemote ? CLIENT : SERVER).get(dimensionId, x, z);
    }

    public static CelestialObject getClosestChild(World world, int x, int z) {
        double closestPlanetDistance = Double.POSITIVE_INFINITY;
        CelestialObject celestialObjectClosest = null;
        if (world != null) {
            for (CelestialObject celestialObject : (world.field_72995_K ? CelestialObjectManager.CLIENT : CelestialObjectManager.SERVER).celestialObjects) {
                if (celestialObject.isHyperspace()) continue;
                double distanceSquared = celestialObject.getSquareDistanceInParent(world.field_73011_w.field_76574_g, x, z);
                if (distanceSquared <= 0.0) {
                    return celestialObject;
                }
                if (!(closestPlanetDistance > distanceSquared)) continue;
                closestPlanetDistance = distanceSquared;
                celestialObjectClosest = celestialObject;
            }
        }
        return celestialObjectClosest;
    }

    public static boolean isInSpace(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        return celestialObject != null && celestialObject.isSpace();
    }

    public static boolean isInHyperspace(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        return celestialObject != null && celestialObject.isHyperspace();
    }

    public static boolean hasAtmosphere(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        return celestialObject == null || celestialObject.hasAtmosphere();
    }

    public static boolean isPlanet(World world, int x, int z) {
        CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
        return celestialObject == null || !celestialObject.isSpace() && !celestialObject.isHyperspace();
    }

    public static void onFMLInitialization() {
        block10: for (CelestialObject celestialObject : CelestialObjectManager.SERVER.celestialObjects) {
            if (celestialObject.isVirtual()) continue;
            switch (celestialObject.provider) {
                case "WarpDriveSpace": {
                    if (celestialObject.isSpace()) {
                        DimensionManager.registerDimension((int)celestialObject.dimensionId, (int)WarpDriveConfig.G_SPACE_PROVIDER_ID);
                        continue block10;
                    }
                    WarpDrive.logger.error(String.format("Only a space dimension can be provided by WarpDriveSpace. Dimension %d is not one of those.", celestialObject.dimensionId));
                    continue block10;
                }
                case "WarpDriveHyperspace": {
                    if (celestialObject.isHyperspace()) {
                        DimensionManager.registerDimension((int)celestialObject.dimensionId, (int)WarpDriveConfig.G_HYPERSPACE_PROVIDER_ID);
                        continue block10;
                    }
                    WarpDrive.logger.error(String.format("Only an hyperspace dimension can be provided by WarpDriveHyperspace. Dimension %d is not one of those.", celestialObject.dimensionId));
                    continue block10;
                }
                case "other": {
                    continue block10;
                }
                default: {
                    WarpDrive.logger.error(String.format("Unknown dimension provider %s for dimension %d, ignoring...", celestialObject.provider, celestialObject.dimensionId));
                }
            }
        }
    }

    public static void load(File dir) {
        SERVER.load(dir, "celestialObjects", "celestialObject");
        SERVER.rebuildAndValidate(false);
    }

    public static void updateInRegistry(CelestialObject celestialObject) {
        SERVER.addOrUpdateInRegistry(celestialObject, true);
        SERVER.rebuildAndValidate(true);
    }

    public static NBTBase writeClientSync(EntityPlayerMP entityPlayerMP, CelestialObject celestialObject) {
        NBTTagList nbtTagList = new NBTTagList();
        if (celestialObject != null) {
            CelestialObject celestialObjectParent = celestialObject;
            while (celestialObjectParent != null) {
                nbtTagList.func_74742_a((NBTBase)celestialObjectParent.writeToNBT(new NBTTagCompound()));
                celestialObjectParent = celestialObjectParent.parent;
            }
            for (CelestialObject celestialObjectChild : CelestialObjectManager.SERVER.celestialObjects) {
                if (!celestialObjectChild.parentId.equals(celestialObject.id)) continue;
                nbtTagList.func_74742_a((NBTBase)celestialObjectChild.writeToNBT(new NBTTagCompound()));
            }
        }
        return nbtTagList;
    }

    @SideOnly(value=Side.CLIENT)
    public static void readClientSync(NBTTagList nbtTagList) {
        CelestialObjectManager.clearForReload(true);
        if (nbtTagList != null && nbtTagList.func_74745_c() > 0) {
            for (int index = 0; index < nbtTagList.func_74745_c(); ++index) {
                CelestialObject celestialObject = new CelestialObject(nbtTagList.func_150305_b(index));
                CLIENT.addOrUpdateInRegistry(celestialObject, false);
            }
        }
        CLIENT.rebuildAndValidate(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static CelestialObject[] getRenderStack() {
        return CelestialObjectManager.CLIENT.celestialObjects;
    }

    private void addOrUpdateInRegistry(CelestialObject celestialObject, boolean isUpdating) {
        CelestialObject celestialObjectExisting = this.celestialObjectsById.get(celestialObject.id);
        if (celestialObjectExisting == null || isUpdating) {
            this.celestialObjectsById.put(celestialObject.id, celestialObject);
        } else {
            WarpDrive.logger.warn(String.format("Celestial object %s is already defined, keeping original definition", celestialObject.id));
        }
    }

    private void rebuildAndValidate(boolean isRemote) {
        int count = this.celestialObjectsById.size();
        this.celestialObjects = new CelestialObject[count];
        int index = 0;
        for (CelestialObject celestialObject : this.celestialObjectsById.values()) {
            this.celestialObjects[index++] = celestialObject;
            celestialObject.resolveParent(this.celestialObjectsById.get(celestialObject.parentId));
        }
        int countErrors = 0;
        int countHyperspace = 0;
        int countSpace = 0;
        for (int indexCelestialObject1 = 0; indexCelestialObject1 < count; ++indexCelestialObject1) {
            CelestialObject celestialObject1 = this.celestialObjects[indexCelestialObject1];
            celestialObject1.lateUpdate();
            if (celestialObject1.isHyperspace()) {
                ++countHyperspace;
            } else if (celestialObject1.isSpace()) {
                ++countSpace;
            }
            if (!celestialObject1.isVirtual()) {
                if (celestialObject1.parent == null || celestialObject1.parent.dimensionId != celestialObject1.dimensionId) {
                    CelestialObject celestialObjectParent = this.get(celestialObject1.parentId);
                    if (celestialObjectParent == null) {
                        if (!isRemote && celestialObject1.parentId != null && !celestialObject1.parentId.isEmpty()) {
                            WarpDrive.logger.error(String.format("CelestiaObjects validation error #%d\nCelestial object %s refers to unknown parent %s", ++countErrors, celestialObject1.id, celestialObject1.parentId));
                        }
                    } else if (celestialObject1.parentCenterX - celestialObject1.borderRadiusX < celestialObjectParent.dimensionCenterX - celestialObjectParent.borderRadiusX || celestialObject1.parentCenterZ - celestialObject1.borderRadiusZ < celestialObjectParent.dimensionCenterZ - celestialObjectParent.borderRadiusZ || celestialObject1.parentCenterX + celestialObject1.borderRadiusX > celestialObjectParent.dimensionCenterX + celestialObjectParent.borderRadiusX || celestialObject1.parentCenterZ + celestialObject1.borderRadiusZ > celestialObjectParent.dimensionCenterZ + celestialObjectParent.borderRadiusZ) {
                        WarpDrive.logger.error(String.format("CelestiaObjects validation error #%d\nCelestial object %s is outside its parent border.\n%s\n%s\n%s's area in parent %s is outside %s's border %s", ++countErrors, celestialObject1.id, celestialObject1, celestialObjectParent, celestialObject1.id, celestialObject1.getAreaInParent(), celestialObjectParent.id, celestialObjectParent.getWorldBorderArea()));
                    }
                }
                if (celestialObject1.dimensionCenterX - celestialObject1.borderRadiusX < -30000000 || celestialObject1.dimensionCenterZ - celestialObject1.borderRadiusZ < -30000000 || celestialObject1.dimensionCenterX + celestialObject1.borderRadiusX >= 30000000 || celestialObject1.dimensionCenterZ + celestialObject1.borderRadiusZ >= 30000000) {
                    WarpDrive.logger.error(String.format("CelestiaObjects validation error #%d\nCelestial object %s is outside the game border +/-30000000.\n%s\n%s border is %s", ++countErrors, celestialObject1.id, celestialObject1, celestialObject1.id, celestialObject1.getWorldBorderArea()));
                }
            }
            for (int indexCelestialObject2 = indexCelestialObject1 + 1; indexCelestialObject2 < count; ++indexCelestialObject2) {
                AxisAlignedBB worldBorderArea2;
                AxisAlignedBB worldBorderArea1;
                AxisAlignedBB areaInParent2;
                AxisAlignedBB areaInParent1;
                CelestialObject celestialObject2 = this.celestialObjects[indexCelestialObject2];
                if (!celestialObject1.isHyperspace() && !celestialObject2.isHyperspace() && celestialObject1.parent != null && celestialObject2.parent != null && celestialObject1.parent.dimensionId == celestialObject2.parent.dimensionId && (areaInParent1 = celestialObject1.getAreaInParent()).func_72326_a(areaInParent2 = celestialObject2.getAreaInParent())) {
                    WarpDrive.logger.error(String.format("CelestiaObjects validation error #%d\nOverlapping parent areas detected in dimension %d between %s and %s\nArea1 %s from %s\nArea2 %s from %s", ++countErrors, celestialObject1.parent.dimensionId, celestialObject1.id, celestialObject2.id, areaInParent1, celestialObject1, areaInParent2, celestialObject2));
                }
                if (celestialObject1.isVirtual() || celestialObject2.isVirtual() || celestialObject1.dimensionId != celestialObject2.dimensionId || !(worldBorderArea1 = celestialObject1.getWorldBorderArea()).func_72326_a(worldBorderArea2 = celestialObject2.getWorldBorderArea())) continue;
                WarpDrive.logger.error(String.format("CelestiaObjects validation error #%d\nOverlapping areas detected in dimension %d between %s and %s\nArea1 %s from %s\nArea2 %s from %s", ++countErrors, celestialObject1.dimensionId, celestialObject1.id, celestialObject2.id, worldBorderArea1, celestialObject1, worldBorderArea2, celestialObject2));
            }
        }
        if (!isRemote && countHyperspace == 0) {
            WarpDrive.logger.error(String.format("CelestiaObjects validation error #%d\nAt least one hyperspace celestial object should be defined!", ++countErrors));
        } else if (!isRemote && countSpace == 0) {
            WarpDrive.logger.error(String.format("CelestiaObjects validation error #%d\nAt least one space celestial object should be defined!", ++countErrors));
        }
        if (countErrors == 1) {
            throw new RuntimeException("Invalid celestial objects definition: update your configuration to fix this validation error, search your logs for 'CelestiaObjects validation error' to get more details.");
        }
        if (countErrors > 0) {
            throw new RuntimeException(String.format("Invalid celestial objects definition: update your configuration to fix those %d validation errors, search your logs for 'CelestiaObjects validation error' to get more details.", countErrors));
        }
    }

    @Override
    protected void parseRootElement(String location, Element elementCelestialObject) throws InvalidXmlException {
        this.parseCelestiaObjectElement(location, elementCelestialObject, "");
    }

    private void parseCelestiaObjectElement(String location, Element elementCelestialObject, String parentId) throws InvalidXmlException {
        CelestialObject celestialObjectRead = new CelestialObject(location, parentId, elementCelestialObject);
        this.addOrUpdateInRegistry(celestialObjectRead, false);
        List<Element> listChildren = XmlFileManager.getChildrenElementByTagName(elementCelestialObject, "celestialObject");
        if (!listChildren.isEmpty()) {
            for (int indexElement = 0; indexElement < listChildren.size(); ++indexElement) {
                Element elementChild = listChildren.get(indexElement);
                String locationChild = String.format("%s Celestial object %s > child %d/%d", location, celestialObjectRead.id, indexElement + 1, listChildren.size());
                this.parseCelestiaObjectElement(locationChild, elementChild, celestialObjectRead.id);
            }
        }
    }

    public CelestialObject get(String id) {
        return this.celestialObjectsById.get(id);
    }

    public CelestialObject get(int dimensionId, int x, int z) {
        double distanceClosest = Double.POSITIVE_INFINITY;
        CelestialObject celestialObjectClosest = null;
        for (CelestialObject celestialObject : this.celestialObjects) {
            if (celestialObject.isVirtual() || dimensionId != celestialObject.dimensionId) continue;
            double distanceSquared = celestialObject.getSquareDistanceOutsideBorder(x, z);
            if (distanceSquared <= 0.0) {
                return celestialObject;
            }
            if (!(distanceClosest > distanceSquared)) continue;
            distanceClosest = distanceSquared;
            celestialObjectClosest = celestialObject;
        }
        return celestialObjectClosest;
    }
}

