/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.api.IStringSerializable;
import java.util.HashMap;
import javax.annotation.Nonnull;

public enum EnumShipCoreState implements IStringSerializable
{
    DISCONNECTED(0, "disconnected"),
    IDLE(1, "idle"),
    SCANNING(2, "scanning"),
    ONLINE(3, "online"),
    WARMING_UP(4, "warming_up"),
    COOLING_DOWN(5, "cooling_down");

    private final int metadata;
    private final String name;
    public static final int length;
    private static final HashMap<Integer, EnumShipCoreState> ID_MAP;

    private EnumShipCoreState(int metadata, String name) {
        this.metadata = metadata;
        this.name = name;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public static EnumShipCoreState get(int id) {
        return ID_MAP.get(id);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    static {
        ID_MAP = new HashMap();
        length = EnumShipCoreState.values().length;
        for (EnumShipCoreState shipCoreState : EnumShipCoreState.values()) {
            ID_MAP.put(shipCoreState.ordinal(), shipCoreState);
        }
    }
}

