/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.api.IStringSerializable;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;

public enum EnumTooltipCondition implements IStringSerializable
{
    NEVER("never"),
    ON_SNEAK("on_sneak"),
    ADVANCED_TOOLTIPS("advanced_tooltips"),
    CREATIVE_ONLY("creative_only"),
    ALWAYS("always");

    public final String name;

    private EnumTooltipCondition(String name) {
        this.name = name;
    }

    public boolean isEnabled(boolean isSneaking, boolean isCreativeMode) {
        switch (this) {
            case NEVER: {
                return false;
            }
            case ON_SNEAK: {
                return isSneaking;
            }
            case ADVANCED_TOOLTIPS: {
                return Minecraft.func_71410_x().field_71474_y.field_82882_x;
            }
            case CREATIVE_ONLY: {
                return isCreativeMode;
            }
            case ALWAYS: {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public static String formatAllValues() {
        StringBuilder result = new StringBuilder();
        for (EnumTooltipCondition tooltipCondition : EnumTooltipCondition.values()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(tooltipCondition);
        }
        return result.toString();
    }
}

