/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class JumpShip {
    public World worldObj;
    public int coreX;
    public int coreY;
    public int coreZ;
    public int dx;
    public int dz;
    public int maxX;
    public int maxZ;
    public int maxY;
    public int minX;
    public int minZ;
    public int minY;
    public JumpBlock[] jumpBlocks;
    public int actualMass;
    public TileEntityShipCore shipCore;
    public List<MovingEntity> entitiesOnShip;

    public static JumpShip createFromFile(String fileName, StringBuilder reason) {
        NBTTagCompound schematic = Commons.readNBTFromFile(WarpDriveConfig.G_SCHEMALOCATION + "/" + fileName + ".schematic");
        if (schematic == null) {
            reason.append(String.format("Schematic not found or unknown error reading it: '%s'.", fileName));
            return null;
        }
        JumpShip jumpShip = new JumpShip();
        if (schematic.func_74764_b("ship")) {
            jumpShip.readFromNBT(schematic.func_74775_l("ship"));
        } else {
            int width = schematic.func_74765_d("Width");
            int height = schematic.func_74765_d("Height");
            int length = schematic.func_74765_d("Length");
            jumpShip.minX = 0;
            jumpShip.maxX = width - 1;
            jumpShip.minY = 0;
            jumpShip.maxY = height - 1;
            jumpShip.minZ = 0;
            jumpShip.maxZ = length - 1;
            jumpShip.coreX = 0;
            jumpShip.coreY = 0;
            jumpShip.coreZ = 0;
            jumpShip.jumpBlocks = new JumpBlock[width * height * length];
            byte[] localBlocks = schematic.func_74770_j("Blocks");
            byte[] localAddBlocks = schematic.func_74764_b("AddBlocks") ? schematic.func_74770_j("AddBlocks") : null;
            byte[] localMetadata = schematic.func_74770_j("Data");
            NBTTagCompound[] tileEntities = new NBTTagCompound[jumpShip.jumpBlocks.length];
            NBTTagList tagListTileEntities = schematic.func_150295_c("TileEntities", 10);
            for (int i = 0; i < tagListTileEntities.func_74745_c(); ++i) {
                NBTTagCompound tagTileEntity = tagListTileEntities.func_150305_b(i);
                int teX = tagTileEntity.func_74762_e("x");
                int teY = tagTileEntity.func_74762_e("y");
                int teZ = tagTileEntity.func_74762_e("z");
                tileEntities[teX + (teY * length + teZ) * width] = tagTileEntity;
            }
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < length; ++z) {
                        int index = x + (y * length + z) * width;
                        JumpBlock jumpBlock = new JumpBlock();
                        jumpBlock.x = x;
                        jumpBlock.y = y;
                        jumpBlock.z = z;
                        int blockId = localBlocks[index];
                        if (blockId < 0) {
                            blockId += 256;
                        }
                        if (localAddBlocks != null) {
                            int MSB = localAddBlocks[index / 2];
                            if (MSB < 0) {
                                MSB += 256;
                            }
                            blockId = index % 2 == 0 ? (blockId += (MSB & 0xF) << 8) : (blockId += (MSB & 0xF0) << 4);
                        }
                        jumpBlock.block = Block.func_149729_e((int)blockId);
                        jumpBlock.blockMeta = localMetadata[index] & 0xF;
                        jumpBlock.blockNBT = tileEntities[index];
                        if (jumpBlock.block != null) {
                            if (WarpDriveConfig.LOGGING_BUILDING) {
                                if (tileEntities[index] == null) {
                                    WarpDrive.logger.info("Adding block to deploy: " + jumpBlock.block.func_149739_a() + ":" + jumpBlock.blockMeta + " (no tile entity)");
                                } else {
                                    WarpDrive.logger.info("Adding block to deploy: " + jumpBlock.block.func_149739_a() + ":" + jumpBlock.blockMeta + " with tile entity " + tileEntities[index].func_74779_i("id"));
                                }
                            }
                        } else {
                            jumpBlock = null;
                        }
                        jumpShip.jumpBlocks[index] = jumpBlock;
                    }
                }
            }
        }
        return jumpShip;
    }

    public void messageToAllPlayersOnShip(String message) {
        String messageFormatted = String.format("[%s] %s", this.shipCore != null && !this.shipCore.shipName.isEmpty() ? this.shipCore.shipName : "ShipCore", message);
        if (this.entitiesOnShip == null) {
            StringBuilder reason = new StringBuilder();
            this.saveEntities(reason);
        }
        WarpDrive.logger.info(this + " messageToAllPlayersOnShip: " + message);
        for (MovingEntity movingEntity : this.entitiesOnShip) {
            Entity entity = movingEntity.getEntity();
            if (!(entity instanceof EntityPlayer)) continue;
            Commons.addChatMessage((ICommandSender)((EntityPlayer)entity), messageFormatted);
        }
    }

    public boolean saveEntities(StringBuilder reason) {
        boolean isSuccess = true;
        this.entitiesOnShip = new ArrayList<MovingEntity>();
        if (this.worldObj == null) {
            reason.append("Invalid call to saveEntities, please report it to mod author");
            return false;
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)((double)this.maxX + 0.99), (double)((double)this.maxY + 0.99), (double)((double)this.maxZ + 0.99));
        List list = this.worldObj.func_72839_b(null, axisalignedbb);
        for (Entity entity : list) {
            if (entity == null) continue;
            String id = EntityList.func_75621_b((Entity)entity);
            if (Dictionary.ENTITIES_ANCHOR.contains(id)) {
                if (reason.length() > 0) {
                    reason.append("\n");
                }
                reason.append(String.format("Anchor entity %s detected at (%d %d %d), aborting jump...", id, Math.round(entity.field_70165_t), Math.round(entity.field_70163_u), Math.round(entity.field_70161_v)));
                isSuccess = false;
                continue;
            }
            if (Dictionary.ENTITIES_LEFTBEHIND.contains(id)) {
                if (!WarpDriveConfig.LOGGING_JUMPBLOCKS) continue;
                WarpDrive.logger.info("Leaving entity " + id + " behind: " + entity);
                continue;
            }
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS && WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("Adding entity " + id + ": " + entity);
            }
            MovingEntity movingEntity = new MovingEntity(entity);
            this.entitiesOnShip.add(movingEntity);
        }
        return isSuccess;
    }

    public void setCaptain(String playerName) {
        this.entitiesOnShip = new ArrayList<MovingEntity>();
        EntityPlayerMP entityPlayerMP = Commons.getOnlinePlayerByName(playerName);
        if (entityPlayerMP == null) {
            WarpDrive.logger.error(String.format("%s setCaptain: captain is missing", this));
            return;
        }
        MovingEntity movingEntity = new MovingEntity((Entity)entityPlayerMP);
        this.entitiesOnShip.add(movingEntity);
    }

    public boolean isUnlimited() {
        if (this.entitiesOnShip == null) {
            return false;
        }
        for (MovingEntity movingEntity : this.entitiesOnShip) {
            if (!movingEntity.isUnlimited()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("%s/%d '%s' @ %s (%d %d %d)", this.getClass().getSimpleName(), this.hashCode(), this.shipCore == null ? "~NULL~" : this.shipCore.uuid + ":" + this.shipCore.shipName, this.worldObj == null ? "~NULL~" : this.worldObj.field_73011_w.func_80007_l(), this.coreX, this.coreY, this.coreZ);
    }

    public boolean checkBorders(StringBuilder reason) {
        for (int x = this.minX - 1; x <= this.maxX + 1; ++x) {
            boolean xBorder = x == this.minX - 1 || x == this.maxX + 1;
            for (int z = this.minZ - 1; z <= this.maxZ + 1; ++z) {
                boolean zBorder = z == this.minZ - 1 || z == this.maxZ + 1;
                for (int y = this.minY - 1; y <= this.maxY + 1; ++y) {
                    TileEntity tileEntity;
                    Block block;
                    boolean yBorder;
                    boolean bl = yBorder = y == this.minY - 1 || y == this.maxY + 1;
                    if (y < 0 || y > 255 || !xBorder && !yBorder && !zBorder || (block = this.worldObj.func_147439_a(x, y, z)).isAir((IBlockAccess)this.worldObj, x, y, z) || Dictionary.BLOCKS_LEFTBEHIND.contains(block) || Dictionary.BLOCKS_ANCHOR.contains(block) || (tileEntity = this.worldObj.func_147438_o(x, y, z)) == null) continue;
                    reason.append(String.format("Ship snagged by %s at (%d %d %d). Sneak right click the ship core to see your ship dimensions, then update your ship dimensions.", block.func_149732_F(), x, y, z));
                    this.worldObj.func_72876_a(null, (double)x, (double)y, (double)z, Math.min(120.0f, 4.0f * (float)(this.jumpBlocks.length / 50)), false);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean save(StringBuilder reason) {
        VectorI vPosition = new VectorI();
        try {
            int estimatedVolume = (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1) * (this.maxZ - this.minZ + 1);
            JumpBlock[][] placeTimeJumpBlocks = new JumpBlock[][]{new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume]};
            int[] placeTimeIndexes = new int[]{0, 0, 0, 0, 0};
            int actualVolume = 0;
            int newMass = 0;
            int xc1 = this.minX >> 4;
            int xc2 = this.maxX >> 4;
            int zc1 = this.minZ >> 4;
            int zc2 = this.maxZ >> 4;
            for (int xc = xc1; xc <= xc2; ++xc) {
                int x1 = Math.max(this.minX, xc << 4);
                int x2 = Math.min(this.maxX, (xc << 4) + 15);
                for (int zc = zc1; zc <= zc2; ++zc) {
                    int z1 = Math.max(this.minZ, zc << 4);
                    int z2 = Math.min(this.maxZ, (zc << 4) + 15);
                    for (int y = this.minY; y <= this.maxY; ++y) {
                        vPosition.y = y;
                        for (int x = x1; x <= x2; ++x) {
                            vPosition.x = x;
                            for (int z = z1; z <= z2; ++z) {
                                Integer placeTime;
                                vPosition.z = z;
                                Block block = this.worldObj.func_147439_a(x, y, z);
                                if (block == Blocks.field_150350_a || Dictionary.BLOCKS_LEFTBEHIND.contains(block)) continue;
                                ++actualVolume;
                                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                                    WarpDrive.logger.info("Block(" + x + " " + y + " " + z + ") is " + block.func_149739_a() + "@" + this.worldObj.func_72805_g(x, y, z));
                                }
                                if (!Dictionary.BLOCKS_NOMASS.contains(block)) {
                                    ++newMass;
                                }
                                if (Dictionary.BLOCKS_ANCHOR.contains(block)) {
                                    reason.append(String.format("Jump aborted by on-board anchor block %s at (%d %d %d).", block.func_149732_F(), x, y, z));
                                    return false;
                                }
                                int blockMeta = this.worldObj.func_72805_g(x, y, z);
                                TileEntity tileEntity = this.worldObj.func_147438_o(x, y, z);
                                JumpBlock jumpBlock = new JumpBlock(this.worldObj, x, y, z, block, blockMeta, tileEntity);
                                if (tileEntity != null && jumpBlock.externals != null) {
                                    for (Map.Entry<String, NBTBase> external : jumpBlock.externals.entrySet()) {
                                        IBlockTransformer blockTransformer = WarpDriveConfig.blockTransformers.get(external.getKey());
                                        if (blockTransformer == null || blockTransformer.isJumpReady(jumpBlock.block, jumpBlock.blockMeta, tileEntity, reason)) continue;
                                        if (reason.length() > 0) {
                                            reason.append("\n");
                                        }
                                        reason.append(String.format("Jump aborted by on-board block %s at (%d %d %d).", jumpBlock.block.func_149732_F(), jumpBlock.x, jumpBlock.y, jumpBlock.z));
                                        return false;
                                    }
                                }
                                if ((placeTime = Dictionary.BLOCKS_PLACE.get(block)) == null) {
                                    placeTime = tileEntity == null ? Integer.valueOf(2) : Integer.valueOf(3);
                                }
                                placeTimeJumpBlocks[placeTime.intValue()][placeTimeIndexes[placeTime.intValue()]] = jumpBlock;
                                int n = placeTime;
                                placeTimeIndexes[n] = placeTimeIndexes[n] + 1;
                            }
                        }
                    }
                }
            }
            this.jumpBlocks = new JumpBlock[actualVolume];
            int indexShip = 0;
            for (int placeTime = 0; placeTime < 5; ++placeTime) {
                for (int placeTimeIndex = 0; placeTimeIndex < placeTimeIndexes[placeTime]; ++placeTimeIndex) {
                    this.jumpBlocks[indexShip] = placeTimeJumpBlocks[placeTime][placeTimeIndex];
                    ++indexShip;
                }
            }
            this.actualMass = newMass;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String msg = String.format("Exception while saving ship, probably a corrupted block at (%d %d %d).", vPosition.x, vPosition.y, vPosition.z);
            WarpDrive.logger.error(msg);
            reason.append(msg);
            return false;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Ship saved as " + this.jumpBlocks.length + " blocks");
        }
        return true;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.coreX = tagCompound.func_74762_e("coreX");
        this.coreY = tagCompound.func_74762_e("coreY");
        this.coreZ = tagCompound.func_74762_e("coreZ");
        this.dx = tagCompound.func_74762_e("dx");
        this.dz = tagCompound.func_74762_e("dz");
        this.maxX = tagCompound.func_74762_e("maxX");
        this.maxZ = tagCompound.func_74762_e("maxZ");
        this.maxY = tagCompound.func_74762_e("maxY");
        this.minX = tagCompound.func_74762_e("minX");
        this.minZ = tagCompound.func_74762_e("minZ");
        this.minY = tagCompound.func_74762_e("minY");
        this.actualMass = tagCompound.func_74762_e("actualMass");
        NBTTagList tagList = tagCompound.func_150295_c("jumpBlocks", 10);
        this.jumpBlocks = new JumpBlock[tagList.func_74745_c()];
        for (int index = 0; index < tagList.func_74745_c(); ++index) {
            this.jumpBlocks[index] = new JumpBlock();
            this.jumpBlocks[index].readFromNBT(tagList.func_150305_b(index));
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("coreX", this.coreX);
        tagCompound.func_74768_a("coreY", this.coreY);
        tagCompound.func_74768_a("coreZ", this.coreZ);
        tagCompound.func_74768_a("dx", this.dx);
        tagCompound.func_74768_a("dz", this.dz);
        tagCompound.func_74768_a("maxX", this.maxX);
        tagCompound.func_74768_a("maxZ", this.maxZ);
        tagCompound.func_74768_a("maxY", this.maxY);
        tagCompound.func_74768_a("minX", this.minX);
        tagCompound.func_74768_a("minZ", this.minZ);
        tagCompound.func_74768_a("minY", this.minY);
        tagCompound.func_74768_a("actualMass", this.actualMass);
        NBTTagList tagListJumpBlocks = new NBTTagList();
        for (JumpBlock jumpBlock : this.jumpBlocks) {
            NBTTagCompound tagCompoundBlock = new NBTTagCompound();
            jumpBlock.writeToNBT(tagCompoundBlock);
            tagListJumpBlocks.func_74742_a((NBTBase)tagCompoundBlock);
        }
        tagCompound.func_74782_a("jumpBlocks", (NBTBase)tagListJumpBlocks);
    }
}

