/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.data.Jumpgate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class JumpgatesRegistry {
    private File file;
    private ArrayList<Jumpgate> gates = new ArrayList();

    public JumpgatesRegistry() {
        this.file = new File("gates.txt");
        this.loadGates();
    }

    public void saveGates() {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.file));
            for (Jumpgate jg : this.gates) {
                out.println(jg);
            }
            out.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            WarpDrive.logger.error("Exception while saving jumpgates to disk");
        }
    }

    public void loadGates() {
        WarpDrive.logger.info("Loading jump gates from gates.txt...");
        try {
            String s1;
            if (this.file != null && !this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.file));
            while ((s1 = bufferedreader.readLine()) != null) {
                this.gates.add(new Jumpgate(s1));
            }
            bufferedreader.close();
            WarpDrive.logger.info("Loaded " + this.gates.size() + " jump gates.");
        }
        catch (IOException exception) {
            exception.printStackTrace();
            WarpDrive.logger.error("Exception while loading jumpgates from disk");
        }
    }

    public void addGate(Jumpgate jg) {
        this.gates.add(jg);
    }

    public boolean addGate(String name, int x, int y, int z) {
        if (this.findGateByName(name) != null) {
            return false;
        }
        this.addGate(new Jumpgate(name, x, y, z));
        this.saveGates();
        return true;
    }

    public void removeGate(String name) {
        for (int i = 0; i < this.gates.size(); ++i) {
            Jumpgate jg = this.gates.get(i);
            if (!jg.name.equalsIgnoreCase(name)) continue;
            this.gates.remove(i);
            return;
        }
        this.saveGates();
    }

    public Jumpgate findGateByName(String name) {
        for (Jumpgate jg : this.gates) {
            if (!jg.name.equalsIgnoreCase(name)) continue;
            return jg;
        }
        return null;
    }

    public String JumpgatesList() {
        String result = "";
        for (Jumpgate jg : this.gates) {
            result = result + jg.toNiceString() + "\n";
        }
        return result;
    }

    public String commaList() {
        if (this.gates.isEmpty()) {
            return "<none> (check /generate to create one)";
        }
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        for (Jumpgate jg : this.gates) {
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(", ");
            }
            result.append(jg.toNiceString());
        }
        return result.toString();
    }

    public Jumpgate findNearestGate(int x, int y, int z) {
        double minDistance2 = -1.0;
        Jumpgate res = null;
        for (Jumpgate jg : this.gates) {
            double dX = jg.xCoord - x;
            double dY = jg.yCoord - y;
            double dZ = jg.zCoord - z;
            double distance2 = dX * dX + dY * dY + dZ * dZ;
            if (minDistance2 != -1.0 && !(distance2 < minDistance2)) continue;
            minDistance2 = distance2;
            res = jg;
        }
        return res;
    }
}

