/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.DataOutputLength;
import cr0s.warpdrive.data.Vector3;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MovingEntity {
    public static final MovingEntity INVALID = new MovingEntity(null);
    private final WeakReference<Entity> weakEntity;
    private final WeakReference<World> weakWorld;
    private final int entityId;
    public final Vector3 v3OriginalPosition;

    public MovingEntity(Entity entity) {
        if (entity == null) {
            this.weakEntity = new WeakReference<Object>(null);
            this.weakWorld = new WeakReference<Object>(null);
            this.entityId = -1;
            this.v3OriginalPosition = new Vector3(0.0, -100.0, 0.0);
        } else {
            this.weakEntity = new WeakReference<Entity>(entity);
            this.weakWorld = new WeakReference<World>(entity.field_70170_p);
            this.entityId = entity.func_145782_y();
            this.v3OriginalPosition = new Vector3(entity);
        }
    }

    public Entity getEntity() {
        if (this.entityId < 0) {
            return null;
        }
        Entity entity = (Entity)this.weakEntity.get();
        if (entity != null) {
            return entity;
        }
        World world = (World)this.weakWorld.get();
        if (world == null) {
            return null;
        }
        return world.func_73045_a(this.entityId);
    }

    public boolean isUnlimited() {
        Entity entity = this.getEntity();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        String playerName = ((EntityPlayer)entity).getDisplayName();
        for (String unlimitedName : WarpDriveConfig.SHIP_VOLUME_UNLIMITED_PLAYERNAMES) {
            if (!unlimitedName.equals(playerName)) continue;
            return true;
        }
        return false;
    }

    public double getDistanceMoved_square() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return Double.MAX_VALUE;
        }
        if (entity.field_70170_p != this.weakWorld.get()) {
            return Double.MAX_VALUE;
        }
        return this.v3OriginalPosition.distanceTo_square(entity);
    }

    public float getMassFactor() {
        int mass;
        Entity entity = this.getEntity();
        if (entity == null) {
            return 0.0f;
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        entity.func_70109_d(tagCompound);
        try {
            DataOutputLength dataOutputLength = new DataOutputLength();
            CompressedStreamTools.func_74800_a((NBTTagCompound)tagCompound, (DataOutput)dataOutputLength);
            if (WarpDrive.isDev) {
                WarpDrive.logger.info(String.format("Entity %s estimated mass is %d", entity, dataOutputLength.getLength()));
            }
            mass = dataOutputLength.getLength();
        }
        catch (IOException exception) {
            mass = (int)Math.sqrt(tagCompound.toString().length());
            WarpDrive.logger.error(String.format("Unable to estimate mass for entity %s, defaulting to %d", entity, mass));
        }
        return Commons.clamp(0.25f, 4.0f, (float)mass / 80000.0f);
    }
}

