/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IStarMapRegistryTileEntity;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumStarMapEntryType;
import cr0s.warpdrive.data.GlobalPosition;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class StarMapRegistryItem
extends GlobalPosition {
    public final EnumStarMapEntryType type;
    public final UUID uuid;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int minX;
    public int minY;
    public int minZ;
    public int mass;
    public double isolationRate = 0.0;
    public String name = "default";

    public StarMapRegistryItem(EnumStarMapEntryType type, UUID uuid, int dimensionId, int x, int y, int z, AxisAlignedBB aabbArea, int mass, double isolationRate, String name) {
        super(dimensionId, x, y, z);
        this.type = type;
        this.uuid = uuid;
        if (aabbArea == null) {
            this.maxX = x;
            this.maxY = y;
            this.maxZ = z;
            this.minX = x;
            this.minY = y;
            this.minZ = z;
        } else {
            this.maxX = (int)aabbArea.field_72336_d;
            this.maxY = (int)aabbArea.field_72337_e;
            this.maxZ = (int)aabbArea.field_72334_f;
            this.minX = (int)aabbArea.field_72340_a;
            this.minY = (int)aabbArea.field_72338_b;
            this.minZ = (int)aabbArea.field_72339_c;
        }
        this.mass = mass;
        this.isolationRate = isolationRate;
        this.name = name;
    }

    public StarMapRegistryItem(IStarMapRegistryTileEntity tileEntity) {
        this(tileEntity.getStarMapType(), tileEntity.getUUID(), ((TileEntity)tileEntity).func_145831_w().field_73011_w.field_76574_g, ((TileEntity)tileEntity).field_145851_c, ((TileEntity)tileEntity).field_145848_d, ((TileEntity)tileEntity).field_145849_e, tileEntity.getStarMapArea(), tileEntity.getMass(), tileEntity.getIsolationRate(), tileEntity.getStarMapName());
    }

    public boolean sameCoordinates(IStarMapRegistryTileEntity tileEntity) {
        assert (tileEntity instanceof TileEntity);
        return this.dimensionId == ((TileEntity)tileEntity).func_145831_w().field_73011_w.field_76574_g && this.x == ((TileEntity)tileEntity).field_145851_c && this.y == ((TileEntity)tileEntity).field_145848_d && this.z == ((TileEntity)tileEntity).field_145849_e;
    }

    public void update(IStarMapRegistryTileEntity tileEntity) {
        AxisAlignedBB aabbArea;
        if (WarpDrive.isDev) {
            assert (tileEntity instanceof TileEntity);
            assert (this.type == tileEntity.getStarMapType());
            assert (this.uuid.equals(tileEntity.getUUID()));
        }
        if ((aabbArea = tileEntity.getStarMapArea()) != null) {
            this.maxX = (int)aabbArea.field_72336_d;
            this.maxY = (int)aabbArea.field_72337_e;
            this.maxZ = (int)aabbArea.field_72334_f;
            this.minX = (int)aabbArea.field_72340_a;
            this.minY = (int)aabbArea.field_72338_b;
            this.minZ = (int)aabbArea.field_72339_c;
        }
        this.mass = tileEntity.getMass();
        this.isolationRate = tileEntity.getIsolationRate();
        this.name = tileEntity.getStarMapName();
    }

    public boolean contains(int x, int y, int z) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY && this.minZ <= z && z <= this.maxZ;
    }

    public StarMapRegistryItem(NBTTagCompound tagCompound) {
        super(tagCompound);
        this.type = EnumStarMapEntryType.getByName(tagCompound.func_74779_i("type"));
        UUID uuidLocal = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (uuidLocal.getMostSignificantBits() == 0L && uuidLocal.getLeastSignificantBits() == 0L) {
            uuidLocal = UUID.randomUUID();
        }
        this.uuid = uuidLocal;
        this.maxX = tagCompound.func_74762_e("maxX");
        this.maxY = tagCompound.func_74762_e("maxY");
        this.maxZ = tagCompound.func_74762_e("maxZ");
        this.minX = tagCompound.func_74762_e("minX");
        this.minY = tagCompound.func_74762_e("minY");
        this.minZ = tagCompound.func_74762_e("minZ");
        this.mass = tagCompound.func_74762_e("mass");
        this.isolationRate = tagCompound.func_74769_h("isolationRate");
        this.name = tagCompound.func_74779_i("name");
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74778_a("type", this.type.getName());
        if (this.uuid != null) {
            tagCompound.func_74772_a("uuidMost", this.uuid.getMostSignificantBits());
            tagCompound.func_74772_a("uuidLeast", this.uuid.getLeastSignificantBits());
        }
        tagCompound.func_74768_a("maxX", this.maxX);
        tagCompound.func_74768_a("maxY", this.maxY);
        tagCompound.func_74768_a("maxZ", this.maxZ);
        tagCompound.func_74768_a("minX", this.minX);
        tagCompound.func_74768_a("minY", this.minY);
        tagCompound.func_74768_a("minZ", this.minZ);
        tagCompound.func_74768_a("mass", this.mass);
        tagCompound.func_74780_a("isolationRate", this.isolationRate);
        if (this.name != null && !this.name.isEmpty()) {
            tagCompound.func_74778_a("name", this.name);
        }
    }

    public String getFormattedLocation() {
        CelestialObject celestialObject = CelestialObjectManager.get(false, this.dimensionId, this.x, this.z);
        if (celestialObject == null) {
            return String.format("DIM%d @ (%d %d %d)", this.dimensionId, this.x, this.y, this.z);
        }
        return String.format("%s [DIM%d] @ (%d %d %d)", celestialObject.getDisplayName(), this.dimensionId, this.x, this.y, this.z);
    }

    @Override
    public int hashCode() {
        return this.dimensionId << 24 + (this.x >> 10) << 12 + this.y << 10 + (this.z >> 10);
    }

    public String toString() {
        return String.format("%s '%s' %s @ DIM%d (%d %d %d) (%d %d %d) -> (%d %d %d)", this.getClass().getSimpleName(), this.type, this.uuid, this.dimensionId, this.x, this.y, this.z, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

