/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cr0s.warpdrive.BreathingManager;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.world.SpaceTeleporter;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class LivingHandler {
    private final HashMap<String, Integer> player_cloakTicks = new HashMap();
    private final HashMap<Integer, Double> entity_yMotion = new HashMap();
    private static final int CLOAK_CHECK_TIMEOUT_TICKS = 100;
    private static final int BORDER_WARNING_RANGE_BLOCKS_SQUARED = 400;
    private static final int BORDER_BYPASS_RANGE_BLOCKS_SQUARED = 1024;
    private static final int BORDER_BYPASS_PULL_BACK_BLOCKS = 16;
    private static final int BORDER_BYPASS_DAMAGES_PER_TICK = 9000;

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        CelestialObject celestialObject;
        if (event.entityLiving == null || event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entityLivingBase = event.entityLiving;
        int x = MathHelper.func_76128_c((double)entityLivingBase.field_70165_t);
        int y = MathHelper.func_76128_c((double)entityLivingBase.field_70163_u);
        int z = MathHelper.func_76128_c((double)entityLivingBase.field_70161_v);
        if (!entityLivingBase.field_70122_E) {
            this.entity_yMotion.put(entityLivingBase.func_145782_y(), entityLivingBase.field_70181_x);
        }
        if ((celestialObject = CelestialObjectManager.get(entityLivingBase.field_70170_p, x, z)) == null) {
            return;
        }
        double distanceSquared = celestialObject.getSquareDistanceOutsideBorder(x, z);
        if (distanceSquared <= 0.0) {
            if (Math.abs(distanceSquared) <= 400.0 && entityLivingBase instanceof EntityPlayer && entityLivingBase.field_70173_aa % 40 == 0) {
                Commons.addChatMessage((ICommandSender)((EntityPlayer)entityLivingBase), String.format("\u00c2\u00a7cProximity alert: world border is only %d m away!", (int)Math.sqrt(Math.abs(distanceSquared))));
            }
        } else {
            if (entityLivingBase instanceof EntityPlayerMP && ((EntityPlayerMP)entityLivingBase).field_71075_bZ.field_75098_d) {
                if (entityLivingBase.field_70173_aa % 100 == 0) {
                    Commons.addChatMessage((ICommandSender)((EntityPlayer)entityLivingBase), String.format("\u00c2\u00a7cYou're %d m outside the world border...", (int)Math.sqrt(Math.abs(distanceSquared))));
                }
                return;
            }
            double relativeX = entityLivingBase.field_70165_t - (double)celestialObject.dimensionCenterX;
            double relativeZ = entityLivingBase.field_70161_v - (double)celestialObject.dimensionCenterZ;
            double newAbsoluteX = Math.min(Math.abs(relativeX), Math.max(0.0, (double)(celestialObject.borderRadiusX - 16)));
            double newAbsoluteZ = Math.min(Math.abs(relativeZ), Math.max(0.0, (double)(celestialObject.borderRadiusZ - 16)));
            double newEntityX = (double)celestialObject.dimensionCenterX + Math.signum(relativeX) * newAbsoluteX;
            double newEntityY = entityLivingBase.field_70163_u + 0.1;
            double newEntityZ = (double)celestialObject.dimensionCenterX + Math.signum(relativeZ) * newAbsoluteZ;
            Commons.moveEntity((Entity)entityLivingBase, entityLivingBase.field_70170_p, new Vector3(newEntityX, newEntityY, newEntityZ));
            if (entityLivingBase instanceof EntityPlayer && !entityLivingBase.field_70128_L && entityLivingBase.field_70725_aQ <= 0) {
                Commons.addChatMessage((ICommandSender)((EntityPlayer)entityLivingBase), "\u00c2\u00a74You've reached the world border...");
            }
            if (distanceSquared < 1024.0) {
                entityLivingBase.func_70015_d(1);
            } else {
                entityLivingBase.func_70097_a(DamageSource.field_76380_i, 9000.0f);
                return;
            }
        }
        if (entityLivingBase instanceof EntityPlayerMP) {
            this.updatePlayerCloakState(entityLivingBase);
            if (WarpDriveConfig.BREATHING_AIR_AT_ENTITY_DEBUG && entityLivingBase.field_70170_p.func_72820_D() % 20L == 0L) {
                StateAir.dumpAroundEntity((EntityPlayer)entityLivingBase);
            }
        }
        if (entityLivingBase.field_70128_L || entityLivingBase.func_85032_ar()) {
            return;
        }
        if (!(celestialObject.hasAtmosphere() || entityLivingBase instanceof EntityPlayerMP && ((EntityPlayerMP)entityLivingBase).field_71075_bZ.field_75098_d)) {
            BreathingManager.onLivingUpdateEvent(entityLivingBase, x, y, z);
        }
        if (entityLivingBase.field_70163_u < -10.0) {
            CelestialObject celestialObjectChild = CelestialObjectManager.getClosestChild(entityLivingBase.field_70170_p, x, z);
            if (celestialObjectChild != null && !celestialObject.isHyperspace() && celestialObjectChild.isInOrbit(entityLivingBase.field_70170_p.field_73011_w.field_76574_g, x, z)) {
                WorldServer worldTarget = Commons.getOrCreateWorldServer(celestialObjectChild.dimensionId);
                if (worldTarget == null) {
                    WarpDrive.logger.error(String.format("Unable to initialize dimension %d for %s", celestialObjectChild.dimensionId, entityLivingBase));
                } else {
                    VectorI vEntry = celestialObjectChild.getEntryOffset();
                    int xTarget = x + vEntry.x;
                    int yTarget = worldTarget.func_72940_L() + 5;
                    int zTarget = z + vEntry.z;
                    if (entityLivingBase instanceof EntityPlayerMP) {
                        EntityPlayerMP player = (EntityPlayerMP)entityLivingBase;
                        player.field_70143_R = -5.0f;
                        player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, celestialObjectChild.dimensionId, (Teleporter)new SpaceTeleporter(worldTarget, 0, xTarget, yTarget, zTarget));
                        if (!celestialObject.hasAtmosphere() && celestialObjectChild.hasAtmosphere()) {
                            player.func_70015_d(30);
                        }
                        player.func_70634_a((double)xTarget + 0.5, (double)yTarget, (double)zTarget + 0.5);
                        player.func_71016_p();
                    }
                }
            } else if (celestialObject.isHyperspace() || celestialObject.isSpace()) {
                entityLivingBase.func_70634_a(entityLivingBase.field_70165_t, 260.0, entityLivingBase.field_70161_v);
            }
        }
    }

    private void updatePlayerCloakState(EntityLivingBase entity) {
        try {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Integer cloakTicks = this.player_cloakTicks.get(player.func_70005_c_());
            if (cloakTicks == null) {
                this.player_cloakTicks.put(player.func_70005_c_(), 0);
                return;
            }
            if (cloakTicks >= 100) {
                this.player_cloakTicks.put(player.func_70005_c_(), 0);
                WarpDrive.cloaks.updatePlayer(player);
            } else {
                this.player_cloakTicks.put(player.func_70005_c_(), cloakTicks + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityLivingBase entityLivingBase = event.entityLiving;
        Double motionY = this.entity_yMotion.get(entityLivingBase.func_145782_y());
        if (motionY == null) {
            motionY = entityLivingBase.field_70181_x;
        }
        if (motionY > -0.6517) {
            event.setCanceled(true);
            if (WarpDrive.isDev && entityLivingBase instanceof EntityPlayerMP) {
                WarpDrive.logger.warn(String.format("(low speed     ) Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.distance), entityLivingBase, event.isCanceled()));
            }
            return;
        }
        float distance = event.distance;
        int check = MathHelper.func_76123_f((float)(distance - 3.0f));
        if (check <= 0) {
            event.setCanceled(true);
            if (WarpDrive.isDev && entityLivingBase instanceof EntityPlayerMP) {
                WarpDrive.logger.warn(String.format("(short distance) Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.distance), entityLivingBase, event.isCanceled()));
            }
            return;
        }
        if (WarpDrive.isDev) {
            WarpDrive.logger.warn(String.format("Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.distance), entityLivingBase, event.isCanceled()));
        }
        for (int i = 1; i < 5; ++i) {
            ItemStack itemStackInSlot = entityLivingBase.func_71124_b(i);
            if (itemStackInSlot == null || !Dictionary.ITEMS_NOFALLDAMAGE.contains(itemStackInSlot.func_77973_b())) continue;
            event.setCanceled(true);
            if (!WarpDrive.isDev || !(entityLivingBase instanceof EntityPlayerMP)) continue;
            WarpDrive.logger.warn(String.format("(boot absorbed ) Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.distance), entityLivingBase, event.isCanceled()));
        }
        event.distance = (float)(-6.582 + 4.148 * Math.exp(1.2 * Math.abs(motionY)));
        if (WarpDrive.isDev && entityLivingBase instanceof EntityPlayerMP) {
            WarpDrive.logger.warn(String.format("(full damage   ) Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.distance), entityLivingBase, event.isCanceled()));
        }
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (event.entityLiving == null || event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        World world = event.entityLiving.field_70170_p;
        int x = MathHelper.func_76128_c((double)event.targetX);
        int y = MathHelper.func_76128_c((double)event.targetY);
        int z = MathHelper.func_76128_c((double)event.targetZ);
        for (int xLoop = x - 1; xLoop <= x + 1; ++xLoop) {
            for (int zLoop = z - 1; zLoop <= z + 1; ++zLoop) {
                for (int yLoop = y - 1; yLoop <= y + 1; ++yLoop) {
                    Block block;
                    if (yLoop <= 0 || yLoop > 255 || !((block = world.func_147439_a(xLoop, yLoop, zLoop)) instanceof BlockForceField)) continue;
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }
}

