/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.BreathingManager;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.event.AbstractSequencer;
import cr0s.warpdrive.event.ChunkHandler;
import cr0s.warpdrive.network.PacketHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WorldHandler {
    public void onChunkLoaded(ChunkWatchEvent event) {
        ChunkCoordIntPair chunk = event.chunk;
        WarpDrive.logger.info("onChunkLoaded " + chunk.field_77276_a + " " + chunk.field_77275_b);
        WarpDrive.cloaks.onChunkLoaded(event.player, chunk.field_77276_a, chunk.field_77275_b);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)event.entity;
            int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)event.entity.field_70163_u);
            int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
            CelestialObject celestialObject = CelestialObjectManager.get(event.world, x, z);
            if (event.entity instanceof EntityPlayerMP) {
                WarpDrive.cloaks.onPlayerJoinWorld((EntityPlayerMP)event.entity, event.world);
                PacketHandler.sendClientSync((EntityPlayerMP)event.entity, celestialObject);
            } else {
                boolean canJoin;
                if (celestialObject == null) {
                    return;
                }
                if (event.entity.field_70173_aa > 5) {
                    return;
                }
                if (!celestialObject.hasAtmosphere() && !(canJoin = BreathingManager.onLivingJoinEvent(entityLivingBase, x, y, z))) {
                    event.setCanceled(true);
                }
                if (!celestialObject.isInsideBorder(event.entity.field_70165_t, event.entity.field_70161_v)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WarpDrive.logger.info(String.format("onPlayerChangedDimension %s %d -> %d", event.player.func_70005_c_(), event.fromDim, event.toDim));
        WarpDrive.cloaks.onPlayerJoinWorld((EntityPlayerMP)event.player, ((EntityPlayerMP)event.player).field_70170_p);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        WarpDrive.cloaks.onClientChangingDimension();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldUnload(WorldEvent.Unload event) {
        WarpDrive.cloaks.onClientChangingDimension();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        AbstractSequencer.updateTick();
    }

    @SubscribeEvent
    public void onBlockUpdated(BlockEvent blockEvent) {
        if (WarpDriveConfig.LOGGING_BREAK_PLACE && WarpDrive.isDev) {
            WarpDrive.logger.info("onBlockUpdate args " + blockEvent.block + "@" + blockEvent.blockMetadata + " actual " + blockEvent.world.func_147439_a(blockEvent.x, blockEvent.y, blockEvent.z) + "@" + blockEvent.world.func_72805_g(blockEvent.x, blockEvent.y, blockEvent.z));
        }
        WarpDrive.starMap.onBlockUpdated(blockEvent.world, blockEvent.x, blockEvent.y, blockEvent.z, blockEvent.block, blockEvent.blockMetadata);
        ChunkHandler.onBlockUpdated(blockEvent.world, blockEvent.x, blockEvent.y, blockEvent.z);
    }
}

