/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IParticleContainerItem;
import cr0s.warpdrive.api.Particle;
import cr0s.warpdrive.api.ParticleRegistry;
import cr0s.warpdrive.api.ParticleStack;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemElectromagneticCell
extends ItemAbstractBase
implements IParticleContainerItem {
    private static final String AMOUNT_TO_CONSUME_TAG = "amountToConsume";
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemElectromagneticCell() {
        this.func_77656_e(0);
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.atomic.electromagnetic_cell");
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[31];
        this.icons[0] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-empty");
        this.icons[1] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-blue-20");
        this.icons[2] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-blue-40");
        this.icons[3] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-blue-60");
        this.icons[4] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-blue-80");
        this.icons[5] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-blue-100");
        this.icons[6] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-blue-full");
        this.icons[7] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-green-20");
        this.icons[8] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-green-40");
        this.icons[9] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-green-60");
        this.icons[10] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-green-80");
        this.icons[11] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-green-100");
        this.icons[12] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-green-full");
        this.icons[13] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-pink-20");
        this.icons[14] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-pink-40");
        this.icons[15] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-pink-60");
        this.icons[16] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-pink-80");
        this.icons[17] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-pink-100");
        this.icons[18] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-pink-full");
        this.icons[19] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-red-20");
        this.icons[20] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-red-40");
        this.icons[21] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-red-60");
        this.icons[22] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-red-80");
        this.icons[23] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-red-100");
        this.icons[24] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-red-full");
        this.icons[25] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-yellow-20");
        this.icons[26] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-yellow-40");
        this.icons[27] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-yellow-60");
        this.icons[28] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-yellow-80");
        this.icons[29] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-yellow-100");
        this.icons[30] = iconRegister.func_94245_a("warpdrive:atomic/electromagnetic_cell-yellow-full");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.icons[damage % this.icons.length];
    }

    public static ItemStack getItemStackNoCache(Particle particle, int amount) {
        ItemStack itemStack = new ItemStack((Item)WarpDrive.itemElectromagneticCell, 1, 0);
        ParticleStack particleStack = null;
        if (particle != null && amount != 0) {
            particleStack = new ParticleStack(particle, amount);
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74782_a("particle", (NBTBase)particleStack.writeToNBT(new NBTTagCompound()));
            itemStack.func_77982_d(tagCompound);
        }
        ItemElectromagneticCell.updateDamageLevel(itemStack, particleStack);
        return itemStack;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        list.add(ItemElectromagneticCell.getItemStackNoCache(null, 0));
        list.add(ItemElectromagneticCell.getItemStackNoCache(ParticleRegistry.ION, 1000));
        list.add(ItemElectromagneticCell.getItemStackNoCache(ParticleRegistry.PROTON, 1000));
        list.add(ItemElectromagneticCell.getItemStackNoCache(ParticleRegistry.ANTIMATTER, 1000));
        list.add(ItemElectromagneticCell.getItemStackNoCache(ParticleRegistry.STRANGE_MATTER, 1000));
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public boolean func_77630_h(ItemStack itemStack) {
        return false;
    }

    public Item func_77668_q() {
        return Item.func_150898_a((Block)Blocks.field_150480_ab);
    }

    public ItemStack getContainerItem(ItemStack itemStackFilled) {
        ParticleStack particleStack = this.getParticleStack(itemStackFilled);
        if (particleStack != null) {
            int amount = particleStack.getAmount() - this.getAmountToConsume(itemStackFilled);
            if (amount <= 0) {
                return ItemElectromagneticCell.getItemStackNoCache(null, 0);
            }
            return ItemElectromagneticCell.getItemStackNoCache(particleStack.getParticle(), amount);
        }
        return new ItemStack((Block)Blocks.field_150480_ab);
    }

    @Override
    public void setAmountToConsume(ItemStack itemStack, int amountToConsume) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            return;
        }
        NBTTagCompound tagCompound = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        tagCompound.func_74768_a(AMOUNT_TO_CONSUME_TAG, amountToConsume);
    }

    private int getAmountToConsume(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74762_e(AMOUNT_TO_CONSUME_TAG);
        }
        return 0;
    }

    private static int getDamageLevel(ItemStack itemStack, ParticleStack particleStack) {
        if (!(itemStack.func_77973_b() instanceof ItemElectromagneticCell)) {
            WarpDrive.logger.error("Invalid ItemStack passed, expecting ItemElectromagneticCell: " + itemStack);
            return itemStack.func_77960_j();
        }
        if (particleStack == null || particleStack.getParticle() == null) {
            return 0;
        }
        ItemElectromagneticCell itemElectromagneticCell = (ItemElectromagneticCell)itemStack.func_77973_b();
        int type = particleStack.getParticle().getColorIndex() % 5;
        double ratio = (double)particleStack.getAmount() / (double)itemElectromagneticCell.getCapacity(itemStack);
        int offset = ratio < 0.2 ? 0 : (ratio < 0.4 ? 1 : (ratio < 0.6 ? 2 : (ratio < 0.8 ? 3 : (ratio < 1.0 ? 4 : 5))));
        return 1 + type * 6 + offset;
    }

    private static void updateDamageLevel(ItemStack itemStack, ParticleStack particleStack) {
        itemStack.func_77964_b(ItemElectromagneticCell.getDamageLevel(itemStack, particleStack));
    }

    @Override
    public ParticleStack getParticleStack(ItemStack itemStack) {
        if (itemStack.func_77973_b() != this) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        if (!tagCompound.func_74764_b("particle")) {
            return null;
        }
        return ParticleStack.loadFromNBT(tagCompound.func_74775_l("particle"));
    }

    @Override
    public int getCapacity(ItemStack container) {
        return 1000;
    }

    @Override
    public boolean isEmpty(ItemStack itemStack) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        return particleStack == null || particleStack.isEmpty();
    }

    @Override
    public int fill(ItemStack itemStack, ParticleStack resource, boolean doFill) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            particleStack = new ParticleStack(resource.getParticle(), 0);
        } else if (!particleStack.isParticleEqual(resource) || particleStack.getAmount() >= this.getCapacity(itemStack)) {
            return 0;
        }
        int transfer = Math.min(resource.getAmount(), this.getCapacity(itemStack) - particleStack.getAmount());
        if (doFill) {
            particleStack.fill(transfer);
            NBTTagCompound tagCompound = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
            tagCompound.func_74782_a("particle", (NBTBase)particleStack.writeToNBT(new NBTTagCompound()));
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(tagCompound);
            }
            ItemElectromagneticCell.updateDamageLevel(itemStack, particleStack);
        }
        return transfer;
    }

    @Override
    public ParticleStack drain(ItemStack itemStack, ParticleStack resource, boolean doDrain) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            return null;
        }
        if (!particleStack.isParticleEqual(resource) || particleStack.getAmount() <= 0) {
            return null;
        }
        int transfer = Math.min(resource.getAmount(), particleStack.getAmount());
        if (doDrain) {
            particleStack.fill(-transfer);
            NBTTagCompound tagCompound = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
            tagCompound.func_74782_a("particle", (NBTBase)particleStack.writeToNBT(new NBTTagCompound()));
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(tagCompound);
            }
            ItemElectromagneticCell.updateDamageLevel(itemStack, particleStack);
        }
        return resource.copy(transfer);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.isEmpty()) {
            return super.getEntityLifespan(itemStack, world);
        }
        int lifespan = particleStack.getEntityLifespan();
        if (lifespan < 0) {
            return super.getEntityLifespan(itemStack, world);
        }
        return (2 - particleStack.getAmount() / this.getCapacity(itemStack)) * lifespan;
    }

    @Override
    public void onEntityExpireEvent(EntityItem entityItem, ItemStack itemStack) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.isEmpty()) {
            super.onEntityExpireEvent(entityItem, itemStack);
            return;
        }
        particleStack.onWorldEffect(entityItem.field_70170_p, new Vector3((Entity)entityItem));
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean advancedItemTooltips) {
        super.func_77624_a(itemStack, entityPlayer, list, advancedItemTooltips);
        if (!(itemStack.func_77973_b() instanceof ItemElectromagneticCell)) {
            WarpDrive.logger.error("Invalid ItemStack passed, expecting ItemElectromagneticCell: " + itemStack);
            return;
        }
        ItemElectromagneticCell itemElectromagneticCell = (ItemElectromagneticCell)itemStack.func_77973_b();
        ParticleStack particleStack = itemElectromagneticCell.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            String tooltip = StatCollector.func_74837_a((String)"item.warpdrive.atomic.electromagnetic_cell.tooltip.empty", (Object[])new Object[0]);
            Commons.addTooltip(list, tooltip);
        } else {
            Particle particle = particleStack.getParticle();
            String tooltip = StatCollector.func_74837_a((String)"item.warpdrive.atomic.electromagnetic_cell.tooltip.filled", (Object[])new Object[]{particleStack.getAmount(), particle.getLocalizedName()});
            Commons.addTooltip(list, tooltip);
            String particleTooltip = particle.getLocalizedTooltip();
            if (!particleTooltip.isEmpty()) {
                Commons.addTooltip(list, particleTooltip);
            }
        }
    }
}

