/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemEnergyWrapper {
    public static boolean isEnergyContainer(ItemStack itemStack) {
        boolean bResult = false;
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            bResult = ItemEnergyWrapper.IC2_isContainer(itemStack);
        }
        if (!bResult && WarpDriveConfig.isCoFHCoreLoaded) {
            bResult = ItemEnergyWrapper.CoFH_isContainer(itemStack);
        }
        return bResult;
    }

    public static boolean canInput(ItemStack itemStack) {
        boolean bResult = false;
        if (WarpDriveConfig.isIndustrialCraft2Loaded && ItemEnergyWrapper.IC2_isContainer(itemStack)) {
            bResult = ItemEnergyWrapper.IC2_canInput(itemStack);
        }
        if (!bResult && WarpDriveConfig.isCoFHCoreLoaded && ItemEnergyWrapper.CoFH_isContainer(itemStack)) {
            bResult = ItemEnergyWrapper.CoFH_canInput(itemStack);
        }
        return bResult;
    }

    public static boolean canOutput(ItemStack itemStack) {
        boolean bResult = false;
        if (WarpDriveConfig.isIndustrialCraft2Loaded && ItemEnergyWrapper.IC2_isContainer(itemStack)) {
            bResult = ItemEnergyWrapper.IC2_canOutput(itemStack);
        }
        if (!bResult && WarpDriveConfig.isCoFHCoreLoaded && ItemEnergyWrapper.CoFH_isContainer(itemStack)) {
            bResult = ItemEnergyWrapper.CoFH_canOutput(itemStack);
        }
        return bResult;
    }

    public static int getEnergyStored(ItemStack itemStack) {
        if (WarpDriveConfig.isIndustrialCraft2Loaded && ItemEnergyWrapper.IC2_isContainer(itemStack)) {
            double amount_EU = Commons.clamp(0.0, ItemEnergyWrapper.IC2_getMaxEnergyStorage(itemStack), ItemEnergyWrapper.IC2_getEnergyStored(itemStack));
            return (int)TileEntityAbstractEnergy.convertEUtoInternal_floor(amount_EU);
        }
        if (WarpDriveConfig.isCoFHCoreLoaded && ItemEnergyWrapper.CoFH_isContainer(itemStack)) {
            int amount_RF = Commons.clamp(0, ItemEnergyWrapper.CoFH_getMaxEnergyStorage(itemStack), ItemEnergyWrapper.CoFH_getEnergyStored(itemStack));
            return (int)TileEntityAbstractEnergy.convertRFtoInternal_floor(amount_RF);
        }
        return 0;
    }

    public static int getMaxEnergyStorage(ItemStack itemStack) {
        if (WarpDriveConfig.isIndustrialCraft2Loaded && ItemEnergyWrapper.IC2_isContainer(itemStack)) {
            double amount_EU = ItemEnergyWrapper.IC2_getMaxEnergyStorage(itemStack);
            return (int)TileEntityAbstractEnergy.convertEUtoInternal_floor(amount_EU);
        }
        if (WarpDriveConfig.isCoFHCoreLoaded && ItemEnergyWrapper.CoFH_isContainer(itemStack)) {
            int amount_RF = ItemEnergyWrapper.CoFH_getMaxEnergyStorage(itemStack);
            return (int)TileEntityAbstractEnergy.convertRFtoInternal_floor(amount_RF);
        }
        return 0;
    }

    public static ItemStack consume(ItemStack itemStack, int amount, boolean simulate) {
        if (WarpDriveConfig.isIndustrialCraft2Loaded && ItemEnergyWrapper.IC2_isContainer(itemStack)) {
            double amount_EU = TileEntityAbstractEnergy.convertInternalToEU_ceil(amount);
            return ItemEnergyWrapper.IC2_consume(itemStack, amount_EU, simulate);
        }
        if (WarpDriveConfig.isCoFHCoreLoaded && ItemEnergyWrapper.CoFH_isContainer(itemStack)) {
            int amount_RF = TileEntityAbstractEnergy.convertInternalToRF_ceil(amount);
            return ItemEnergyWrapper.CoFH_consume(itemStack, amount_RF, simulate);
        }
        return null;
    }

    public static ItemStack charge(ItemStack itemStack, int amount, boolean simulate) {
        if (WarpDriveConfig.isIndustrialCraft2Loaded && ItemEnergyWrapper.IC2_isContainer(itemStack)) {
            double amount_EU = TileEntityAbstractEnergy.convertInternalToEU_floor(amount);
            return ItemEnergyWrapper.IC2_charge(itemStack, amount_EU, simulate);
        }
        if (WarpDriveConfig.isCoFHCoreLoaded && ItemEnergyWrapper.CoFH_isContainer(itemStack)) {
            int amount_RF = TileEntityAbstractEnergy.convertInternalToRF_floor(amount);
            return ItemEnergyWrapper.CoFH_charge(itemStack, amount_RF, simulate);
        }
        return null;
    }

    @Optional.Method(modid="IC2")
    private static IElectricItemManager IC2_getManager(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return null;
        }
        if (item instanceof ISpecialElectricItem) {
            return ((ISpecialElectricItem)item).getManager(itemStack);
        }
        if (item instanceof IElectricItem) {
            return ElectricItem.rawManager;
        }
        return ElectricItem.getBackupManager((ItemStack)itemStack);
    }

    @Optional.Method(modid="IC2")
    private static boolean IC2_isContainer(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof IElectricItem;
    }

    @Optional.Method(modid="IC2")
    private static boolean IC2_canOutput(ItemStack itemStack) {
        return ((IElectricItem)itemStack.func_77973_b()).canProvideEnergy(itemStack);
    }

    @Optional.Method(modid="IC2")
    private static boolean IC2_canInput(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="IC2")
    private static double IC2_getEnergyStored(ItemStack itemStack) {
        IElectricItemManager electricItemManager = ItemEnergyWrapper.IC2_getManager(itemStack);
        if (electricItemManager == null) {
            return 0.0;
        }
        return electricItemManager.getCharge(itemStack);
    }

    @Optional.Method(modid="IC2")
    private static double IC2_getMaxEnergyStorage(ItemStack itemStack) {
        return ((IElectricItem)itemStack.func_77973_b()).getMaxCharge(itemStack);
    }

    @Optional.Method(modid="IC2")
    private static ItemStack IC2_consume(ItemStack itemStack, double amount_EU, boolean simulate) {
        IElectricItemManager electricItemManager = ItemEnergyWrapper.IC2_getManager(itemStack);
        if (electricItemManager == null) {
            return null;
        }
        if (amount_EU <= electricItemManager.getCharge(itemStack) && !simulate) {
            electricItemManager.discharge(itemStack, amount_EU, ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack), true, true, simulate);
            return itemStack;
        }
        return null;
    }

    @Optional.Method(modid="IC2")
    private static ItemStack IC2_charge(ItemStack itemStack, double amount_EU, boolean simulate) {
        IElectricItemManager electricItemManager = ItemEnergyWrapper.IC2_getManager(itemStack);
        if (electricItemManager == null) {
            return null;
        }
        if (amount_EU >= ItemEnergyWrapper.IC2_getMaxEnergyStorage(itemStack) && !simulate) {
            electricItemManager.charge(itemStack, amount_EU, ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack), true, simulate);
            return itemStack;
        }
        return null;
    }

    @Optional.Method(modid="CoFHCore")
    private static boolean CoFH_isContainer(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof IEnergyContainerItem;
    }

    @Optional.Method(modid="CoFHCore")
    private static boolean CoFH_canOutput(ItemStack itemStack) {
        return ((IEnergyContainerItem)itemStack.func_77973_b()).getEnergyStored(itemStack) > 0;
    }

    @Optional.Method(modid="CoFHCore")
    private static boolean CoFH_canInput(ItemStack itemStack) {
        return ((IEnergyContainerItem)itemStack.func_77973_b()).getEnergyStored(itemStack) < ((IEnergyContainerItem)itemStack.func_77973_b()).getMaxEnergyStored(itemStack);
    }

    @Optional.Method(modid="CoFHCore")
    private static int CoFH_getEnergyStored(ItemStack itemStack) {
        return (int)Math.floor(((IEnergyContainerItem)itemStack.func_77973_b()).getEnergyStored(itemStack));
    }

    @Optional.Method(modid="CoFHCore")
    private static int CoFH_getMaxEnergyStorage(ItemStack itemStack) {
        return (int)Math.floor(((IEnergyContainerItem)itemStack.func_77973_b()).getMaxEnergyStored(itemStack));
    }

    @Optional.Method(modid="CoFHCore")
    private static ItemStack CoFH_consume(ItemStack itemStack, int amount_RF, boolean simulate) {
        if (((IEnergyContainerItem)itemStack.func_77973_b()).extractEnergy(itemStack, amount_RF, simulate) > 0) {
            return itemStack;
        }
        return null;
    }

    @Optional.Method(modid="CoFHCore")
    private static ItemStack CoFH_charge(ItemStack itemStack, int amount_RF, boolean simulate) {
        if (((IEnergyContainerItem)itemStack.func_77973_b()).receiveEnergy(itemStack, amount_RF, simulate) > 0) {
            return itemStack;
        }
        return null;
    }
}

