/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.item.ItemAbstractBase;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.reactor.IReactorComponent", modid="IC2")})
public class ItemIC2reactorLaserFocus
extends ItemAbstractBase
implements IReactorComponent {
    private static final int[] xOffset = new int[]{-1, 0, 0, 1};
    private static final int[] yOffset = new int[]{0, -1, 1, 0};

    public ItemIC2reactorLaserFocus() {
        this.func_77656_e(WarpDriveConfig.IC2_REACTOR_MAX_HEAT_STORED);
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        this.func_77655_b("warpdrive.energy.IC2reactorLaserFocus");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("warpdrive:energy/ic2_reactor_laser_focus");
    }

    public static int getCurrentHeat(ItemStack itemStackFocus) {
        return itemStackFocus.func_77960_j();
    }

    public static int addHeat(ItemStack itemStackFocus, int heat) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s addHeat(heat %d)", itemStackFocus, heat));
        }
        int heatCurrent = ItemIC2reactorLaserFocus.getCurrentHeat(itemStackFocus);
        int heatToTransfer = Math.min(heat, WarpDriveConfig.IC2_REACTOR_MAX_HEAT_STORED - heatCurrent);
        ItemIC2reactorLaserFocus.setHeat(itemStackFocus, heatCurrent + heatToTransfer);
        return heat - heatToTransfer;
    }

    private static void setHeat(ItemStack itemStackFocus, int heat) {
        itemStackFocus.func_77964_b(heat);
    }

    private static void balanceComponent(ItemStack itemStackFocus1, ItemStack itemStackFocus2) {
        int heatOld2;
        int heatOld1 = ItemIC2reactorLaserFocus.getCurrentHeat(itemStackFocus1);
        if (heatOld1 < (heatOld2 = ItemIC2reactorLaserFocus.getCurrentHeat(itemStackFocus2))) {
            int heatToTransfer = Math.min((heatOld2 - heatOld1) / 2, WarpDriveConfig.IC2_REACTOR_FOCUS_HEAT_TRANSFER_PER_TICK);
            int heatNew1 = Math.min(WarpDriveConfig.IC2_REACTOR_MAX_HEAT_STORED, heatOld1 + heatToTransfer);
            int heatNew2 = heatOld2 - (heatNew1 - heatOld1);
            ItemIC2reactorLaserFocus.setHeat(itemStackFocus1, heatNew1);
            ItemIC2reactorLaserFocus.setHeat(itemStackFocus2, heatNew2);
        }
    }

    @Optional.Method(modid="IC2")
    private static void coolComponent(ItemStack itemStackFocus, IReactorComponent reactorComponent, IReactor reactor, ItemStack itemStackComponent, int x, int y) {
        int heatMaxRate = Math.min(WarpDriveConfig.IC2_REACTOR_COMPONENT_HEAT_TRANSFER_PER_TICK, WarpDriveConfig.IC2_REACTOR_MAX_HEAT_STORED - itemStackFocus.func_77960_j());
        int heatComponent = reactorComponent.getCurrentHeat(reactor, itemStackComponent, x, y);
        int heatToTransfer = -Math.min(heatComponent, heatMaxRate);
        int heatRetained = reactorComponent.alterHeat(reactor, itemStackComponent, x, y, heatToTransfer);
        ItemIC2reactorLaserFocus.addHeat(itemStackFocus, heatRetained - heatToTransfer);
    }

    @Optional.Method(modid="IC2")
    private static void coolReactor(IReactor reactor, ItemStack self) {
        int heatMaxRate = Math.min(WarpDriveConfig.IC2_REACTOR_REACTOR_HEAT_TRANSFER_PER_TICK, WarpDriveConfig.IC2_REACTOR_MAX_HEAT_STORED - self.func_77960_j());
        int heatReactor = reactor.getHeat();
        int heatToTransfer = Math.min(heatMaxRate, heatReactor);
        reactor.addHeat(-heatToTransfer);
        ItemIC2reactorLaserFocus.addHeat(self, heatToTransfer);
    }

    @Optional.Method(modid="IC2")
    public void processChamber(IReactor reactor, ItemStack itemStackFocus, int x, int y, boolean isRunning) {
        if (!isRunning) {
            return;
        }
        for (int index = 0; index < xOffset.length; ++index) {
            int xComponent = x + xOffset[index];
            int yComponent = y + yOffset[index];
            ItemStack stack = reactor.getItemAt(xComponent, yComponent);
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            if (item instanceof ItemIC2reactorLaserFocus) {
                ItemIC2reactorLaserFocus.balanceComponent(itemStackFocus, stack);
                continue;
            }
            if (!(item instanceof IReactorComponent)) continue;
            ItemIC2reactorLaserFocus.coolComponent(itemStackFocus, (IReactorComponent)item, reactor, stack, xComponent, yComponent);
        }
        ItemIC2reactorLaserFocus.coolReactor(reactor, itemStackFocus);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack itemStackFocus, ItemStack pulsingStack, int xFocus, int yFocus, int xPulsing, int yPulsing, boolean isRunning) {
        return false;
    }

    @Optional.Method(modid="IC2")
    public boolean canStoreHeat(IReactor reactor, ItemStack itemStackFocus, int x, int y) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public int getMaxHeat(IReactor reactor, ItemStack itemStackFocus, int x, int y) {
        return WarpDriveConfig.IC2_REACTOR_MAX_HEAT_STORED;
    }

    @Optional.Method(modid="IC2")
    public int getCurrentHeat(IReactor reactor, ItemStack itemStackFocus, int x, int y) {
        return ItemIC2reactorLaserFocus.getCurrentHeat(itemStackFocus);
    }

    @Optional.Method(modid="IC2")
    public int alterHeat(IReactor reactor, ItemStack itemStackFocus, int x, int y, int heat) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("%s alterHeat(reactor %s, x %d, y %d, heat %d)", itemStackFocus, reactor, x, y, heat));
        }
        return ItemIC2reactorLaserFocus.addHeat(itemStackFocus, heat);
    }

    @Optional.Method(modid="IC2")
    public float influenceExplosion(IReactor reactor, ItemStack itemStack) {
        return 0.0f;
    }
}

