/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class ItemShipToken
extends ItemAbstractBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private static ItemStack[] itemStackCache;
    private static final int[] VALID_METADATAS;

    public ItemShipToken() {
        this.func_77627_a(true);
        this.func_77655_b("warpdrive.tool.ship_token");
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        itemStackCache = new ItemStack[VALID_METADATAS.length];
    }

    public static ItemStack getItemStack(int metadataWanted) {
        for (int index = 0; index < VALID_METADATAS.length; ++index) {
            if (metadataWanted != VALID_METADATAS[index]) continue;
            if (itemStackCache[index] == null) {
                ItemShipToken.itemStackCache[index] = new ItemStack((Item)WarpDrive.itemShipToken, 1, metadataWanted);
            }
            return itemStackCache[index];
        }
        return null;
    }

    public static ItemStack getItemStackNoCache(int metadataWanted, int amount) {
        for (int metadataValid : VALID_METADATAS) {
            if (metadataWanted != metadataValid) continue;
            return new ItemStack((Item)WarpDrive.itemShipToken, amount, metadataWanted);
        }
        return new ItemStack((Item)WarpDrive.itemShipToken, amount, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[VALID_METADATAS.length];
        for (int index = 0; index < VALID_METADATAS.length; ++index) {
            this.icons[index] = iconRegister.func_94245_a("warpdrive:tool/ship_token-" + VALID_METADATAS[index]);
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        int metadata = itemStack.func_77960_j();
        for (int metadataValid : VALID_METADATAS) {
            if (metadata != metadataValid) continue;
            return "item.warpdrive.tool.ship_token" + metadata;
        }
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int metadata) {
        for (int index = 0; index < VALID_METADATAS.length; ++index) {
            if (metadata != VALID_METADATAS[index]) continue;
            return this.icons[index];
        }
        return this.icons[0];
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int metadataValid : VALID_METADATAS) {
            list.add(new ItemStack(item, 1, metadataValid));
        }
    }

    public static String getSchematicName(ItemStack itemStack) {
        String schematicName = "" + itemStack.func_77960_j();
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("shipName")) {
            schematicName = tagCompound.func_74779_i("shipName");
        }
        return schematicName;
    }

    public static void setSchematicName(ItemStack itemStack, String schematicName) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        tagCompound.func_74778_a("shipName", schematicName);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean advancedItemTooltips) {
        super.func_77624_a(itemStack, entityPlayer, list, advancedItemTooltips);
        Commons.addTooltip(list, StatCollector.func_74837_a((String)"item.warpdrive.tool.ship_token.tooltip.usage", (Object[])new Object[]{ItemShipToken.getSchematicName(itemStack)}));
    }

    static {
        VALID_METADATAS = new int[]{0, 1, 2, 3, 4, 5, 10, 11, 12, 13, 14, 15, 20, 21, 22, 23, 24, 25, 30, 31, 32, 33, 34, 35, 40, 41, 42, 43, 44, 45};
    }
}

