/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.core.ClassTransformer;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;

public class MessageClientValidation
implements IMessage,
IMessageHandler<MessageClientValidation, IMessage> {
    private String mapClass;

    public void fromBytes(ByteBuf buffer) {
        int size = buffer.readInt();
        this.mapClass = buffer.toString(buffer.readerIndex(), size, Charset.forName("UTF8"));
        buffer.readerIndex(buffer.readerIndex() + size);
    }

    public void toBytes(ByteBuf buffer) {
        String mapClassFull = ClassTransformer.getClientValidation();
        String mapClassTruncated = mapClassFull.substring(0, Math.min(32700, mapClassFull.length()));
        byte[] bytesString = mapClassTruncated.getBytes(Charset.forName("UTF8"));
        buffer.writeInt(bytesString.length);
        buffer.writeBytes(bytesString);
    }

    private void handle(String namePlayer) {
        try {
            if (new File("ClientValidation").exists()) {
                String fileName = String.format("ClientValidation/%s.tsv", namePlayer);
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                printWriter.println(this.mapClass);
                printWriter.close();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            WarpDrive.logger.error("Exception while saving client validation to disk");
        }
    }

    public IMessage onMessage(MessageClientValidation targetingMessage, MessageContext context) {
        if (WarpDrive.isDev) {
            WarpDrive.logger.info("Received client validation packet from %s", new Object[]{context.getServerHandler().field_147369_b.func_70005_c_()});
        }
        targetingMessage.handle(context.getServerHandler().field_147369_b.func_70005_c_());
        return null;
    }
}

