/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CloakedArea;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.MessageBeamEffect;
import cr0s.warpdrive.network.MessageClientSync;
import cr0s.warpdrive.network.MessageClientValidation;
import cr0s.warpdrive.network.MessageCloak;
import cr0s.warpdrive.network.MessageSpawnParticle;
import cr0s.warpdrive.network.MessageTargeting;
import cr0s.warpdrive.network.MessageTransporterEffect;
import cr0s.warpdrive.network.MessageVideoChannel;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.ai.attributes.ServersideAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S04PacketEntityEquipment;
import net.minecraft.network.play.server.S0APacketUseBed;
import net.minecraft.network.play.server.S1BPacketEntityAttach;
import net.minecraft.network.play.server.S1CPacketEntityMetadata;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S20PacketEntityProperties;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PacketHandler {
    private static final SimpleNetworkWrapper simpleNetworkManager = NetworkRegistry.INSTANCE.newSimpleChannel("WarpDrive");
    private static Method EntityTrackerEntry_getPacketForThisEntity;

    public static void init() {
        simpleNetworkManager.registerMessage(MessageBeamEffect.class, MessageBeamEffect.class, 0, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageClientSync.class, MessageClientSync.class, 2, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageCloak.class, MessageCloak.class, 3, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageSpawnParticle.class, MessageSpawnParticle.class, 4, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageVideoChannel.class, MessageVideoChannel.class, 5, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageTransporterEffect.class, MessageTransporterEffect.class, 6, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageTargeting.class, MessageTargeting.class, 100, Side.SERVER);
        simpleNetworkManager.registerMessage(MessageClientValidation.class, MessageClientValidation.class, 101, Side.SERVER);
        try {
            EntityTrackerEntry_getPacketForThisEntity = Class.forName("net.minecraft.entity.EntityTrackerEntry").getDeclaredMethod("func_151260_c", new Class[0]);
            EntityTrackerEntry_getPacketForThisEntity.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void sendBeamPacket(World world, Vector3 v3Source, Vector3 v3Target, float red, float green, float blue, int age, int energy, int radius) {
        assert (!world.field_72995_K);
        MessageBeamEffect messageBeamEffect = new MessageBeamEffect(v3Source, v3Target, red, green, blue, age);
        if (v3Source.distanceTo_square(v3Target) < 3600.0) {
            simpleNetworkManager.sendToAllAround((IMessage)messageBeamEffect, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (v3Source.x + v3Target.x) / 2.0, (v3Source.y + v3Target.y) / 2.0, (v3Source.z + v3Target.z) / 2.0, (double)radius));
        } else {
            List playerEntityList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            int dimensionId = world.field_73011_w.field_76574_g;
            int radius_square = radius * radius;
            for (int index = 0; index < playerEntityList.size(); ++index) {
                EntityPlayerMP entityPlayerMP = (EntityPlayerMP)playerEntityList.get(index);
                if (entityPlayerMP.field_71093_bK != dimensionId || !(v3Source.distanceTo_square((Entity)entityPlayerMP) < (double)radius_square) && !(v3Target.distanceTo_square((Entity)entityPlayerMP) < (double)radius_square)) continue;
                simpleNetworkManager.sendTo((IMessage)messageBeamEffect, entityPlayerMP);
            }
        }
    }

    public static void sendBeamPacketToPlayersInArea(World world, Vector3 source, Vector3 target, float red, float green, float blue, int age, AxisAlignedBB aabb) {
        assert (!world.field_72995_K);
        MessageBeamEffect messageBeamEffect = new MessageBeamEffect(source, target, red, green, blue, age);
        List list = world.func_72872_a(EntityPlayerMP.class, aabb);
        for (Entity entity : list) {
            if (!(entity instanceof EntityPlayerMP)) continue;
            simpleNetworkManager.sendTo((IMessage)messageBeamEffect, (EntityPlayerMP)entity);
        }
    }

    public static void sendSpawnParticlePacket(World world, String type, byte quantity, Vector3 origin, Vector3 direction, float baseRed, float baseGreen, float baseBlue, float fadeRed, float fadeGreen, float fadeBlue, int radius) {
        assert (!world.field_72995_K);
        MessageSpawnParticle messageSpawnParticle = new MessageSpawnParticle(type, quantity, origin, direction, baseRed, baseGreen, baseBlue, fadeRed, fadeGreen, fadeBlue);
        simpleNetworkManager.sendToAllAround((IMessage)messageSpawnParticle, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, origin.x, origin.y, origin.z, (double)radius));
        if (WarpDriveConfig.LOGGING_EFFECTS) {
            WarpDrive.logger.info(String.format("Sent particle effect '%s' x %d from %s toward %s as RGB %.2f %.2f %.2f fading to %.2f %.2f %.2f", type, quantity, origin, direction, Float.valueOf(baseRed), Float.valueOf(baseGreen), Float.valueOf(baseBlue), Float.valueOf(fadeRed), Float.valueOf(fadeGreen), Float.valueOf(fadeBlue)));
        }
    }

    public static void sendTransporterEffectPacket(World world, GlobalPosition globalPositionLocal, GlobalPosition globalPositionRemote, double lockStrength, Collection<MovingEntity> movingEntitiesLocal, Collection<MovingEntity> movingEntitiesRemote, int tickEnergizing, int tickCooldown, int radius) {
        assert (!world.field_72995_K);
        MessageTransporterEffect messageTransporterEffectLocal = new MessageTransporterEffect(true, globalPositionLocal, movingEntitiesLocal, lockStrength, tickEnergizing, tickCooldown);
        MessageTransporterEffect messageTransporterEffectRemote = new MessageTransporterEffect(false, globalPositionRemote, movingEntitiesRemote, lockStrength, tickEnergizing, tickCooldown);
        List playerEntityList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        int radius_square = radius * radius;
        for (int index = 0; index < playerEntityList.size(); ++index) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)playerEntityList.get(index);
            if (globalPositionLocal != null && globalPositionLocal.distance2To((Entity)entityPlayerMP) < (double)radius_square) {
                simpleNetworkManager.sendTo((IMessage)messageTransporterEffectLocal, entityPlayerMP);
            }
            if (globalPositionRemote == null || !(globalPositionRemote.distance2To((Entity)entityPlayerMP) < (double)radius_square)) continue;
            simpleNetworkManager.sendTo((IMessage)messageTransporterEffectRemote, entityPlayerMP);
        }
    }

    public static void sendVideoChannelPacket(int dimensionId, int xCoord, int yCoord, int zCoord, int videoChannel) {
        MessageVideoChannel messageVideoChannel = new MessageVideoChannel(xCoord, yCoord, zCoord, videoChannel);
        simpleNetworkManager.sendToAllAround((IMessage)messageVideoChannel, new NetworkRegistry.TargetPoint(dimensionId, (double)xCoord, (double)yCoord, (double)zCoord, 100.0));
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info("Sent video channel packet (" + xCoord + " " + yCoord + " " + zCoord + ") video channel " + videoChannel);
        }
    }

    public static void sendLaserTargetingPacket(int x, int y, int z, float yaw, float pitch) {
        MessageTargeting messageTargeting = new MessageTargeting(x, y, z, yaw, pitch);
        simpleNetworkManager.sendToServer((IMessage)messageTargeting);
        if (WarpDriveConfig.LOGGING_TARGETING) {
            WarpDrive.logger.info("Sent targeting packet (" + x + " " + y + " " + z + ") yaw " + yaw + " pitch " + pitch);
        }
    }

    public static void sendCloakPacket(EntityPlayerMP entityPlayerMP, CloakedArea area, boolean decloak) {
        MessageCloak messageCloak = new MessageCloak(area, decloak);
        simpleNetworkManager.sendTo((IMessage)messageCloak, entityPlayerMP);
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info("Sent cloak packet (area " + area + " decloak " + decloak + ")");
        }
    }

    public static void sendClientSync(EntityPlayerMP entityPlayerMP, CelestialObject celestialObject) {
        if (WarpDriveConfig.LOGGING_CLIENT_SYNCHRONIZATION) {
            WarpDrive.logger.info(String.format("PacketHandler.sendClientSync %s", entityPlayerMP));
        }
        MessageClientSync messageClientSync = new MessageClientSync(entityPlayerMP, celestialObject);
        simpleNetworkManager.sendTo((IMessage)messageClientSync, entityPlayerMP);
    }

    public static Packet getPacketForThisEntity(Entity entity) {
        EntityTrackerEntry entry = new EntityTrackerEntry(entity, 0, 0, false);
        try {
            return (Packet)EntityTrackerEntry_getPacketForThisEntity.invoke((Object)entry, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WarpDrive.logger.error(String.format("Unable to get packet for entity %s", entity));
            return null;
        }
    }

    public static void revealEntityToPlayer(Entity entity, EntityPlayerMP entityPlayerMP) {
        try {
            EntityPlayer entityplayer;
            ServersideAttributeMap serversideattributemap;
            Collection collection;
            Packet packet = PacketHandler.getPacketForThisEntity(entity);
            if (packet == null) {
                WarpDrive.logger.error(String.format("Unable to reveal entity %s to player %s: null packet", entity, entityPlayerMP));
                return;
            }
            if (WarpDriveConfig.LOGGING_CLOAKING) {
                WarpDrive.logger.info("Revealing entity " + entity + " with packet " + packet);
            }
            entityPlayerMP.field_71135_a.func_147359_a(packet);
            if (!entity.func_70096_w().func_92085_d()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new S1CPacketEntityMetadata(entity.func_145782_y(), entity.func_70096_w(), true));
            }
            if (entity instanceof EntityLivingBase && !(collection = (serversideattributemap = (ServersideAttributeMap)((EntityLivingBase)entity).func_110140_aT()).func_111160_c()).isEmpty()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new S20PacketEntityProperties(entity.func_145782_y(), collection));
            }
            if (entity.field_70154_o != null) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new S1BPacketEntityAttach(0, entity, entity.field_70154_o));
            }
            if (entity instanceof EntityLiving && ((EntityLiving)entity).func_110166_bE() != null) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new S1BPacketEntityAttach(1, entity, ((EntityLiving)entity).func_110166_bE()));
            }
            if (entity instanceof EntityLivingBase) {
                for (int i = 0; i < 5; ++i) {
                    ItemStack itemstack = ((EntityLivingBase)entity).func_71124_b(i);
                    if (itemstack == null) continue;
                    entityPlayerMP.field_71135_a.func_147359_a((Packet)new S04PacketEntityEquipment(entity.func_145782_y(), i, itemstack));
                }
            }
            if (entity instanceof EntityPlayer && (entityplayer = (EntityPlayer)entity).func_70608_bn()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new S0APacketUseBed(entityplayer, MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v)));
            }
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                for (Object object : entitylivingbase.func_70651_bq()) {
                    if (!(object instanceof PotionEffect)) continue;
                    PotionEffect potioneffect = (PotionEffect)object;
                    entityPlayerMP.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(entity.func_145782_y(), potioneffect));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

