/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumCameraType;
import cr0s.warpdrive.render.EntityCamera;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ClientCameraHandler {
    public static boolean isOverlayEnabled = false;
    public static EnumCameraType overlayType = null;
    public static int zoomIndex = 0;
    public static String overlayLoggingMessage = "";
    public static float originalFOV = 70.0f;
    public static float originalSensitivity = 100.0f;
    public static EntityPlayer entityPlayer;
    public static int dimensionId;
    public static int check1_x;
    public static int check1_y;
    public static int check1_z;
    public static Block check1_blockId;
    public static Block check2_blockId;
    public static int check2_x;
    public static int check2_y;
    public static int check2_z;

    public ClientCameraHandler() {
        Minecraft mc = Minecraft.func_71410_x();
        if (WarpDriveConfig.LOGGING_CAMERA) {
            WarpDrive.logger.info("FOV is " + mc.field_71474_y.field_74334_X + " Sensitivity is " + mc.field_71474_y.field_74341_c);
        }
    }

    public static void setupViewpoint(EnumCameraType enumCameraType, EntityPlayer entityPlayer, float initialYaw, float initialPitch, int monitor_x, int monitor_y, int monitor_z, Block blockMonitor, int camera_x, int camera_y, int camera_z, Block blockCamera) {
        Minecraft mc = Minecraft.func_71410_x();
        if (entityPlayer == null) {
            WarpDrive.logger.error("setupViewpoint with null player => denied");
            return;
        }
        originalFOV = mc.field_71474_y.field_74334_X;
        originalSensitivity = mc.field_71474_y.field_74341_c;
        overlayType = enumCameraType;
        ClientCameraHandler.entityPlayer = entityPlayer;
        dimensionId = ClientCameraHandler.entityPlayer.field_70170_p.field_73011_w.field_76574_g;
        check1_x = monitor_x;
        check1_y = monitor_y;
        check1_z = monitor_z;
        check1_blockId = blockMonitor;
        check2_x = camera_x;
        check2_y = camera_y;
        check2_z = camera_z;
        check2_blockId = blockCamera;
        EntityCamera entityCamera = new EntityCamera(ClientCameraHandler.entityPlayer.field_70170_p, camera_x, camera_y, camera_z, ClientCameraHandler.entityPlayer);
        ClientCameraHandler.entityPlayer.field_70170_p.func_72838_d((Entity)entityCamera);
        entityCamera.func_70012_b((double)camera_x + 0.5, (double)camera_y + 0.5, (double)camera_z + 0.5, initialYaw, initialPitch);
        if (WarpDriveConfig.LOGGING_CAMERA) {
            WarpDrive.logger.info("Setting viewpoint to " + (Object)((Object)entityCamera));
        }
        mc.field_71451_h = entityCamera;
        mc.field_71474_y.field_74320_O = 0;
        ClientCameraHandler.refreshViewPoint();
        isOverlayEnabled = true;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    private static void refreshViewPoint() {
        Minecraft mc = Minecraft.func_71410_x();
        switch (zoomIndex) {
            case 0: {
                mc.field_71474_y.field_74334_X = originalFOV;
                mc.field_71474_y.field_74341_c = originalSensitivity / 2.0f;
                break;
            }
            case 1: {
                mc.field_71474_y.field_74334_X = originalFOV / 1.5f;
                mc.field_71474_y.field_74341_c = originalSensitivity / 3.0f;
                break;
            }
            case 2: {
                mc.field_71474_y.field_74334_X = originalFOV / 3.0f;
                mc.field_71474_y.field_74341_c = originalSensitivity / 6.0f;
                break;
            }
            case 3: {
                mc.field_71474_y.field_74334_X = originalFOV / 4.5f;
                mc.field_71474_y.field_74341_c = originalSensitivity / 9.0f;
                break;
            }
            default: {
                mc.field_71474_y.field_74334_X = originalFOV;
                mc.field_71474_y.field_74341_c = originalSensitivity / 2.0f;
            }
        }
    }

    public static void zoom() {
        Minecraft mc = Minecraft.func_71410_x();
        zoomIndex = (zoomIndex + 1) % 4;
        ClientCameraHandler.refreshViewPoint();
        if (WarpDriveConfig.LOGGING_CAMERA) {
            mc.field_71439_g.func_71165_d("changed to fovSetting " + mc.field_71474_y.field_74334_X + " mouseSensitivity " + mc.field_71474_y.field_74341_c);
        }
    }

    public static void resetViewpoint() {
        Minecraft mc = Minecraft.func_71410_x();
        if (entityPlayer != null) {
            mc.field_71451_h = entityPlayer;
            entityPlayer = null;
            if (WarpDriveConfig.LOGGING_CAMERA) {
                WarpDrive.logger.info("Resetting viewpoint");
            }
        } else {
            WarpDrive.logger.error("resetting viewpoint with invalid player entity?");
        }
        Keyboard.enableRepeatEvents((boolean)false);
        isOverlayEnabled = false;
        mc.field_71474_y.field_74320_O = 0;
        mc.field_71474_y.field_74334_X = originalFOV;
        mc.field_71474_y.field_74341_c = originalSensitivity;
        entityPlayer = null;
        dimensionId = -666;
    }

    public static boolean isValidContext(World world) {
        if (world == null || world.field_73011_w.field_76574_g != dimensionId) {
            return false;
        }
        if (!world.func_147439_a(check1_x, check1_y, check1_z).func_149667_c(check1_blockId)) {
            WarpDrive.logger.error("checking viewpoint, found invalid block1 at (" + check1_x + ", " + check1_y + ", " + check1_z + ")");
            return false;
        }
        if (!world.func_147439_a(check2_x, check2_y, check2_z).func_149667_c(check2_blockId)) {
            WarpDrive.logger.error("checking viewpoint, found invalid block2 at (" + check2_x + ", " + check2_y + ", " + check2_z + ")");
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (isOverlayEnabled) {
            ClientCameraHandler.resetViewpoint();
        }
    }

    static {
        dimensionId = -666;
    }
}

