/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.render.AbstractEntityFX;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EntityFXBeam
extends AbstractEntityFX {
    private static final int ROTATION_SPEED = 20;
    private static final float END_MODIFIER = 1.0f;
    private static final ResourceLocation TEXTURE = new ResourceLocation("warpdrive", "textures/particle/energy_grey.png");
    private float length = 0.0f;
    private float rotYaw = 0.0f;
    private float rotPitch = 0.0f;
    private float prevYaw = 0.0f;
    private float prevPitch = 0.0f;
    private float prevSize = 0.0f;

    public EntityFXBeam(World world, Vector3 position, Vector3 target, float red, float green, float blue, int age) {
        super(world, position.x, position.y, position.z, 0.0, 0.0, 0.0);
        this.func_70538_b(red, green, blue);
        this.func_70105_a(0.02f, 0.02f);
        this.field_70145_X = true;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        float xd = (float)(this.field_70165_t - target.x);
        float yd = (float)(this.field_70163_u - target.y);
        float zd = (float)(this.field_70161_v - target.z);
        this.length = (float)new Vector3((Entity)this).distanceTo(target);
        double lengthXZ = MathHelper.func_76133_a((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, lengthXZ) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        this.field_70547_e = age;
        EntityLivingBase entityRender = Minecraft.func_71410_x().field_71451_h;
        int visibleDistance = 300;
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            visibleDistance = 100;
        }
        if (entityRender.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) > (double)visibleDistance) {
            this.field_70547_e = 0;
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialTick, float cosYaw, float cosPitch, float sinYaw, float sinSinPitch, float cosSinPitch) {
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        float rot = (float)(this.field_70170_p.field_73011_w.getWorldTime() % 18L * 20L) + 20.0f * partialTick;
        float sizeTarget = Math.min((float)this.field_70546_d / 4.0f, 1.0f);
        float size = this.prevSize + (sizeTarget - this.prevSize) * partialTick;
        float alpha = 0.5f;
        if (this.field_70547_e - this.field_70546_d <= 4) {
            alpha = 0.5f - (float)(4 - (this.field_70547_e - this.field_70546_d)) * 0.1f;
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2884);
        float relativeTime = (float)this.field_70170_p.func_82737_E() + partialTick;
        float vOffset = -relativeTime * 0.2f - (float)MathHelper.func_76141_d((float)(-relativeTime * 0.1f));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        float xx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTick - field_70556_an);
        float yy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTick - field_70554_ao);
        float zz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTick - field_70555_ap);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        float rotYaw = this.prevYaw + (this.rotYaw - this.prevYaw) * partialTick;
        float rotPitch = this.prevPitch + (this.rotPitch - this.prevPitch) * partialTick;
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f + rotYaw), (float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)rotPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        double xMinStart = -0.15 * (double)size;
        double xMaxStart = 0.15 * (double)size;
        double xMinEnd = -0.15 * (double)size * 1.0;
        double xMaxEnd = 0.15 * (double)size * 1.0;
        double yMax = this.length * size;
        double uMin = 0.0;
        double uMax = 1.0;
        for (int t = 0; t < 3; ++t) {
            double vMin = -1.0f + vOffset + (float)t / 3.0f;
            double vMax = vMin + (double)(this.length * size);
            GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.func_78382_b();
            tessellator.func_78380_c(200);
            tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha);
            tessellator.func_78374_a(xMinEnd, yMax, 0.0, 1.0, vMax);
            tessellator.func_78374_a(xMinStart, 0.0, 0.0, 1.0, vMin);
            tessellator.func_78374_a(xMaxStart, 0.0, 0.0, 0.0, vMin);
            tessellator.func_78374_a(xMaxEnd, yMax, 0.0, 0.0, vMax);
            tessellator.func_78381_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        tessellator.func_78382_b();
        this.prevSize = size;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(new ResourceLocation("textures/particle/particles.png"));
    }
}

