/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.data.EnumDisplayAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderCommons {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private static final float scaleUV = 0.00390625f;
    private static final int TEXT_BORDER = 2;

    protected static int colorGradient(float gradient, int start, int end) {
        return Math.max(0, Math.min(255, start + Math.round(gradient * (float)(end - start))));
    }

    protected static void drawTexturedModalRect(int x, int y, int u, int v, int sizeX, int sizeY, int zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + sizeY), (double)zLevel, (double)(0.00390625f * (float)u), (double)(0.00390625f * (float)(v + sizeY)));
        tessellator.func_78374_a((double)(x + sizeX), (double)(y + sizeY), (double)zLevel, (double)(0.00390625f * (float)(u + sizeX)), (double)(0.00390625f * (float)(v + sizeY)));
        tessellator.func_78374_a((double)(x + sizeX), (double)y, (double)zLevel, (double)(0.00390625f * (float)(u + sizeX)), (double)(0.00390625f * (float)v));
        tessellator.func_78374_a((double)x, (double)y, (double)zLevel, (double)(0.00390625f * (float)u), (double)(0.00390625f * (float)v));
        tessellator.func_78381_a();
    }

    public static int drawSplashAlarm(int scaledWidth, int scaledHeight, String title, String message) {
        double cycle = (double)(System.nanoTime() / 1000L % 0x200000L) / 2097152.0;
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)0.0f);
        int y = scaledHeight / 10;
        String textTitle = Commons.updateEscapeCodes("\u00c2\u00a7l" + StatCollector.func_74838_a((String)title));
        RenderCommons.minecraft.field_71466_p.func_85187_a(textTitle, scaledWidth / 4 - RenderCommons.minecraft.field_71466_p.func_78256_a(textTitle) / 2, y - RenderCommons.minecraft.field_71466_p.field_78288_b, Commons.colorARGBtoInt(230, 255, 32, 24), true);
        String textMessage = Commons.updateEscapeCodes(StatCollector.func_74838_a((String)message));
        int alpha = 160 + (int)(85.0 * Math.sin(cycle * 2.0 * Math.PI));
        List listMessages = RenderCommons.minecraft.field_71466_p.func_78271_c(textMessage, scaledWidth / 2);
        for (String textLine : listMessages) {
            RenderCommons.minecraft.field_71466_p.func_85187_a(textLine, scaledWidth / 4 - RenderCommons.minecraft.field_71466_p.func_78256_a(textLine) / 2, y, Commons.colorARGBtoInt(alpha, 192, 64, 48), false);
            y += RenderCommons.minecraft.field_71466_p.field_78288_b;
        }
        GL11.glPopMatrix();
        return alpha;
    }

    public static void drawText(int screen_width, int screen_height, String text, float scale, String formatPrefix, int colorBackground, int colorText, boolean hasShadow, EnumDisplayAlignment enumScreenAnchor, int xOffset, int yOffset, EnumDisplayAlignment enumTextAlignment, float widthTextRatio, int widthTextMin) {
        String text_formatted = Commons.updateEscapeCodes(formatPrefix + StatCollector.func_74838_a((String)text));
        int scaled_box_width = Math.max(widthTextMin, Math.round(widthTextRatio * (float)screen_width)) + 4;
        List listLines = RenderCommons.minecraft.field_71466_p.func_78271_c(text_formatted, scaled_box_width - 4);
        int scaled_box_height = listLines.size() * RenderCommons.minecraft.field_71466_p.field_78288_b + 4;
        int screen_text_x = Math.round((float)screen_width * enumScreenAnchor.xRatio + (float)xOffset - enumTextAlignment.xRatio * (float)scaled_box_width * scale);
        int screen_text_y = Math.round((float)screen_height * enumScreenAnchor.yRatio + (float)yOffset - enumTextAlignment.yRatio * (float)scaled_box_height * scale);
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)0.0f);
        int scaled_box_x = Math.round((float)screen_text_x / scale - 2.0f);
        int scaled_box_y = Math.round((float)screen_text_y / scale - 2.0f);
        int scaled_text_x = Math.round((float)screen_text_x / scale);
        int scaled_text_y = Math.round((float)screen_text_y / scale);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        byte red = (byte)(colorBackground >> 16 & 0xFF);
        byte blue = (byte)(colorBackground >> 8 & 0xFF);
        byte green = (byte)(colorBackground & 0xFF);
        byte alpha = (byte)(colorBackground >> 24 & 0xFF);
        GL11.glColor4b((byte)red, (byte)blue, (byte)green, (byte)alpha);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)scaled_box_x, (double)(scaled_box_y + scaled_box_height), -90.0);
        tessellator.func_78377_a((double)(scaled_box_x + scaled_box_width), (double)(scaled_box_y + scaled_box_height), -90.0);
        tessellator.func_78377_a((double)(scaled_box_x + scaled_box_width), (double)scaled_box_y, -90.0);
        tessellator.func_78377_a((double)scaled_box_x, (double)scaled_box_y, -90.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        for (String textLine : listLines) {
            RenderCommons.minecraft.field_71466_p.func_85187_a(textLine, scaled_text_x, scaled_text_y, colorText, hasShadow);
            scaled_text_y += RenderCommons.minecraft.field_71466_p.field_78288_b;
        }
        GL11.glPopMatrix();
    }

    public static void drawText(int screen_width, int screen_height, String textHeader, String textContent, float scale, String formatHeader, int colorBackground, int colorText, boolean hasHeaderShadow, EnumDisplayAlignment enumScreenAnchor, int xOffset, int yOffset, EnumDisplayAlignment enumTextAlignment, float widthTextRatio, int widthTextMin) {
        String header_formatted = Commons.updateEscapeCodes(String.format(StatCollector.func_74838_a((String)textHeader), formatHeader));
        String content_formatted = Commons.updateEscapeCodes(StatCollector.func_74838_a((String)textContent));
        int scaled_box_width = Math.max(widthTextMin, Math.round(widthTextRatio * (float)screen_width)) + 4;
        ArrayList listHeaderLines = header_formatted.isEmpty() ? new ArrayList(0) : RenderCommons.minecraft.field_71466_p.func_78271_c(header_formatted, scaled_box_width - 4);
        ArrayList listContentLines = content_formatted.isEmpty() ? new ArrayList(0) : RenderCommons.minecraft.field_71466_p.func_78271_c(content_formatted, scaled_box_width - 4);
        boolean hasTileAndContent = listHeaderLines.size() > 0 && listContentLines.size() > 0;
        int scaled_box_height = (listHeaderLines.size() + listContentLines.size()) * RenderCommons.minecraft.field_71466_p.field_78288_b + (hasTileAndContent ? 3 : 1) * 2;
        int screen_text_x = Math.round((float)screen_width * enumScreenAnchor.xRatio + (float)xOffset - enumTextAlignment.xRatio * (float)scaled_box_width * scale);
        int screen_text_y = Math.round((float)screen_height * enumScreenAnchor.yRatio + (float)yOffset - enumTextAlignment.yRatio * (float)scaled_box_height * scale);
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)0.0f);
        int scaled_box_x = Math.round((float)screen_text_x / scale - 2.0f);
        int scaled_box_y = Math.round((float)screen_text_y / scale - 2.0f);
        int scaled_text_x = Math.round((float)screen_text_x / scale);
        int scaled_text_y = Math.round((float)screen_text_y / scale);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        byte red = (byte)(colorBackground >> 16 & 0xFF);
        byte blue = (byte)(colorBackground >> 8 & 0xFF);
        byte green = (byte)(colorBackground & 0xFF);
        byte alpha = (byte)(colorBackground >> 24 & 0xFF);
        GL11.glColor4b((byte)red, (byte)blue, (byte)green, (byte)alpha);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)scaled_box_x, (double)(scaled_box_y + scaled_box_height), -90.0);
        tessellator.func_78377_a((double)(scaled_box_x + scaled_box_width), (double)(scaled_box_y + scaled_box_height), -90.0);
        tessellator.func_78377_a((double)(scaled_box_x + scaled_box_width), (double)scaled_box_y, -90.0);
        tessellator.func_78377_a((double)scaled_box_x, (double)scaled_box_y, -90.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        for (String textLine : listHeaderLines) {
            RenderCommons.minecraft.field_71466_p.func_85187_a(textLine, scaled_text_x, scaled_text_y, colorText, hasHeaderShadow);
            scaled_text_y += RenderCommons.minecraft.field_71466_p.field_78288_b;
        }
        if (hasTileAndContent) {
            scaled_text_y += 2;
        }
        for (String textLine : listContentLines) {
            RenderCommons.minecraft.field_71466_p.func_85187_a(textLine, scaled_text_x, scaled_text_y, colorText, false);
            scaled_text_y += RenderCommons.minecraft.field_71466_p.field_78288_b;
        }
        GL11.glPopMatrix();
    }

    public static boolean renderWorldBlockCamouflaged(int x, int y, int z, Block blockDefault, RenderBlocks renderer, int renderType, Block blockCamouflage) {
        if (renderType >= 0) {
            try {
                blockCamouflage.func_149719_a(renderer.field_147845_a, x, y, z);
                renderer.func_147775_a(blockCamouflage);
                switch (renderType) {
                    case 0: {
                        renderer.func_147784_q(blockCamouflage, x, y, z);
                        break;
                    }
                    case 1: {
                        renderer.func_147746_l(blockCamouflage, x, y, z);
                        break;
                    }
                    case 2: {
                        renderer.func_147791_c(blockCamouflage, x, y, z);
                        break;
                    }
                    case 3: {
                        renderer.func_147801_a((BlockFire)blockCamouflage, x, y, z);
                        break;
                    }
                    case 5: {
                        renderer.func_147788_h(blockCamouflage, x, y, z);
                        break;
                    }
                    case 6: {
                        renderer.func_147796_n(blockCamouflage, x, y, z);
                        break;
                    }
                    case 9: {
                        renderer.func_147766_a((BlockRailBase)blockCamouflage, x, y, z);
                        break;
                    }
                    case 10: {
                        renderer.func_147722_a((BlockStairs)blockCamouflage, x, y, z);
                        break;
                    }
                    case 11: {
                        renderer.func_147735_a((BlockFence)blockCamouflage, x, y, z);
                        break;
                    }
                    case 12: {
                        renderer.func_147790_e(blockCamouflage, x, y, z);
                        break;
                    }
                    case 13: {
                        renderer.func_147755_t(blockCamouflage, x, y, z);
                        break;
                    }
                    case 14: {
                        renderer.func_147773_v(blockCamouflage, x, y, z);
                        break;
                    }
                    case 15: {
                        renderer.func_147759_a((BlockRedstoneRepeater)blockCamouflage, x, y, z);
                        break;
                    }
                    case 16: {
                        renderer.func_147731_b(blockCamouflage, x, y, z, false);
                        break;
                    }
                    case 17: {
                        renderer.func_147809_c(blockCamouflage, x, y, z, true);
                        break;
                    }
                    case 18: {
                        renderer.func_147767_a((BlockPane)blockCamouflage, x, y, z);
                        break;
                    }
                    case 20: {
                        renderer.func_147726_j(blockCamouflage, x, y, z);
                        break;
                    }
                    case 21: {
                        renderer.func_147776_a((BlockFenceGate)blockCamouflage, x, y, z);
                        break;
                    }
                    case 23: {
                        renderer.func_147783_o(blockCamouflage, x, y, z);
                        break;
                    }
                    case 24: {
                        renderer.func_147785_a((BlockCauldron)blockCamouflage, x, y, z);
                        break;
                    }
                    case 25: {
                        renderer.func_147741_a((BlockBrewingStand)blockCamouflage, x, y, z);
                        break;
                    }
                    case 26: {
                        renderer.func_147743_a((BlockEndPortalFrame)blockCamouflage, x, y, z);
                        break;
                    }
                    case 27: {
                        renderer.func_147802_a((BlockDragonEgg)blockCamouflage, x, y, z);
                        break;
                    }
                    case 28: {
                        renderer.func_147772_a((BlockCocoa)blockCamouflage, x, y, z);
                        break;
                    }
                    case 29: {
                        renderer.func_147723_f(blockCamouflage, x, y, z);
                        break;
                    }
                    case 30: {
                        renderer.func_147756_g(blockCamouflage, x, y, z);
                        break;
                    }
                    case 31: {
                        renderer.func_147742_r(blockCamouflage, x, y, z);
                        break;
                    }
                    case 32: {
                        renderer.func_147807_a((BlockWall)blockCamouflage, x, y, z);
                        break;
                    }
                    case 33: {
                        renderer.func_147752_a((BlockFlowerPot)blockCamouflage, x, y, z);
                        break;
                    }
                    case 34: {
                        renderer.func_147797_a((BlockBeacon)blockCamouflage, x, y, z);
                        break;
                    }
                    case 35: {
                        renderer.func_147725_a((BlockAnvil)blockCamouflage, x, y, z);
                        break;
                    }
                    case 36: {
                        renderer.func_147748_a((BlockRedstoneDiode)blockCamouflage, x, y, z);
                        break;
                    }
                    case 37: {
                        renderer.func_147781_a((BlockRedstoneComparator)blockCamouflage, x, y, z);
                        break;
                    }
                    case 38: {
                        renderer.func_147803_a((BlockHopper)blockCamouflage, x, y, z);
                        break;
                    }
                    case 39: {
                        renderer.func_147779_s(blockCamouflage, x, y, z);
                        break;
                    }
                    case 41: {
                        renderer.func_147733_k(blockCamouflage, x, y, z);
                        break;
                    }
                    default: {
                        WarpDrive.logger.error("Disabling camouflage with block " + Block.field_149771_c.func_148750_c((Object)blockCamouflage) + " due to invalid renderType " + renderType);
                        Dictionary.BLOCKS_NOCAMOUFLAGE.add(blockCamouflage);
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                WarpDrive.logger.error("Disabling camouflage block " + Block.field_149771_c.func_148750_c((Object)blockCamouflage) + " due to previous exception");
                Dictionary.BLOCKS_NOCAMOUFLAGE.add(blockCamouflage);
                renderer.func_147784_q(blockDefault, x, y, z);
            }
            return true;
        }
        return renderer.func_147784_q(blockDefault, x, y, z);
    }

    public static void renderInventoryBlock(Block block, int metadata, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        IIcon iicon = renderer.func_147787_a(block, 0, metadata);
        renderer.func_147765_a(iicon, -0.5, -0.5, -0.5, 1.0f);
        tessellator.func_78381_a();
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

