/*
 * Decompiled with CFR 0.152.
 */
package com.sr2610.creeperConfetti;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.living.LivingEvent;

public class ConfettiHandler {
    public static final String[] TIME_SINCE_IGNITED = new String[]{"timeSinceIgnited", "field_70833_d", "bq"};
    public static final String[] FUSE_TIME = new String[]{"fuseTime", "field_82225_f", "br"};
    private static Random rand = new Random();

    @SubscribeEvent
    public void creeperExplodeEvent(LivingEvent.LivingUpdateEvent event) {
        int fuse;
        int ignited;
        if (event.entityLiving instanceof EntityCreeper && ((EntityCreeper)event.entity).func_70832_p() == 1 && (ignited = ((Integer)ReflectionHelper.getPrivateValue(EntityCreeper.class, (Object)((EntityCreeper)event.entity), (String[])TIME_SINCE_IGNITED)).intValue()) >= (fuse = ((Integer)ReflectionHelper.getPrivateValue(EntityCreeper.class, (Object)((EntityCreeper)event.entity), (String[])FUSE_TIME)).intValue()) - 1) {
            if (!event.entityLiving.field_70170_p.field_72995_K) {
                Random rand = new Random();
                for (int i = 0; i <= rand.nextInt(3) + 4; ++i) {
                    ItemStack firework = ConfettiHandler.randomFirework();
                    event.entityLiving.field_70170_p.func_72838_d((Entity)new EntityFireworkRocket(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t + rand.nextDouble() * 6.0 - 5.0, event.entityLiving.field_70163_u + 1.0, event.entityLiving.field_70161_v + rand.nextDouble() * 6.0 - 5.0, firework));
                }
            }
            event.entityLiving.func_70106_y();
        }
    }

    public static ItemStack randomFirework() {
        Random rand = new Random();
        Firework firework = new Firework();
        switch (rand.nextInt(3)) {
            case 0: {
                firework.setFlicker();
                break;
            }
            case 1: {
                firework.setTrail();
            }
        }
        int type = rand.nextInt(5);
        if (type != 3) {
            firework.setType(type);
        } else {
            firework.setType(1);
        }
        for (int i = 0; i <= rand.nextInt(6); ++i) {
            Color randomColor = ConfettiHandler.getRandomColor();
            firework.addColor(randomColor.getRed(), randomColor.getGreen(), randomColor.getBlue());
        }
        return firework.getStack();
    }

    public static Color getRandomColor() {
        return new Color(Color.HSBtoRGB(rand.nextFloat() * 360.0f, rand.nextFloat() * 0.15f + 0.8f, 0.85f));
    }

    public static class Firework {
        int flight = 0;
        boolean flicker = false;
        boolean trail = false;
        ArrayList<Integer> colors = new ArrayList();
        FireworkType type = FireworkType.BALL;

        public Firework setFlight(int duration) {
            if (duration >= 0 && duration <= 3) {
                this.flight = duration;
            }
            return this;
        }

        public Firework setFlicker() {
            this.flicker = true;
            return this;
        }

        public Firework setTrail() {
            this.trail = true;
            return this;
        }

        public Firework setType(FireworkType type) {
            this.type = type;
            return this;
        }

        public Firework setType(int type) {
            if (type >= 0 && type <= 4) {
                this.type = FireworkType.values()[type];
            }
            return this;
        }

        public Firework addColor(int red, int green, int blue) {
            this.colors.add((red << 16) + (green << 8) + blue);
            return this;
        }

        private NBTTagCompound getTags() {
            NBTTagCompound explosionTag = new NBTTagCompound();
            explosionTag.func_74757_a("Flicker", this.flicker);
            explosionTag.func_74757_a("Trail", this.trail);
            explosionTag.func_74774_a("Type", (byte)this.type.ordinal());
            int[] intArray = new int[this.colors.size()];
            for (int i = 0; i < this.colors.size(); ++i) {
                intArray[i] = this.colors.get(i);
            }
            explosionTag.func_74783_a("Colors", intArray);
            return explosionTag;
        }

        public ItemStack getStack() {
            NBTTagCompound tags = new NBTTagCompound();
            NBTTagCompound fireworksTag = new NBTTagCompound();
            NBTTagList explosionsList = new NBTTagList();
            explosionsList.func_74742_a((NBTBase)this.getTags());
            fireworksTag.func_74774_a("Flight", (byte)-10);
            fireworksTag.func_74782_a("Explosions", (NBTBase)explosionsList);
            tags.func_74782_a("Fireworks", (NBTBase)fireworksTag);
            ItemStack stack = new ItemStack(Items.field_151152_bP);
            stack.func_77982_d(tags);
            return stack;
        }
    }

    public static enum FireworkType {
        BALL,
        LARGE_BALL,
        STAR,
        CREEPER,
        BURST;

    }
}

