/*
 * Decompiled with CFR 0.152.
 */
package com.sr2610.creeperconfetti;

import com.google.common.collect.Lists;
import com.sr2610.creeperconfetti.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemDye;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.Explosion;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConfettiHandler {
    public static final String[] TIME_SINCE_IGNITED = new String[]{"timeSinceIgnited", "field_70833_d", "bq"};
    public static final String[] FUSE_TIME = new String[]{"fuseTime", "field_82225_f", "br"};

    @SubscribeEvent
    public void creeperExplodeEvent(LivingEvent.LivingUpdateEvent event) {
        int fuseTime;
        int ignitedTime;
        EntityCreeper creeper = null;
        if (event.getEntityLiving() instanceof EntityCreeper) {
            creeper = (EntityCreeper)event.getEntityLiving();
        }
        if (creeper != null && creeper.func_70832_p() == 1 && (ignitedTime = ((Integer)ReflectionHelper.getPrivateValue(EntityCreeper.class, (Object)creeper, (String[])TIME_SINCE_IGNITED)).intValue()) >= (fuseTime = ((Integer)ReflectionHelper.getPrivateValue(EntityCreeper.class, (Object)creeper, (String[])FUSE_TIME)).intValue()) - 1 && this.willExplodeToConfetti()) {
            creeper.field_70170_p.func_184148_a((EntityPlayer)null, creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v, SoundEvents.field_187637_bq, SoundCategory.BLOCKS, 0.5f, (1.0f + (creeper.field_70170_p.field_73012_v.nextFloat() - creeper.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            if (creeper.field_70170_p.field_72995_K) {
                this.spawnParticles(creeper);
            }
            creeper.func_70106_y();
            if (ConfigHandler.damagesPlayers) {
                this.damagePlayers(creeper);
            }
        }
    }

    private boolean willExplodeToConfetti() {
        Random rand = new Random();
        return rand.nextInt(100) < ConfigHandler.confettiChance && ConfigHandler.confettiChance != 0;
    }

    private void damagePlayers(EntityCreeper creeper) {
        float explosionStrength = creeper.func_70830_n() ? 2.0f : 1.0f;
        Explosion explosion = new Explosion(creeper.field_70170_p, (Entity)creeper, creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v, 3.0f * explosionStrength, false, false);
        explosion.func_77278_a();
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EntityCreeper creeper) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleFirework.Starter(creeper.field_70170_p, creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v, 0.0, 0.0, 0.0, Minecraft.func_71410_x().field_71452_i, this.generateTag()));
    }

    private NBTTagCompound generateTag() {
        NBTTagCompound fireworkTag = new NBTTagCompound();
        new NBTTagCompound();
        NBTTagCompound fireworkItemTag = new NBTTagCompound();
        new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        new NBTTagList();
        ArrayList list = Lists.newArrayList();
        Random rand = new Random();
        list.add(ItemDye.field_150922_c[1]);
        list.add(ItemDye.field_150922_c[11]);
        list.add(ItemDye.field_150922_c[4]);
        for (int i = 0; i < rand.nextInt(3) + 3; ++i) {
            list.add(ItemDye.field_150922_c[rand.nextInt(15)]);
        }
        int[] colours = new int[list.size()];
        for (int i = 0; i < colours.length; ++i) {
            colours[i] = (Integer)list.get(i);
        }
        fireworkTag.func_74783_a("Colors", colours);
        fireworkTag.func_74757_a("Flicker", true);
        fireworkTag.func_74774_a("Type", (byte)4);
        nbttaglist.func_74742_a((NBTBase)fireworkTag);
        fireworkItemTag.func_74782_a("Explosions", (NBTBase)nbttaglist);
        return fireworkItemTag;
    }
}

