/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.proxy;

import bre.fpsreducer.Command;
import bre.fpsreducer.KeyBindEventHandler;
import bre.fpsreducer.OverlayEventHandler;
import bre.fpsreducer.WakeupEventHandler;
import bre.fpsreducer.WorldLoadEventHandler;
import bre.fpsreducer.config.CommonConfig;
import bre.fpsreducer.config.GlobalConfig;
import bre.fpsreducer.config.OldConfig;
import bre.fpsreducer.config.PlayerConfig;
import bre.fpsreducer.gui.GuiHandler;
import bre.fpsreducer.mod_FpsReducer;
import bre.fpsreducer.proxy.CommonProxy;
import bre.fpsreducer.utils.Logger;
import bre.fpsreducer.utils.ModLib;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.codec.digest.DigestUtils;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static KeyBinding openGuiKey = new KeyBinding("FpsReducer.key.guiOpen", 207, "key.categories.FpsReducer");
    private File configDirectory;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Logger.init(event);
        this.configDirectory = event.getModConfigurationDirectory();
        File globalConfigFile = new File(this.configDirectory, "fpsreducer" + File.separator + "fpsreducer" + ".cfg");
        boolean existsGlobalConfig = globalConfigFile.exists();
        CommonConfig.globalConfig = new GlobalConfig(globalConfigFile);
        CommonConfig.currentConfig = CommonConfig.globalConfig;
        File oldConfigFile = event.getSuggestedConfigurationFile();
        if (oldConfigFile.exists()) {
            if (!existsGlobalConfig) {
                OldConfig.readConfig(oldConfigFile);
                CommonConfig.globalConfig.enableFpsReducer = OldConfig.enableFpsReducer;
                CommonConfig.globalConfig.waitingTime = OldConfig.waitingTime;
                CommonConfig.globalConfig.idleFPS = OldConfig.idleFPS;
                CommonConfig.globalConfig.debugLog = OldConfig.debugLog;
                CommonConfig.globalConfig.logInChat = OldConfig.chatMsg;
                CommonConfig.globalConfig.ignoreHoldButton = OldConfig.ignoreHoldButton;
                CommonConfig.globalConfig.reducingInBackground = OldConfig.reducingInBackground;
                CommonConfig.globalConfig.suppressSound = OldConfig.suppressSound;
                CommonConfig.globalConfig.suppressedVolume = OldConfig.suppressedVolume;
                CommonConfig.globalConfig.hudLocation = OldConfig.hudLocation;
                CommonConfig.globalConfig.hudMarginX = OldConfig.hudMarginX;
                CommonConfig.globalConfig.hudMarginY = OldConfig.hudMarginY;
                CommonConfig.globalConfig.hudColorRed = OldConfig.hudColorRed;
                CommonConfig.globalConfig.hudColorGreen = OldConfig.hudColorGreen;
                CommonConfig.globalConfig.hudColorBlue = OldConfig.hudColorBlue;
                CommonConfig.globalConfig.saveConfig();
            }
            File oldConfigBackup = new File(this.configDirectory, "fpsreducer" + File.separator + "oldConfig.bak");
            try {
                if (oldConfigBackup.exists()) {
                    oldConfigBackup.delete();
                }
                oldConfigFile.renameTo(oldConfigBackup);
            }
            catch (Exception e) {
                Logger.error("Configuration file access error. (OldConfig)");
                e.printStackTrace();
            }
        }
        if (CommonConfig.globalConfig.enablePerPlayerConfig) {
            String playerHashStr = ModLib.checkDevEnv() ? "debugDummy" : DigestUtils.md5Hex((String)Minecraft.func_71410_x().func_110432_I().func_148255_b());
            PlayerConfig.playerConfigFile = new File(this.configDirectory, "fpsreducer" + File.separator + "player-" + playerHashStr + ".cfg");
            if (PlayerConfig.playerConfigFile.exists() || CommonConfig.globalConfig.inquireInitSetting) {
                PlayerConfig.readPlayerConfig();
                if (CommonConfig.globalConfig.inquireInitSetting && CommonConfig.playerConfig.inquireInitSetting) {
                    CommonConfig.playerConfig.usePlayerConfig = true;
                    CommonConfig.currentConfig = CommonConfig.playerConfig;
                    CommonConfig.saveCurrentConfig();
                }
            }
        }
        super.preInit(event);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)mod_FpsReducer.instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldLoadEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OverlayEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WakeupEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new KeyBindEventHandler());
        ClientRegistry.registerKeyBinding((KeyBinding)openGuiKey);
        ClientCommandHandler.instance.func_71560_a((ICommand)Command.INSTANCE);
        super.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }
}

