/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.gui;

import bre.fpsreducer.gui.GuiSliderFix;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiSliderFlexibleTime
extends GuiSliderFix {
    private static final int MAXVAL;
    private static final int[] minSec;
    private static final int[] maxSec;
    private static final int[] minVal;
    private static final int[] maxVal;

    public static GuiSliderFlexibleTime getInstance(int id, int xPos, int yPos, int width, int height, String prefix, int currentSec, GuiSlider.ISlider sliderAction) {
        double currentVal = GuiSliderFlexibleTime.time2Val(currentSec);
        GuiSliderFlexibleTime instance = new GuiSliderFlexibleTime(id, xPos, yPos, width, height, prefix, currentVal, sliderAction);
        return instance;
    }

    private GuiSliderFlexibleTime(int id, int xPos, int yPos, int width, int height, String prefix, double currentVal, GuiSlider.ISlider sliderAction) {
        super(id, xPos, yPos, width, height, prefix, null, 1.0, MAXVAL, currentVal, false, true, sliderAction);
        this.setText(this.val2Time(currentVal));
    }

    public void func_146118_a(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
        this.parent.onChangeSliderValue((GuiSlider)this);
    }

    private void setText(int time) {
        if (this.drawString) {
            this.field_146126_j = time == 0 ? this.dispString + I18n.func_135052_a((String)"fpsreducer.config.OFF", (Object[])new Object[0]) : String.format("%s%02d:%02d", this.dispString, time / 60, time % 60);
        }
    }

    public void updateSlider() {
        super.updateSlider();
        int time = this.getTimeSec();
        this.setText(time);
    }

    public int getTimeSec() {
        int val = this.getValueInt();
        return this.val2Time(val);
    }

    private int val2Time(double val) {
        if (val == (double)MAXVAL) {
            return 0;
        }
        int idx = 0;
        for (int i = 0; i < maxVal.length; ++i) {
            if (!(val <= (double)maxVal[i])) continue;
            idx = i;
            break;
        }
        double time = (double)minSec[idx] + (val - (double)minVal[idx]) * ((double)(maxSec[idx] - minSec[idx]) / (double)(maxVal[idx] - minVal[idx]));
        return (int)Math.round(time);
    }

    private static double time2Val(int sec) {
        if (sec == 0) {
            return MAXVAL;
        }
        int idx = 0;
        for (int i = 0; i < maxSec.length; ++i) {
            if (sec > maxSec[i]) continue;
            idx = i;
            break;
        }
        double val = (double)(sec - minSec[idx]) / (double)(maxSec[idx] - minSec[idx]) * (double)(maxVal[idx] - minVal[idx]) + (double)minVal[idx];
        return val;
    }

    static {
        minSec = new int[]{1, 15, 90, 360, 900};
        maxSec = new int[]{10, 60, 300, 600, 3900};
        minVal = new int[]{1, 11, 21, 29, 34};
        int[] nArray = new int[5];
        nArray[0] = 10;
        nArray[1] = 20;
        nArray[2] = 28;
        nArray[3] = 33;
        MAXVAL = 44;
        nArray[4] = 44;
        maxVal = nArray;
    }
}

