/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.gui;

import bre.fpsreducer.config.CommonConfig;
import bre.fpsreducer.gui.HudPos;
import bre.fpsreducer.handler.GuiOpenEventHandler;
import bre.fpsreducer.handler.WakeupEventHandler;
import bre.fpsreducer.utils.GlUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class Hud
extends Gui {
    private String text;
    private float scaledPosX;
    private float scaledPosY;
    private int hudColor;
    private int hudIdleColor;
    private Minecraft mc = Minecraft.func_71410_x();
    private FontRenderer fontRenderer;
    private boolean hovered;
    private int dragOffsetX;
    private int dragOffsetY;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private int curFPS;
    private double cpuLoad;
    private static Hud INSTANCE = new Hud();
    private String hudLine1;
    private String hudLine1Eco;
    private String hudLine2;
    private int hudLine1OffsetX;
    private int hudLine1EcoOffsetX;
    private int hudLine2OffsetX;

    public Hud() {
        this.fontRenderer = this.mc.field_71466_p;
        this.hudColor = CommonConfig.globalConfig.hudColorRed << 16 | CommonConfig.globalConfig.hudColorGreen << 8 | CommonConfig.globalConfig.hudColorBlue;
        this.hudIdleColor = CommonConfig.globalConfig.hudReductionColorRed << 16 | CommonConfig.globalConfig.hudReductionColorGreen << 8 | CommonConfig.globalConfig.hudReductionColorBlue;
    }

    public static Hud getInstance() {
        return INSTANCE;
    }

    public void setFPSCPUData(int fps, double cpuload) {
        this.curFPS = fps;
        this.cpuLoad = cpuload;
    }

    public void drawHud(int scaledWidth, int scaledHeight) {
        float scale = (float)CommonConfig.currentConfig.hudScale;
        this.updatePosition(scaledWidth, scaledHeight, scale);
        if (scale != 1.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        }
        if (WakeupEventHandler.reduceFPS) {
            this.fontRenderer.func_175063_a(this.hudLine1Eco, (float)((int)this.scaledPosX + this.hudLine1EcoOffsetX), (float)((int)this.scaledPosY), this.hudIdleColor);
        } else {
            this.fontRenderer.func_175063_a(this.hudLine1, (float)((int)this.scaledPosX + this.hudLine1OffsetX), (float)((int)this.scaledPosY), this.hudColor);
        }
        if (CommonConfig.currentConfig.hudInfo == 3) {
            this.fontRenderer.func_175063_a(this.hudLine2, (float)((int)this.scaledPosX + this.hudLine2OffsetX), (float)((int)this.scaledPosY + this.fontRenderer.field_78288_b), this.hudColor);
        }
        if (scale != 1.0f) {
            GlStateManager.func_179121_F();
        }
    }

    public void updateBoxPosition(int screenWidth, int screenHeight) {
        int hudBoxOffsetX;
        String hudStr;
        float scale = (float)CommonConfig.currentConfig.hudScale;
        switch (CommonConfig.currentConfig.hudInfo) {
            case 1: {
                hudStr = "FPS: 000, CPU: 000%";
                break;
            }
            case 2: {
                hudStr = "000, 000%";
                break;
            }
            default: {
                hudStr = "CPU: 000%";
            }
        }
        int hudBoxHeight = CommonConfig.currentConfig.hudInfo == 3 ? this.fontRenderer.field_78288_b * 2 - 2 : this.fontRenderer.field_78288_b - 2;
        int hudBoxWidth = this.fontRenderer.func_78256_a(hudStr) - 1;
        switch (CommonConfig.currentConfig.curHudPos.alignment) {
            default: {
                hudBoxOffsetX = 0;
                break;
            }
            case 1: {
                hudBoxOffsetX = -hudBoxWidth;
                break;
            }
            case 2: {
                hudBoxOffsetX = -hudBoxWidth / 2;
            }
        }
        this.updatePosition(screenWidth, screenHeight, scale);
        this.x1 = Math.round((this.scaledPosX + (float)hudBoxOffsetX) * scale + (float)this.dragOffsetX);
        this.x2 = Math.round((this.scaledPosX + (float)hudBoxOffsetX) * scale + (float)this.dragOffsetX + (float)hudBoxWidth * scale);
        this.y1 = Math.round(this.scaledPosY * scale + (float)this.dragOffsetY);
        this.y2 = Math.round(this.scaledPosY * scale + (float)this.dragOffsetY + (float)hudBoxHeight * scale);
    }

    public void drawHudBox(int screenWidth, int screenHeight, int mouseX, int mouseY, boolean dragging) {
        if (CommonConfig.currentConfig.hudInfo == 0) {
            return;
        }
        this.hovered = mouseX >= this.x1 && mouseX <= this.x2 && mouseY >= this.y1 && mouseY <= this.y2;
        int color = this.hovered || dragging ? -65281 : -1;
        this.drawLineToHudBox(screenWidth, screenHeight);
        this.drawRectFrame(this.x1, this.y1, this.x2, this.y2, color);
    }

    public void drawLineToHudBox(int screenWidth, int screenHeight) {
        int alignedX;
        if (CommonConfig.currentConfig.hudInfo == 0) {
            return;
        }
        float zLevel = -10.0f;
        float lineWidth = 0.5f;
        switch (CommonConfig.currentConfig.curHudPos.alignment) {
            default: {
                alignedX = this.x1;
                break;
            }
            case 1: {
                alignedX = this.x2;
                break;
            }
            case 2: {
                alignedX = Math.round((float)(this.x1 + this.x2) / 2.0f);
            }
        }
        GlUtils.pushState();
        GlUtils.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        switch (CommonConfig.currentConfig.getHudReferencePos()) {
            case 1: {
                GlUtils.drawLine(0, 0, alignedX, this.y1, zLevel, lineWidth);
                break;
            }
            case 2: {
                GlUtils.drawLine(Math.round((float)screenWidth / 2.0f), 0, alignedX, this.y1, zLevel, lineWidth);
                break;
            }
            case 3: {
                GlUtils.drawLine(screenWidth, 0, alignedX, this.y1, zLevel, lineWidth);
                break;
            }
            case 4: {
                GlUtils.drawLine(screenWidth, Math.round((float)screenHeight / 2.0f), alignedX, Math.round((float)(this.y1 + this.y2) / 2.0f), zLevel, lineWidth);
                break;
            }
            case 5: {
                GlUtils.drawLine(screenWidth, screenHeight, alignedX, this.y2, zLevel, lineWidth);
                break;
            }
            case 6: {
                GlUtils.drawLine(Math.round((float)screenWidth / 2.0f), screenHeight, alignedX, this.y2, zLevel, lineWidth);
                break;
            }
            case 7: {
                GlUtils.drawLine(0, screenHeight, alignedX, this.y2, zLevel, lineWidth);
                break;
            }
            case 8: {
                GlUtils.drawLine(0, Math.round((float)screenHeight / 2.0f), alignedX, Math.round((float)(this.y1 + this.y2) / 2.0f), zLevel, lineWidth);
            }
        }
        GlUtils.popState();
    }

    public void updateHudText() {
        switch (CommonConfig.currentConfig.hudInfo) {
            case 5: {
                this.hudLine1Eco = this.hudLine1 = "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                break;
            }
            case 1: {
                this.hudLine1 = CommonConfig.globalConfig.hudPreText + this.curFPS + ", " + "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Eco = CommonConfig.globalConfig.hudReductionPreText + this.curFPS + ", " + "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                break;
            }
            case 2: {
                String commonStr;
                this.hudLine1 = commonStr = "" + this.curFPS + ", " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Eco = commonStr;
                break;
            }
            case 3: {
                this.hudLine2 = "CPU: " + this.cpuLoadValStr(this.cpuLoad);
            }
            case 4: {
                this.hudLine1 = CommonConfig.globalConfig.hudPreText + this.curFPS;
                this.hudLine1Eco = CommonConfig.globalConfig.hudReductionPreText + this.curFPS;
            }
        }
        this.updateAlignOffset();
    }

    private String cpuLoadValStr(double cpuload) {
        if (cpuload < 0.0) {
            return "n/a";
        }
        if (cpuload < 10.0) {
            return String.valueOf((float)((int)(cpuload * 10.0)) / 10.0f) + "%";
        }
        return String.valueOf((int)cpuload) + "%";
    }

    public void updateAlignOffset() {
        switch (CommonConfig.currentConfig.curHudPos.alignment) {
            default: {
                this.hudLine1OffsetX = 0;
                this.hudLine1EcoOffsetX = 0;
                this.hudLine2OffsetX = 0;
                break;
            }
            case 1: {
                this.hudLine1OffsetX = -this.fontRenderer.func_78256_a(this.hudLine1);
                this.hudLine1EcoOffsetX = -this.fontRenderer.func_78256_a(this.hudLine1Eco);
                if (CommonConfig.currentConfig.hudInfo != 3) break;
                this.hudLine2OffsetX = -this.fontRenderer.func_78256_a(this.hudLine2);
                int minX = this.hudLine1EcoOffsetX;
                minX = Math.min(minX, this.hudLine1OffsetX);
                this.hudLine2OffsetX = this.hudLine1EcoOffsetX = (minX = Math.min(minX, this.hudLine2OffsetX));
                this.hudLine1OffsetX = this.hudLine1EcoOffsetX;
                break;
            }
            case 2: {
                this.hudLine1OffsetX = -this.fontRenderer.func_78256_a(this.hudLine1) / 2;
                this.hudLine1EcoOffsetX = -this.fontRenderer.func_78256_a(this.hudLine1Eco) / 2;
                if (CommonConfig.currentConfig.hudInfo != 3) break;
                this.hudLine2OffsetX = -this.fontRenderer.func_78256_a(this.hudLine2) / 2;
                int minX = this.hudLine1EcoOffsetX;
                minX = Math.min(minX, this.hudLine1OffsetX);
                this.hudLine2OffsetX = this.hudLine1EcoOffsetX = (minX = Math.min(minX, this.hudLine2OffsetX));
                this.hudLine1OffsetX = this.hudLine1EcoOffsetX;
            }
        }
    }

    public void update() {
        this.updateHudText();
        this.updateAlignOffset();
    }

    private void updatePosition(int screenWidth, int screenHeight, float scale) {
        HudPos hudPos = CommonConfig.currentConfig.curHudPos;
        int boxHeight = CommonConfig.currentConfig.hudInfo == 3 ? this.fontRenderer.field_78288_b * 2 : this.fontRenderer.field_78288_b;
        block0 : switch (CommonConfig.currentConfig.getHudReferencePos()) {
            case 1: {
                this.scaledPosX = (float)hudPos.offsetX / scale;
                this.scaledPosY = (float)hudPos.offsetY / scale;
                break;
            }
            case 2: {
                this.scaledPosX = (float)(screenWidth / 2 + hudPos.offsetX) / scale;
                this.scaledPosY = (float)hudPos.offsetY / scale;
                break;
            }
            case 3: {
                this.scaledPosX = (float)(screenWidth + hudPos.offsetX) / scale;
                this.scaledPosY = (float)hudPos.offsetY / scale;
                break;
            }
            case 4: {
                this.scaledPosX = (float)(screenWidth + hudPos.offsetX) / scale;
                this.scaledPosY = (float)(screenHeight / 2 + hudPos.offsetY) / scale - (float)(boxHeight / 2);
                break;
            }
            case 5: {
                this.scaledPosX = (float)(screenWidth + hudPos.offsetX) / scale;
                this.scaledPosY = (float)(screenHeight + hudPos.offsetY) / scale - (float)(boxHeight - 1);
                break;
            }
            case 6: {
                this.scaledPosX = (float)(screenWidth / 2 + hudPos.offsetX) / scale;
                this.scaledPosY = (float)(screenHeight + hudPos.offsetY) / scale - (float)(boxHeight - 1);
                break;
            }
            case 7: {
                float dodgeY;
                this.scaledPosX = (float)hudPos.offsetX / scale;
                this.scaledPosY = (float)(screenHeight + hudPos.offsetY) / scale - (float)(boxHeight - 1);
                if (!GuiOpenEventHandler.guiChatOpened || !(this.scaledPosY > (dodgeY = (float)(screenHeight - 15) / scale - (float)(boxHeight - 1)))) break;
                switch (CommonConfig.currentConfig.hudBehindChatBox) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        this.scaledPosY = dodgeY;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                this.scaledPosX = (float)hudPos.offsetX / scale;
                this.scaledPosY = (float)(screenHeight / 2 + hudPos.offsetY) / scale - (float)(boxHeight / 2);
                break;
            }
        }
    }

    private void drawRectFrame(int posX1, int posY1, int posX2, int posY2, int color) {
        this.func_73730_a(posX1, posX2, posY1, color);
        this.func_73730_a(posX1, posX2, posY2, color);
        this.func_73728_b(posX1, posY1, posY2, color);
        this.func_73728_b(posX2, posY1, posY2, color);
    }

    public int getPosX() {
        return this.x1;
    }

    public int getPosY() {
        return this.y1;
    }

    public void setPos(int x, int y) {
        this.scaledPosX = x;
        this.scaledPosY = y;
    }

    public void setDragOffset(int x, int y) {
        this.dragOffsetX = x;
        this.dragOffsetY = y;
    }

    public int getBoxPosX() {
        return CommonConfig.currentConfig.curHudPos.offsetX + this.dragOffsetX;
    }

    public int getBoxPosY() {
        return CommonConfig.currentConfig.curHudPos.offsetY + this.dragOffsetY;
    }

    public boolean isMouseOver() {
        return this.hovered;
    }
}

