/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.handler;

import bre.fpsreducer.config.CommonConfig;
import bre.fpsreducer.gui.Hud;
import bre.fpsreducer.utils.ModLib;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OverlayEventHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    private int fpsCounter = 0;
    private long prevUpdateTime = 0L;

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        if (CommonConfig.currentConfig.hudInfo == 0) {
            return;
        }
        ++this.fpsCounter;
        long elapsedTime = System.currentTimeMillis() - this.prevUpdateTime;
        if (elapsedTime >= 1000L) {
            int curFPS = (int)((float)this.fpsCounter * (1000.0f / (float)elapsedTime));
            this.fpsCounter = 0;
            double cpuLoad = CommonConfig.globalConfig.cpuUsageThread == 0 ? ModLib.getThreadCpuUsage(CommonConfig.globalConfig.cpuUsageType == 1) : ModLib.getCpuUsage(CommonConfig.globalConfig.cpuUsageType == 1);
            Hud.getInstance().setFPSCPUData(curFPS, cpuLoad);
            Hud.getInstance().updateHudText();
            this.prevUpdateTime = System.currentTimeMillis();
        }
        if (!this.mc.field_71474_y.field_74330_P) {
            Hud.getInstance().drawHud(event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
        }
    }
}

