/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.handler;

import bre.fpsreducer.config.CommonConfig;
import bre.fpsreducer.handler.KeyBindEventHandler;
import bre.fpsreducer.utils.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class WakeupEventHandler {
    public static WakeupEventHandler INSTANCE = new WakeupEventHandler();
    private Minecraft mc = Minecraft.func_71410_x();
    private int maxFPS = (int)GameSettings.Options.FRAMERATE_LIMIT.func_148267_f();
    private long idleStartTime;
    private int currentGameSettingFPS;
    private float currentGameSettingVolume;
    public static boolean reduceFPS = false;
    private boolean stopSound = false;
    private long prevMouseEventNanoSec;
    private long prevKeyEventNanoSec;
    private long prevMovingEventMilliSec;
    private boolean prevWindowStatus = true;
    private double prevX;
    private double prevY;
    private double prevZ;
    private float prevRotationYaw;
    private float prevRotationPitch;
    private String prevReason = "";

    public WakeupEventHandler() {
        Logger.debug("FRAMERATE_LIMIT.getValueMax()=", this.maxFPS);
    }

    @SubscribeEvent
    public void onMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        int button = Mouse.getEventButton();
        int wheel = Mouse.getEventDWheel();
        if (button != -1 || wheel != 0) {
            this.makeWindowStatusActive();
            this.prevKeyEventNanoSec = Keyboard.getEventNanoseconds();
            this.prevMouseEventNanoSec = Mouse.getEventNanoseconds();
            this.resetWaitingTimer();
            this.recoverFPS("mouse input");
        }
    }

    @SubscribeEvent
    public void onKeyboardInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        this.makeWindowStatusActive();
        this.prevKeyEventNanoSec = Keyboard.getEventNanoseconds();
        this.prevMouseEventNanoSec = Mouse.getEventNanoseconds();
        this.resetWaitingTimer();
        this.recoverFPS("key pressed event");
    }

    private void makeWindowStatusActive() {
        if (!this.prevWindowStatus) {
            Logger.debug("Window has been active. (onInputEvent)");
        }
        this.prevWindowStatus = true;
        this.recoverSound();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.checkWakeupEvent();
        }
    }

    private void checkWakeupEvent() {
        long currentMouseEventNanoSec;
        block23: {
            if (!CommonConfig.currentConfig.enableFpsReducer) {
                this.resetWaitingTimer();
                this.recoverFPS("FPS Reducer disabled");
                return;
            }
            if (CommonConfig.currentConfig.reducingInBackground || CommonConfig.currentConfig.suppressSound) {
                boolean curWindowStatus = Display.isActive();
                if (!curWindowStatus) {
                    if (curWindowStatus != this.prevWindowStatus) {
                        Logger.debug("Window has been inactive. (onClientTick)");
                        this.prevWindowStatus = curWindowStatus;
                        if (CommonConfig.currentConfig.reducingInBackground) {
                            this.reduceFPS("Window has been inactive.");
                        }
                        if (CommonConfig.currentConfig.suppressSound) {
                            this.stopSound();
                        }
                    }
                    if (CommonConfig.currentConfig.reducingInBackground) {
                        return;
                    }
                } else if (curWindowStatus != this.prevWindowStatus) {
                    Logger.debug("Window has been active. (onClientTick)");
                    this.prevKeyEventNanoSec = Keyboard.getEventNanoseconds();
                    this.prevMouseEventNanoSec = Mouse.getEventNanoseconds();
                    this.prevWindowStatus = curWindowStatus;
                    this.recoverSound();
                }
            }
            if (this.mc.field_71441_e == null) {
                this.resetWaitingTimer();
                this.recoverFPS("world is null");
                return;
            }
            long currentKeyEventNanoSec = Keyboard.getEventNanoseconds();
            if (currentKeyEventNanoSec > this.prevKeyEventNanoSec) {
                this.prevKeyEventNanoSec = currentKeyEventNanoSec;
                if (KeyBindEventHandler.forceIdleKeyPressed) {
                    KeyBindEventHandler.forceIdleKeyPressed = false;
                    this.prevKeyEventNanoSec += 500000000L;
                    Logger.debug("force idle key skipped..");
                } else {
                    this.resetWaitingTimer();
                    this.recoverFPS("key input event");
                    return;
                }
            }
            try {
                if (this.mc.field_71439_g.field_71158_b.field_187255_c || this.mc.field_71439_g.field_71158_b.field_187256_d || this.mc.field_71439_g.field_71158_b.field_187258_f || this.mc.field_71439_g.field_71158_b.field_187257_e || this.mc.field_71439_g.field_71158_b.field_78901_c || this.mc.field_71439_g.field_71158_b.field_78899_d) {
                    this.resetWaitingTimer();
                    this.recoverFPS("movement input");
                    return;
                }
            }
            catch (NullPointerException e) {
                if (!CommonConfig.globalConfig.debugLog) break block23;
                e.printStackTrace();
            }
        }
        if ((currentMouseEventNanoSec = Mouse.getEventNanoseconds()) != this.prevMouseEventNanoSec) {
            this.prevMouseEventNanoSec = currentMouseEventNanoSec;
            this.resetWaitingTimer();
            this.recoverFPS("mouse event");
            return;
        }
        if (!CommonConfig.currentConfig.ignoreHoldButton) {
            for (int bc = 0; bc < Mouse.getButtonCount(); ++bc) {
                if (!Mouse.isButtonDown((int)bc)) continue;
                this.resetWaitingTimer();
                this.recoverFPS("keep mouse button pressed");
                break;
            }
        }
        switch (CommonConfig.currentConfig.detectMoving) {
            case 1: {
                if (this.mc.field_71439_g == null || this.mc.field_71439_g.field_70122_E || !this.checkMovingSimply() && !this.checkRotation()) break;
                this.resetWaitingTimer();
                this.recoverFPS("detected movement riding/flying");
                return;
            }
            case 2: {
                if (!this.checkMovingSimply() && !this.checkRotation()) break;
                this.resetWaitingTimer();
                this.recoverFPS("detected movement");
                return;
            }
        }
        this.checkWaitingTimer();
    }

    private boolean checkMoving() {
        int interval = 1000;
        long curMovingEventMilliSec = System.currentTimeMillis();
        if (curMovingEventMilliSec - this.prevMovingEventMilliSec >= 1000L & this.mc.field_71439_g != null) {
            double mx = this.mc.field_71439_g.field_70165_t - this.prevX;
            double my = this.mc.field_71439_g.field_70163_u - this.prevY;
            double mz = this.mc.field_71439_g.field_70161_v - this.prevZ;
            double movement = mx * mx + my * my + mz * mz;
            Logger.debug("movement:" + Math.sqrt(movement));
            this.prevX = this.mc.field_71439_g.field_70165_t;
            this.prevY = this.mc.field_71439_g.field_70163_u;
            this.prevZ = this.mc.field_71439_g.field_70161_v;
            this.prevMovingEventMilliSec = curMovingEventMilliSec;
            double threshold = 0.9;
            return movement >= threshold * threshold;
        }
        return false;
    }

    private boolean checkMovingSimply() {
        if (this.mc.field_71439_g != null && (this.prevX != this.mc.field_71439_g.field_70165_t || this.prevY != this.mc.field_71439_g.field_70163_u || this.prevZ != this.mc.field_71439_g.field_70161_v)) {
            this.prevX = this.mc.field_71439_g.field_70165_t;
            this.prevY = this.mc.field_71439_g.field_70163_u;
            this.prevZ = this.mc.field_71439_g.field_70161_v;
            return true;
        }
        return false;
    }

    private boolean checkRotation() {
        if (this.mc.field_71439_g != null && (this.prevRotationYaw != this.mc.field_71439_g.field_70177_z || this.prevRotationPitch != this.mc.field_71439_g.field_70125_A)) {
            this.prevRotationYaw = this.mc.field_71439_g.field_70177_z;
            this.prevRotationPitch = this.mc.field_71439_g.field_70125_A;
            return true;
        }
        return false;
    }

    private void resetWaitingTimer() {
        this.idleStartTime = System.currentTimeMillis();
    }

    private void checkWaitingTimer() {
        if (!reduceFPS && CommonConfig.currentConfig.waitingTime != 0 && System.currentTimeMillis() - this.idleStartTime > (long)(CommonConfig.currentConfig.waitingTime * 1000)) {
            this.reduceFPS("Waiting time has been expired.");
        }
    }

    private void reduceFPS(String reason) {
        if (!reduceFPS) {
            this.currentGameSettingFPS = this.mc.field_71474_y.field_74350_i;
            this.mc.field_71474_y.field_74350_i = CommonConfig.currentConfig.idleFPS;
            reduceFPS = true;
            this.loggingReduceFps(reason);
        }
    }

    private void recoverFPS(String reason) {
        if (reduceFPS) {
            this.mc.field_71474_y.field_74350_i = this.currentGameSettingFPS;
            reduceFPS = false;
            this.loggingRecoverFps(reason);
        }
    }

    private void loggingReduceFps(String reason) {
        if (CommonConfig.globalConfig.debugLog && !this.prevReason.equals(reason)) {
            this.prevReason = reason;
            Logger.debug("Reducing max FPS: ", this.mc.field_71474_y.field_74350_i, " (reason: ", reason, ")");
        }
    }

    private void loggingRecoverFps(String reason) {
        if (CommonConfig.globalConfig.debugLog && !this.prevReason.equals(reason)) {
            this.prevReason = reason;
            int framerateLimit = this.mc.field_71474_y.field_74350_i;
            if (framerateLimit == this.maxFPS) {
                Logger.debug("Recovering max FPS: Unlimited (reason: ", reason, ")");
            } else {
                Logger.debug("Recovering max FPS: ", framerateLimit, " (reason: ", reason, ")");
            }
        }
    }

    public void forceReduceFPS(String reason) {
        this.reduceFPS("[force reduce] " + reason);
    }

    public void forceRecoverFPS(String reason) {
        reduceFPS = true;
        this.recoverFPS("[force recover] " + reason);
    }

    private void stopSound() {
        if (!this.stopSound) {
            this.currentGameSettingVolume = this.mc.field_71474_y.func_186711_a(SoundCategory.MASTER);
            float newVolume = this.currentGameSettingVolume * (float)CommonConfig.currentConfig.suppressedVolume / 100.0f;
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, newVolume);
            this.stopSound = true;
            Logger.debug("Suppressing master volume: ", (int)(newVolume * 100.0f));
        }
    }

    private void recoverSound() {
        if (this.stopSound) {
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, this.currentGameSettingVolume);
            this.stopSound = false;
            Logger.debug("Recovering master volume: ", (int)(this.currentGameSettingVolume * 100.0f));
        }
    }

    private int getWaitingTimeSecond() {
        return (int)(System.currentTimeMillis() - this.idleStartTime) / 1000;
    }
}

