/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.config;

import bre2el.fpsreducer.util.Logger;
import com.electronwill.nightconfig.core.CommentedConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    protected static final String configDirName = "fpsreducer";

    protected static int hexToDec(ForgeConfigSpec.ConfigValue<String> hexStringVal, int defaultVal) {
        int intValue;
        try {
            intValue = Integer.parseInt((String)hexStringVal.get(), 16);
        }
        catch (NumberFormatException ne) {
            Logger.error("Parsing configuration error: " + CommonConfig.getPath(hexStringVal));
            return defaultVal;
        }
        return intValue;
    }

    protected static String decToHex(int intValue) {
        String hexString = String.format("%06x", intValue);
        return hexString;
    }

    protected static <T> String getPath(ForgeConfigSpec.ConfigValue<T> configValue) {
        String path = String.join((CharSequence)".", configValue.getPath());
        return path;
    }

    public static class Common {
        public CommentedConfig configData;
        public boolean enableFpsReducer;
        public int waitingTime;
        public int idleFps;
        public int detectMoving;
        public static final int DETECTMOVING_OFF = 0;
        public static final int DETECTMOVING_RIDING_FLYING = 1;
        public static final int DETECTMOVING_ON = 2;
        public boolean ignoreHoldButton;
        public boolean reducingInBackground;
        public boolean suppressSound;
        public int suppressedVolume;
        public int hudLocation;
        public double hudScale;
        public int hudBehindChatBox;
        public static final int HUD_BEFIND_CHATBOX_KEEP = 0;
        public static final int HUD_BEHIND_CHATBOX_OFF = 1;
        public static final int HUD_BEHIND_CHATBOX_DODGE = 2;
        private final ForgeConfigSpec.BooleanValue enableFpsReducerVal;
        private final ForgeConfigSpec.IntValue waitingTimeVal;
        private final ForgeConfigSpec.IntValue idleFpsVal;
        private final ForgeConfigSpec.IntValue detectMovingVal;
        private final ForgeConfigSpec.BooleanValue ignoreHoldButtonVal;
        private final ForgeConfigSpec.BooleanValue reducingInBackgroundVal;
        private final ForgeConfigSpec.BooleanValue suppressSoundVal;
        private final ForgeConfigSpec.IntValue suppressedVolumeVal;
        private final ForgeConfigSpec.IntValue hudLocationVal;
        private final ForgeConfigSpec.DoubleValue hudScaleVal;
        private final ForgeConfigSpec.IntValue hudBehindChatBoxVal;
        protected final String config = "fpsreducer.config.";

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General options").push("general");
            this.enableFpsReducerVal = builder.comment("Enable reducing FPS when no user activity has been sensed for a certain time.").translation("fpsreducer.config.enableFpsReducer").define("enableFpsReducer", true);
            this.waitingTimeVal = builder.comment("Waiting time(sec) until reducing FPS.").translation("fpsreducer.config.waitingTime").defineInRange("waitingTime", 300, 0, 86400);
            this.idleFpsVal = builder.comment("Frame rate during reducing.").translation("fpsreducer.config.idleFps").defineInRange("idleFps", 10, 0, 60);
            this.detectMovingVal = builder.comment("Detect movement of player position. (0:OFF, 1:Riding/Flying, 2:Always)").translation("fpsreducer.config.detectMoving").defineInRange("detectMoving", 1, 0, 2);
            this.ignoreHoldButtonVal = builder.comment("Ignore the mouse button holding.").translation("fpsreducer.config.ignoreHoldButton").define("ignoreHoldButton", false);
            this.reducingInBackgroundVal = builder.comment("Force reducing FPS if the window is inactive.").translation("fpsreducer.config.reducingInBackground").define("reducingInBackground", false);
            this.suppressSoundVal = builder.comment("Suppress master volume if the window is inactive.").translation("fpsreducer.config.suppressSound").define("suppressSound", false);
            this.suppressedVolumeVal = builder.comment("Suppression master volume ratio in inactive (0-100).").translation("fpsreducer.config.suppressedVolume").defineInRange("suppressedVolume", 10, 0, 100);
            this.hudLocationVal = builder.comment("Display the status and the current FPS at the specified location.\n(0:off, 1:top-left, 2:top-right, 3:bottom-right, 4:bottom-left)").translation("fpsreducer.config.hudLocation").defineInRange("hudLocation", 2, 0, 4);
            this.hudScaleVal = builder.comment("HUD scale (default: 1.0)").translation("fpsreducer.config.hudScale").defineInRange("hudScale", 1.0, 0.1, 2.0);
            this.hudBehindChatBoxVal = builder.comment("Behavior of HUD display when a chat window opened. (0:keep to display, 1:off, 2:dodge a chat box)").translation("fpsreducer.config.hudBehindChatBox").defineInRange("hudBehindChatBox", 2, 0, 2);
            builder.pop();
        }

        public void readFromConfigData() {
            this.enableFpsReducer = (Boolean)this.enableFpsReducerVal.get();
            this.waitingTime = (Integer)this.waitingTimeVal.get();
            this.idleFps = (Integer)this.idleFpsVal.get();
            this.detectMoving = (Integer)this.detectMovingVal.get();
            this.ignoreHoldButton = (Boolean)this.ignoreHoldButtonVal.get();
            this.reducingInBackground = (Boolean)this.reducingInBackgroundVal.get();
            this.suppressSound = (Boolean)this.suppressSoundVal.get();
            this.suppressedVolume = (Integer)this.suppressedVolumeVal.get();
            this.hudLocation = (Integer)this.hudLocationVal.get();
            this.hudScale = (Double)this.hudScaleVal.get();
            this.hudBehindChatBox = (Integer)this.hudBehindChatBoxVal.get();
        }

        public void writeToConfigData() {
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.enableFpsReducerVal, this.enableFpsReducer);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.waitingTimeVal, this.waitingTime);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.idleFpsVal, this.idleFps);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.detectMovingVal, this.detectMoving);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.ignoreHoldButtonVal, this.ignoreHoldButton);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.reducingInBackgroundVal, this.reducingInBackground);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.suppressSoundVal, this.suppressSound);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.suppressedVolumeVal, this.suppressedVolume);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.hudLocationVal, this.hudLocation);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.hudScaleVal, this.hudScale);
            this.setIfModified((ForgeConfigSpec.ConfigValue)this.hudBehindChatBoxVal, this.hudBehindChatBox);
        }

        protected <T> void setIfModified(ForgeConfigSpec.ConfigValue<T> configValue, T value) {
            if (value != null && !value.equals(configValue.get())) {
                Logger.debug("Config changed: ", CommonConfig.getPath(configValue), " ", configValue.get(), "->", value);
                this.configData.set(CommonConfig.getPath(configValue), value);
            }
        }
    }
}

