/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.config;

import bre2el.fpsreducer.config.CommonConfig;
import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.util.Logger;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;

public class GlobalConfig
extends CommonConfig {
    private static final ForgeConfigSpec globalSpec;
    private static final Global GLOBAL;
    private static boolean configLoaded;

    public static void registerConfig() {
        File configDir = FMLPaths.CONFIGDIR.get().resolve("fpsreducer").toFile();
        if (configDir.getParentFile() != null) {
            configDir.mkdirs();
            GlobalConfig.moveOldConfigFile();
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, globalSpec, "fpsreducer" + File.separator + GlobalConfig.getGlobalConfigFileName());
        FMLJavaModLoadingContext.get().getModEventBus().register(GlobalConfig.class);
    }

    private static String getGlobalConfigFileName() {
        return String.format("%s-%s.toml", "fpsreducer", ModConfig.Type.CLIENT.extension());
    }

    private static void moveOldConfigFile() {
        File oldConfigFile = FMLPaths.CONFIGDIR.get().resolve(GlobalConfig.getGlobalConfigFileName()).toFile();
        if (oldConfigFile.exists()) {
            File destFile = FMLPaths.CONFIGDIR.get().resolve("fpsreducer" + File.separator + GlobalConfig.getGlobalConfigFileName()).toFile();
            if (!destFile.exists()) {
                oldConfigFile.renameTo(destFile);
            } else {
                File backupFile = FMLPaths.CONFIGDIR.get().resolve("fpsreducer" + File.separator + "oldConfig.bak").toFile();
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                oldConfigFile.renameTo(backupFile);
            }
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.CLIENT) {
            ModConfig modConfig = configEvent.getConfig();
            if (modConfig.getSpec() == globalSpec) {
                GlobalConfig.GLOBAL.configData = modConfig.getConfigData();
                GLOBAL.readFromConfigData();
                Logger.debug("Global config file loaded.");
                configLoaded = true;
            }
            Config.initCurrentConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onFileChange(ModConfig.ConfigReloading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.CLIENT) {
            ModConfig modConfig = configEvent.getConfig();
            if (configLoaded && modConfig.getSpec() == globalSpec) {
                Global global = GLOBAL;
                synchronized (global) {
                    if (modConfig.getConfigData() instanceof CommentedFileConfig) {
                        ((CommentedFileConfig)modConfig.getConfigData()).load();
                        GLOBAL.readFromConfigData();
                        Logger.debug("Global config file got changed on the file system.");
                    }
                }
            }
        }
    }

    static {
        Pair globalSpecPair = new ForgeConfigSpec.Builder().configure(Global::new);
        globalSpec = (ForgeConfigSpec)globalSpecPair.getRight();
        Config.GLOBAL = GLOBAL = (Global)globalSpecPair.getLeft();
    }

    public static class Global
    extends CommonConfig.Common {
        public int hudMarginX;
        public int hudMarginY;
        public int hudColor;
        public String hudPreText;
        public int hudReductionColor;
        public String hudReductionPreText;
        public boolean allowPlayerConfig;
        public boolean debugLog;
        public boolean logInChat;
        private final ForgeConfigSpec.IntValue hudMarginXVal;
        private final ForgeConfigSpec.IntValue hudMarginYVal;
        private final ForgeConfigSpec.ConfigValue<String> hudColorVal;
        private final ForgeConfigSpec.ConfigValue<String> hudPreTextVal;
        private final ForgeConfigSpec.ConfigValue<String> hudReductionColorVal;
        private final ForgeConfigSpec.ConfigValue<String> hudReductionPreTextVal;
        private final ForgeConfigSpec.BooleanValue allowPersonalConfigVal;
        private final ForgeConfigSpec.BooleanValue debugLogVal;
        private final ForgeConfigSpec.BooleanValue logInChatVal;

        Global(ForgeConfigSpec.Builder builder) {
            super(builder);
            builder.comment("Extra options").push("extra");
            this.hudMarginXVal = builder.comment("X margin of HUD position from the corner of the screen.").translation("fpsreducer.config.hudMarginX").defineInRange("hudMarginX", 2, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudMarginYVal = builder.comment("Y margin of HUD position from the corner of the screen.").translation("fpsreducer.config.hudMarginY").defineInRange("hudMarginY", 2, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudColorVal = builder.comment("HUD color").translation("fpsreducer.config.hudColor").define("hudColor", (Object)"f0f0f0");
            this.hudPreTextVal = builder.comment("Pre-text of FPS display.").translation("fpsreducer.config.hudPreText").define("hudPreText", (Object)"FPS: ");
            this.hudReductionColorVal = builder.comment("Reduced fps HUD color").translation("fpsreducer.config.hudReductionColor").define("hudReductionColor", (Object)"00ff00");
            this.hudReductionPreTextVal = builder.comment("Pre-text of reduced FPS display.").translation("fpsreducer.config.hudReductionPreText").define("hudReductionPreText", (Object)"ECO MODE: ");
            this.allowPersonalConfigVal = builder.comment("Allow player configuration mode.").translation("fpsreducer.config.allowPlayerConfig").define("allowPlayerConfig", true);
            builder.pop();
            builder.comment("Debug options").push("debug");
            this.debugLogVal = builder.comment("Enable debug log").translation("fpsreducer.config.debugLog").define("debugLog", false);
            this.logInChatVal = builder.comment("Show event log on the game screen.").translation("fpsreducer.config.logInChat").define("logInChat", false);
            builder.pop();
        }

        @Override
        public void readFromConfigData() {
            super.readFromConfigData();
            this.hudMarginX = (Integer)this.hudMarginXVal.get();
            this.hudMarginY = (Integer)this.hudMarginYVal.get();
            this.hudColor = CommonConfig.hexToDec(this.hudColorVal, 0xF0F0F0);
            this.hudPreText = (String)this.hudPreTextVal.get();
            this.hudReductionColor = CommonConfig.hexToDec(this.hudReductionColorVal, 65280);
            this.hudReductionPreText = (String)this.hudReductionPreTextVal.get();
            this.allowPlayerConfig = (Boolean)this.allowPersonalConfigVal.get();
            this.debugLog = (Boolean)this.debugLogVal.get();
            this.logInChat = (Boolean)this.logInChatVal.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToConfigData() {
            Global global = this;
            synchronized (global) {
                super.writeToConfigData();
                this.setIfModified(this.hudMarginXVal, this.hudMarginX);
                this.setIfModified(this.hudMarginYVal, this.hudMarginY);
                this.setIfModified(this.hudColorVal, CommonConfig.decToHex(this.hudColor));
                this.setIfModified(this.hudPreTextVal, this.hudPreText);
                this.setIfModified(this.hudReductionColorVal, CommonConfig.decToHex(this.hudReductionColor));
                this.setIfModified(this.hudReductionPreTextVal, this.hudReductionPreText);
                this.setIfModified(this.allowPersonalConfigVal, this.allowPlayerConfig);
                this.setIfModified(this.debugLogVal, this.debugLog);
                this.setIfModified(this.logInChatVal, this.logInChat);
            }
        }
    }
}

