/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui;

import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiSliderFlexibleTime
extends GuiSlider {
    private GuiSlider.ISlider releasedHandler;
    private static final int[] minSec = new int[]{1, 15, 90, 360, 900};
    private static final int[] maxSec = new int[]{10, 60, 300, 600, 3600};
    private static final int[] minVal = new int[]{1, 11, 21, 29, 34};
    private static final int[] maxVal = new int[]{10, 20, 28, 33, 43};

    public static GuiSliderFlexibleTime getInstance(int id, int xPos, int yPos, int width, int height, String prefix, int currentSec, GuiSlider.ISlider draggingHandler, GuiSlider.ISlider releasedHandler) {
        double currentVal = GuiSliderFlexibleTime.time2Val(currentSec);
        GuiSliderFlexibleTime instance = new GuiSliderFlexibleTime(id, xPos, yPos, width, height, prefix, currentVal, draggingHandler, releasedHandler);
        return instance;
    }

    private GuiSliderFlexibleTime(int id, int xPos, int yPos, int width, int height, String prefix, double currentVal, GuiSlider.ISlider draggingHandler, GuiSlider.ISlider releasedHandler) {
        super(id, xPos, yPos, width, height, prefix, null, 1.0, 43.0, currentVal, false, true, draggingHandler);
        this.releasedHandler = releasedHandler;
        this.setText(this.val2Time(currentVal));
    }

    public void func_194831_b(double mouseX, double mouseY) {
        super.func_194831_b(mouseX, mouseY);
        this.releasedHandler.onChangeSliderValue((GuiSlider)this);
    }

    private void setText(int time) {
        if (this.drawString) {
            this.field_146126_j = String.format("%s%02d:%02d", this.dispString, time / 60, time % 60);
        }
    }

    public void updateSlider() {
        super.updateSlider();
        int val = (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
        int time = this.val2Time(val);
        this.setText(time);
    }

    public int getTimeSec() {
        int val = this.getValueInt();
        return this.val2Time(val);
    }

    private int val2Time(double val) {
        int idx = 0;
        for (int i = 0; i < maxVal.length; ++i) {
            if (!(val <= (double)maxVal[i])) continue;
            idx = i;
            break;
        }
        double time = (double)minSec[idx] + (val - (double)minVal[idx]) * ((double)(maxSec[idx] - minSec[idx]) / (double)(maxVal[idx] - minVal[idx]));
        return (int)Math.round(time);
    }

    private static double time2Val(int sec) {
        int idx = 0;
        for (int i = 0; i < maxSec.length; ++i) {
            if (sec > maxSec[i]) continue;
            idx = i;
            break;
        }
        double val = (double)(sec - minSec[idx]) / (double)(maxSec[idx] - minSec[idx]) * (double)(maxVal[idx] - minVal[idx]) + (double)minVal[idx];
        return val;
    }
}

